//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using System.IO;

namespace Framefield.Core.IDa501a86c_40b2_4574_a660_757025b9b5ee
{
    public class Class_LoadFBX : OperatorPart.Function,
                                 Framefield.Core.OperatorPartTraits.IMeshSupplier
    {
        // IMeshSupplier
        public void AddMeshesTo(ICollection<Mesh> meshes)
        {
            UpdateMesh(new OperatorPartContext(), OperatorPart.Connections);
            meshes.Add(_mesh);
        }

        //>>> _inputids
        private enum InputId
        {
            FilePath = 0,
            ChildID = 1,
            UnitScale = 2,
            IncludeTransform = 3
        }
        //<<< _inputids

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _fbxResource);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            UpdateMesh(context, inputs);

            if (_mesh != null)
            {
                context.Renderer.SetupEffect(context);
                context.Renderer.Render(_mesh, context);
            }

            return context;
        }

        private void UpdateMesh(OperatorPartContext context, IList<OperatorPart> inputs)
        {
            if (!Changed) 
                return;

            //>>> _params
            var FilePath = inputs[(int)InputId.FilePath].Eval(context).Text;
            var ChildID = inputs[(int)InputId.ChildID].Eval(context).Value;
            var UnitScale = inputs[(int)InputId.UnitScale].Eval(context).Value;
            var IncludeTransform = (int) inputs[(int)InputId.IncludeTransform].Eval(context).Value;
            //<<< _params

            var includeTransformMatrix = IncludeTransform < 0.5f ? true : false;

            if (File.Exists(FilePath))
            {
                if (_fbxResource == null || FilePath != _filePath || includeTransformMatrix != _includeTransformMatrix)
                {
                    _includeTransformMatrix = includeTransformMatrix; 
                    _fbxResource = ResourceManager.ReadFbx(FilePath, includeTransformMatrix);
                    _filePath = FilePath;
                }
            }
            else
            {
                Logger.Error(this,"Fbxfile not found '{0}'", FilePath);
                _filePath = String.Empty;
            }

            if (_fbxResource != null)
            {
            
                _mesh = _fbxResource.GetChild((int)ChildID, UnitScale);
            }

            Changed = false;
        }

        private FbxResource _fbxResource;
        private string _filePath;
        private Mesh _mesh;
        private bool _includeTransformMatrix = false;
    }
}