//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID111562d0_805d_4a6e_892c_10b0aa79e746
{
    public class Class_BlendImagesBetter : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            ImageA = 1,
            ImageB = 2,
            ColorMode = 3,
            AlphaMode = 4,
            ImageBIntensity = 5
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> _params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var ImageA = inputs[(int)InputId.ImageA].Eval(context).Image; // Needs to be checked for null!
                var ImageB = inputs[(int)InputId.ImageB].Eval(context).Image; // Needs to be checked for null!
                var ColorMode = (int) inputs[(int)InputId.ColorMode].Eval(context).Value;
                var AlphaMode = (int) inputs[(int)InputId.AlphaMode].Eval(context).Value;
                var ImageBIntensity = inputs[(int)InputId.ImageBIntensity].Eval(context).Value;
                //<<< _params

                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));
                if(ImageA == null || ImageB == null) {
                    Logger.Warn(this, "BlendImages requires two images");
                }

                if(ImageA != null || ImageB != null) {
                //>>> _setup
                using (var ImageAView = new ShaderResourceView(context.D3DDevice, ImageA))
                using (var ImageBView = new ShaderResourceView(context.D3DDevice, ImageB))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("ImageA").AsShaderResource().SetResource(ImageAView);
                    _effect.GetVariableByName("ImageB").AsShaderResource().SetResource(ImageBView);
                    _effect.GetVariableByName("ColorMode").AsScalar().Set(ColorMode);
                    _effect.GetVariableByName("AlphaMode").AsScalar().Set(AlphaMode);
                    _effect.GetVariableByName("ImageBIntensity").AsScalar().Set(ImageBIntensity);
                        //<<< _setup
        
                        Render(context);
                    }
                    
                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

