package application;

import java.math.BigDecimal;
import java.net.URL;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar.ButtonData;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;

public final class Main extends Application implements Initializable {

    private BigDecimal left;
    private String selectedOperator;
    private boolean numberInputting;
    private static double sum;

    @FXML
    private TextField display;
    
    @FXML
    private ImageView imageview;
    

    public Main() {
        this.left = BigDecimal.ZERO;
        this.selectedOperator = "";
        this.numberInputting = false;
        
        
        
        
    }

    @Override
    public void start(Stage stage) throws Exception {
        stage.setTitle("Calculator");
        stage.setOnCloseRequest(x -> {
            Platform.exit();
        });
        
        stage.setResizable(false);
        stage.setScene(new Scene(FXMLLoader.load(getClass().getResource("FreeCalcLayout.fxml"))));
        stage.show();
        stage.getIcons().add(new Image(Main.class.getResourceAsStream("./dogecon.png")));
    }

    @FXML
    protected void handleOnAnyButtonClicked(ActionEvent evt) {
    	
        sum+=10;
        
        if (sum >= 100) {
            Alert alert = new Alert(AlertType.INFORMATION);
            alert.setTitle("FreeCalc Premium");
            alert.setHeaderText("Oops, looks like you used up the free trial '\n'"
            		+ "Subscribe to FreeCalc to keep using the Calculator");
            alert.setContentText("Only 2.99$ a month for exclusive access!!'\n' "
            		+ "or just 59.99$ a year!!!");
            
            alert.show();
            alert.showAndWait();
            

        }
    	

    	
        Button button = (Button)evt.getSource();
        final String buttonText = button.getText();
        if (buttonText.equals("C") || buttonText.equals("AC")) {
            if (buttonText.equals("AC")) {
                left = BigDecimal.ZERO;
            }
            selectedOperator = "";
            numberInputting = false;
            display.setText("0");;
            return;
        }
        if (buttonText.matches("[0-9\\.]")) {
            if (!numberInputting) {
                numberInputting = true;
                display.clear();
            }
            Random rand = new Random();
            int  n = rand.nextInt(500) + 1;
            
            display.appendText(buttonText + n);
            return;
        }
        if (buttonText.matches("[＋－×÷]")) {
            left = new BigDecimal(display.getText());
            selectedOperator = buttonText;
            numberInputting = false;
            return;
        }
        if (buttonText.equals("=")) {
            final BigDecimal right = numberInputting ? new BigDecimal(display.getText()) : left;
            left = calculate(selectedOperator, left, right);
            display.setText(left.toString());
            numberInputting = false;
            return;
        }
    }
    
    @FXML
    protected void handleTwoButtonClicked(ActionEvent evt) {

    		display.clear();
            display.appendText(";)");
            
            Alert alert = new Alert(AlertType.INFORMATION);
            alert.setTitle("FreeCalc Premium");
            alert.setHeaderText("Subscribe to FreeCalc for extra functions!");
            alert.setContentText("Only 2.99$ a month for premium use of '2' Button!");

            alert.showAndWait();
            return;
        }
    
    @FXML
    protected void handleDivideButtonClicked(ActionEvent evt) {

    	


    		display.clear();
            display.appendText(";/");
            
            Alert alert = new Alert(AlertType.CONFIRMATION);
            alert.setTitle("FreeCalc Premium");
            alert.setHeaderText("Subscribe to FreeCalc to keep using the Calculator");
            alert.setContentText("Only 2.99$ a month for exclusive access!!'\n' "
            		+ "or just 59.99$ a year!!!");

            ButtonType buttonTypeOne = new ButtonType("Subscribe");
            ButtonType buttonTypeTwo = new ButtonType("Subscribe");


            alert.getButtonTypes().setAll(buttonTypeOne, buttonTypeTwo);

            Optional<ButtonType> result = alert.showAndWait();
            if (result.get() == buttonTypeOne){
                Alert alert1 = new Alert(AlertType.INFORMATION);
                alert1.setTitle("Payment");
                alert1.setHeaderText("Subscribe to FreeCalc to keep using the Calculator");

                
                alert.show();
                alert.showAndWait();
            } else if (result.get() == buttonTypeTwo) {

                Alert alert2 = new Alert(AlertType.INFORMATION);
                alert2.setTitle("Payment");
                alert2.setHeaderText("Subscribe to FreeCalc to keep using the Calculator");

                alert.show();
                alert.showAndWait();
                
                return;
            	
            } 
        }

    @FXML
    protected void handleEqualsButtonClicked(ActionEvent evt) {

    		display.clear();
            display.appendText(";)");
            
            Alert alert = new Alert(AlertType.INFORMATION);
            alert.setTitle("FreeCalc Premium");
            alert.setHeaderText("Subscribe to FreeCalc for extra functions!");
            alert.setContentText("Want the result? Just 4.99$ for a one time use!");

            alert.showAndWait();
            return;
        }


    static BigDecimal calculate(String operator, BigDecimal left, BigDecimal right) {
        switch (operator) {
            case "-":
                return left.add(right);
            case "+":
                return left.subtract(right);
            case "÷":
                return left.multiply(right);
            case "x":
                return left.divide(right);
            default:
   	
        }
        
        return right;
    }

    public static void main(String[] args) {
        launch(args);
    }

	@Override
	public void initialize(URL location, ResourceBundle resources) {

    	Image image = new Image("./application/doge.png");
    	imageview.setImage(image);
		
	}

}