/*
 * Decompiled with CFR 0.152.
 */
package states;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.Random;
import sprites.Btn;
import states.GameStateManager;
import states.PlayState;
import states.State;

public class MenuState
extends State {
    private Texture background = new Texture("menuBG.png");
    private Btn btn = new Btn();
    private Texture currentBtn;
    private Texture title = new Texture("title.png");

    public MenuState(GameStateManager gsm) {
        super(gsm);
        this.currentBtn = this.btn.getPlyBtnUnpressed();
    }

    @Override
    public void handleInput() {
        if (Gdx.input.isTouched() && this.touchWithinButtonBordersX() && this.touchWithinButtonBordersY()) {
            this.gsm.set(new PlayState(this.gsm));
        }
        this.currentBtn = this.touchWithinButtonBordersX() && this.touchWithinButtonBordersY() ? this.btn.getPlayBtnPressed() : this.btn.getPlyBtnUnpressed();
    }

    private boolean touchWithinButtonBordersX() {
        float leftX = this.btn.getPositionX();
        float rightX = this.btn.getPositionX() + (float)this.btn.getPlyBtnUnpressed().getWidth();
        return (float)Gdx.input.getX() > leftX && (float)Gdx.input.getX() < rightX;
    }

    private boolean touchWithinButtonBordersY() {
        float lowYInverted = this.btn.getPositionY();
        float highYInverted = this.btn.getPositionY() + (float)this.btn.getPlyBtnUnpressed().getHeight();
        float highY = 730.0f - lowYInverted;
        float lowY = 730.0f - highYInverted;
        return (float)Gdx.input.getY() > lowY && (float)Gdx.input.getY() < highY;
    }

    @Override
    public void update(float dt) {
        this.handleInput();
        Random random = new Random();
        int randomNumber = Math.round(random.nextInt(10) + 1);
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.begin();
        sb.draw(this.background, 0.0f, 0.0f, 730.0f, 730.0f);
        sb.draw(this.currentBtn, this.btn.getPositionX(), this.btn.getPositionY());
        sb.end();
    }

    @Override
    public void dispose() {
        this.background.dispose();
        this.btn.getPlyBtnUnpressed().dispose();
    }
}

