/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.AudioSample;
import com.jsyn.data.Function;

public class FloatSample
extends AudioSample
implements Function {
    private float[] buffer;

    public FloatSample() {
    }

    public FloatSample(int n) {
        this(n, 1);
    }

    public FloatSample(float[] fArray) {
        this(fArray.length, 1);
        this.write(fArray);
    }

    public FloatSample(float[] fArray, int n) {
        this(fArray.length / n, n);
        this.write(fArray);
    }

    public FloatSample(int n, int n2) {
        this.allocate(n, n2);
    }

    @Override
    public void allocate(int n, int n2) {
        this.buffer = new float[n * n2];
        this.numFrames = n;
        this.channelsPerFrame = n2;
    }

    public void write(int n, float[] fArray, int n2, int n3) {
        int n4 = n3 * this.channelsPerFrame;
        int n5 = n * this.channelsPerFrame;
        System.arraycopy(fArray, n2, this.buffer, n5, n4);
    }

    public void read(int n, float[] fArray, int n2, int n3) {
        int n4 = n3 * this.channelsPerFrame;
        int n5 = n * this.channelsPerFrame;
        System.arraycopy(this.buffer, n5, fArray, n2, n4);
    }

    public void write(float[] fArray) {
        this.write(0, fArray, 0, fArray.length / this.getChannelsPerFrame());
    }

    public void read(float[] fArray) {
        this.read(0, fArray, 0, fArray.length / this.getChannelsPerFrame());
    }

    @Override
    public double readDouble(int n) {
        return this.buffer[n];
    }

    @Override
    public void writeDouble(int n, double d) {
        this.buffer[n] = (float)d;
    }

    public double interpolate(double d) {
        int n = (int)d;
        float f = (float)(d - (double)n);
        float f2 = this.buffer[n];
        float f3 = this.buffer[n + 1];
        return (f3 - f2) * f + f2;
    }

    @Override
    public double evaluate(double d) {
        double d2 = (d + 1.0) * 0.5;
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > 1.0) {
            d2 = 1.0;
        }
        double d3 = ((double)this.getNumFrames() - 1.01) * d2;
        return this.interpolate(d3);
    }
}

