from PIL import Image, ImageDraw
import math

# ZX Spectrum image(s) drawn in Python
# image for Speccy.pl party 2018.01: "Rainbow Dragon"
# (c)2018 MoNsTeR/GDC, Noniewicz.com, Jakub Noniewicz
# cre: 20180405
# upd: 20180406, 07


canvas = (256, 192) # size of image
step = 8
c = math.pi/180

# ZX colors
C_0 = 192
C_1 = 252
ZXC0 = [(0,0,0), (0,0,C_0), (C_0,0,0), (C_0,0,C_0), (0,C_0,0), (0,C_0,C_0), (C_0,C_0,0), (C_0,C_0,C_0)]
ZXC1 = [(0,0,0), (0,0,C_1), (C_1,0,0), (C_1,0,C_1), (0,C_1,0), (0,C_1,C_1), (C_1,C_1,0), (C_1,C_1,C_1)]

def circle(draw, x, y, r, fill, outline):
    xy = [(x-r, y-r), (x+r, y+r)]
    draw.ellipse(xy, fill=fill, outline=outline)

def paint1(draw):
    for r in range(18):
        for n in range(8):
            nn = (r+n)%8
            cx = ZXC1[nn]
            da = 360/8*c
            x = 128+step*(5+r)*math.cos(n*da+r*72*c)
            y = 96+step*(5+r)*math.sin(n*da+r*72*c)
            circle(draw, x, y, 32+1-1.9*r, fill=(cx), outline=None)

def call_painter(png):
    im = Image.new('RGBA', canvas, (0, 0, 0, 255))
    draw = ImageDraw.Draw(im)
    paint1(draw)
    im.save(png)

# ---

call_painter('zx-RainbowDragon.png')
