/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;

public class cloud
extends PApplet {
    Moonlander moonlander;
    float time_now = 0.0f;
    float demo_duration = 69.0f;
    float demo_progress = 0.0f;
    int frame_rate = 60;
    int palette_size = 15;
    int[] palette;
    Cloud[] clouds;
    int cloud_amount = 8;
    float cloud_stroke_alpha = 0.8f;
    float cloud_radius_max = 0.0f;
    float cloud_radius_min = 0.0f;
    float cloud_speed = 0.45f;
    int blue_sky = 0;
    int sea_color = 0;
    PVector wind = new PVector(-1.0f, -0.3f, 0.0f);
    Sea blue_sea;
    PShape sea_quad;
    float sea_angle = 0.0f;
    int sea_scale = this.width;
    PVector sun_color = new PVector(200.0f, 200.0f, 180.0f);
    PVector sun_dir = new PVector(0.3f, 1.0f, 0.0f);
    PVector air_color = new PVector(200.0f, 200.0f, 200.0f);
    float gravity_y = 0.0f;
    PVector gravity;
    PGraphics font_buffer;
    boolean font_buffer_written = false;
    PFont greeting_font;
    PShape greeting_cube;
    int greeting_back_color = this.color(100, 240, 140);
    int greeting_letter_color = this.color(10, 10, 10);
    int greeting_texture_width = 200;
    int greeting_texture_height = 200;
    int letter_cube_scale = 0;
    float letter_velo_x = 0.0f;
    float letter_velo_y = 0.0f;
    float letter_velo_z = 0.0f;
    PVector greeting_velocity;
    PVector greeting_start;
    float greeting_z_min;
    float greeting_z_max;
    float greeting_x_max;
    float greeting_x_min;
    float greeting_rot_x;
    float greeting_rot_y;
    float greeting_rot_z;
    ArrayList<Greeting> greetings;

    public Greeting create_greeting(String text, PFont font_object) {
        Greeting greeting = new Greeting();
        greeting.position = this.greeting_start.copy();
        greeting.position.x += this.random(this.greeting_x_min, this.greeting_x_max);
        greeting.position.z += this.random(this.greeting_z_min, this.greeting_z_max);
        greeting.velocity = this.greeting_velocity;
        greeting.letters = new ArrayList();
        int cube_color = this.palette[PApplet.parseInt((float)this.random(this.palette_size))];
        int character = 0;
        while (character < text.length()) {
            greeting.letters.add(new Letter(this.create_text_cube(text.charAt(character), cube_color, this.greeting_font)));
            ++character;
        }
        return greeting;
    }

    public PShape create_text_cube(char text, int cube_color, PFont font_object) {
        int uv_w = this.greeting_texture_width;
        int uv_h = this.greeting_texture_height;
        PGraphics font_buffer = this.createGraphics(this.greeting_texture_width, this.greeting_texture_height);
        font_buffer.beginDraw();
        font_buffer.background(cube_color);
        font_buffer.fill(this.greeting_letter_color);
        font_buffer.textFont(font_object);
        font_buffer.textAlign(3, 3);
        font_buffer.text(text, (float)(this.greeting_texture_width / 2), (float)(this.greeting_texture_height / 2));
        font_buffer.endDraw();
        this.greeting_cube = this.createShape();
        this.greeting_cube.beginShape(16);
        this.greeting_cube.texture((PImage)font_buffer);
        float p = 1.0f;
        float m = -1.0f;
        this.greeting_cube.normal(0.0f, 0.0f, -1.0f);
        this.greeting_cube.vertex(p, p, -1.0f, (float)uv_w, (float)uv_h);
        this.greeting_cube.vertex(p, m, -1.0f, (float)uv_w, 0.0f);
        this.greeting_cube.vertex(m, m, -1.0f, 0.0f, 0.0f);
        this.greeting_cube.vertex(m, p, -1.0f, 0.0f, (float)uv_h);
        this.greeting_cube.normal(0.0f, 0.0f, 1.0f);
        this.greeting_cube.vertex(p, p, 1.0f, (float)uv_w, (float)uv_h);
        this.greeting_cube.vertex(p, m, 1.0f, (float)uv_w, 0.0f);
        this.greeting_cube.vertex(m, m, 1.0f, 0.0f, 0.0f);
        this.greeting_cube.vertex(m, p, 1.0f, 0.0f, (float)uv_h);
        this.greeting_cube.normal(0.0f, -1.0f, 0.0f);
        this.greeting_cube.vertex(p, -1.0f, p, (float)uv_w, (float)uv_h);
        this.greeting_cube.vertex(p, -1.0f, m, (float)uv_w, 0.0f);
        this.greeting_cube.vertex(m, -1.0f, m, 0.0f, 0.0f);
        this.greeting_cube.vertex(m, -1.0f, p, 0.0f, (float)uv_h);
        this.greeting_cube.normal(0.0f, 1.0f, 0.0f);
        this.greeting_cube.vertex(p, 1.0f, p, (float)uv_w, (float)uv_h);
        this.greeting_cube.vertex(p, 1.0f, m, (float)uv_w, 0.0f);
        this.greeting_cube.vertex(m, 1.0f, m, 0.0f, 0.0f);
        this.greeting_cube.vertex(m, 1.0f, p, 0.0f, (float)uv_h);
        this.greeting_cube.normal(-1.0f, 0.0f, 0.0f);
        this.greeting_cube.vertex(-1.0f, p, p, (float)uv_w, (float)uv_h);
        this.greeting_cube.vertex(-1.0f, p, m, (float)uv_w, 0.0f);
        this.greeting_cube.vertex(-1.0f, m, m, 0.0f, 0.0f);
        this.greeting_cube.vertex(-1.0f, m, p, 0.0f, (float)uv_h);
        this.greeting_cube.normal(1.0f, 0.0f, 0.0f);
        this.greeting_cube.vertex(1.0f, p, p, (float)uv_w, (float)uv_h);
        this.greeting_cube.vertex(1.0f, p, m, (float)uv_w, 0.0f);
        this.greeting_cube.vertex(1.0f, m, m, 0.0f, 0.0f);
        this.greeting_cube.vertex(1.0f, m, p, 0.0f, (float)uv_h);
        this.greeting_cube.endShape();
        return this.greeting_cube;
    }

    public int to_size(float ratio) {
        return PApplet.parseInt((float)(ratio * (float)this.height));
    }

    public void setup() {
        this.randomSeed(665L);
        this.frameRate(60.0f);
        this.sun_dir.normalize();
        this.wind.normalize();
        this.gravity_y = this.to_size(0.068f);
        this.gravity = new PVector(0.0f, this.gravity_y, 0.0f);
        this.cloud_radius_max = this.to_size(0.18f);
        this.cloud_radius_min = this.to_size(0.12f);
        this.letter_cube_scale = this.to_size(0.02f);
        this.letter_velo_x = -this.to_size(0.16f);
        this.letter_velo_y = -this.to_size(0.26f);
        this.letter_velo_z = this.to_size(0.0f);
        this.greeting_velocity = new PVector(this.letter_velo_x, this.letter_velo_y, this.letter_velo_z);
        this.greeting_start = new PVector((float)this.width * 0.7f, (float)this.height * 0.6f, 40.0f);
        this.greeting_z_min = 30.0f;
        this.greeting_z_max = 60.0f;
        this.greeting_x_max = this.to_size(0.1f);
        this.greeting_x_min = -this.to_size(0.4f);
        this.letter_cube_scale = this.to_size(0.03f);
        this.greeting_rot_x = 0.0f;
        this.greeting_rot_y = 0.0f;
        this.greeting_rot_z = 0.0f;
        this.sea_scale = PApplet.parseInt((float)((float)this.width * 1.7f));
        this.palette = new int[this.palette_size];
        this.palette[0] = -222857;
        this.palette[1] = -213616;
        this.palette[2] = -334166;
        this.palette[3] = -6039190;
        this.palette[4] = -8332901;
        this.palette[5] = -11022391;
        this.palette[6] = -11419429;
        this.palette[7] = -9394732;
        this.palette[8] = -9603889;
        this.palette[9] = -10992520;
        this.palette[10] = -8103479;
        this.palette[11] = -4302910;
        this.palette[12] = -2197851;
        this.palette[13] = -2091;
        this.palette[14] = -526682;
        this.blue_sky = this.palette[6];
        this.sea_color = this.palette[7];
        this.clouds = new Cloud[this.cloud_amount];
        int i = 0;
        while (i < this.cloud_amount) {
            float cloud_x = this.random((float)this.width * 1.5f);
            PVector cloud_position = new PVector(cloud_x, this.random((float)(-this.height) * 0.01f, (float)this.height * 0.45f), -250.0f);
            this.clouds[i] = new Cloud(10, cloud_position);
            ++i;
        }
        this.sphereDetail(16);
        this.blue_sea = new Sea();
        this.sea_quad = this.createShape();
        this.sea_quad.beginShape(9);
        this.sea_quad.fill(this.sea_color);
        this.sea_quad.noStroke();
        this.sea_quad.normal(0.0f, 1.0f, 0.0f);
        this.sea_quad.vertex(-1.0f, 0.0f, -1.0f);
        this.sea_quad.vertex(1.0f, 0.0f, -1.0f);
        this.sea_quad.vertex(1.0f, 0.0f, 1.0f);
        this.sea_quad.vertex(-1.0f, 0.0f, 1.0f);
        this.sea_quad.vertex(-1.0f, 0.0f, -1.0f);
        this.sea_quad.vertex(1.0f, 0.0f, 1.0f);
        this.sea_quad.endShape();
        this.greeting_font = this.createFont("Commodore 64", 120.0f);
        this.greetings = new ArrayList();
        this.greetings.add(this.create_greeting("HELLO", this.greeting_font));
        this.greetings.add(this.create_greeting("SKROLLI", this.greeting_font));
        this.greetings.add(this.create_greeting("PARTY", this.greeting_font));
        this.greetings.add(this.create_greeting("GREETINGS", this.greeting_font));
        this.greetings.add(this.create_greeting("TO", this.greeting_font));
        this.greetings.add(this.create_greeting("WINDYTAN", this.greeting_font));
        this.greetings.add(this.create_greeting("BASSCADET", this.greeting_font));
        this.greetings.add(this.create_greeting("TJO", this.greeting_font));
        this.greetings.add(this.create_greeting("FROST", this.greeting_font));
        this.greetings.add(this.create_greeting("QMA", this.greeting_font));
        this.greetings.add(this.create_greeting("NINNNU", this.greeting_font));
        this.greetings.add(this.create_greeting("NAME", this.greeting_font));
        this.greetings.add(this.create_greeting("VALHE", this.greeting_font));
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"cloud_song.mp3", (int)163, (int)1);
        this.moonlander.start();
    }

    public float sync(String name) {
        return (float)this.moonlander.getValue(name);
    }

    public void draw() {
        this.moonlander.update();
        this.demo_progress = this.sync("progress");
        this.time_now = this.demo_progress * this.demo_duration;
        this.perspective();
        float sun_x = this.sync("sun_x");
        float sun_y = this.sync("sun_y");
        float sun_z = this.sync("sun_z");
        this.sun_dir = new PVector(sun_x, sun_y, sun_z);
        this.sun_dir.normalize();
        float sun_r = this.sync("sun_r");
        float sun_g = this.sync("sun_g");
        float sun_b = this.sync("sun_b");
        float air_r = this.sync("air_r");
        float air_g = this.sync("air_g");
        float air_b = this.sync("air_b");
        this.sun_color = new PVector(255.0f * sun_r, 255.0f * sun_g, 255.0f * sun_b);
        this.air_color = new PVector(255.0f * air_r, 255.0f * air_g, 255.0f * air_b);
        float sky_r = this.sync("sky_r");
        float sky_g = this.sync("sky_g");
        float sky_b = this.sync("sky_b");
        int back_color = this.color(255.0f * sky_r, 255.0f * sky_g, 255.0f * sky_b);
        this.background(back_color);
        this.directionalLight(this.sun_color.x, this.sun_color.y, this.sun_color.z, this.sun_dir.x, this.sun_dir.y, this.sun_dir.z);
        this.lightSpecular(this.sun_color.x, this.sun_color.y, this.sun_color.z);
        this.ambientLight(this.air_color.x, this.air_color.y, this.air_color.z);
        this.cloud_speed = this.sync("cloud_speed");
        int i = 0;
        while (i < this.cloud_amount) {
            this.clouds[i].update(this.wind);
            this.clouds[i].draw();
            if (this.clouds[i].position.x + this.cloud_radius_max * 2.0f < 0.0f) {
                this.clouds[i] = new Cloud(10, new PVector((float)this.width + this.cloud_radius_max, this.random((float)this.height * 0.1f, (float)this.height * 0.45f), -250.0f));
            }
            ++i;
        }
        this.blue_sea.update(this.wind);
        this.blue_sea.draw();
        this.letter_cube_scale = this.to_size(this.sync("letter_scale"));
        this.greeting_rot_x = this.sync("rot_x");
        this.greeting_rot_y = this.sync("rot_y");
        this.greeting_rot_z = this.sync("rot_z");
        if (this.greeting_rot_x > (float)Math.PI * 2) {
            this.greeting_rot_x -= (float)Math.PI * 2;
        }
        if (this.greeting_rot_y > (float)Math.PI * 2) {
            this.greeting_rot_y -= (float)Math.PI * 2;
        }
        if (this.greeting_rot_z > (float)Math.PI * 2) {
            this.greeting_rot_z -= (float)Math.PI * 2;
        }
        float greet_delay = this.sync("greet_delay");
        float greet_timer = this.time_now - greet_delay;
        float time_between_greets = this.sync("greet_gap");
        float time_between_letters = this.sync("letter_gap");
        int g = 0;
        while (g < this.greetings.size() && greet_timer > 0.0f) {
            this.greetings.get(g).draw(greet_timer, time_between_letters, this.gravity);
            int letters_went = this.greetings.get((int)g).letters.size();
            greet_timer -= time_between_greets + time_between_letters * (float)letters_went;
            ++g;
        }
        int i2 = 0;
        while (i2 < this.cloud_amount) {
            this.clouds[i2].draw_face();
            ++i2;
        }
        if (this.demo_progress >= 1.0f) {
            this.exit();
        }
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"cloud"};
        if (passedArgs != null) {
            PApplet.main((String[])cloud.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Cloud {
        int ball_amount;
        Cloud_ball[] balls;
        PVector position;

        Cloud(int ball_amount_param, PVector position_param) {
            this.ball_amount = ball_amount_param;
            this.balls = new Cloud_ball[this.ball_amount];
            this.position = position_param.copy();
            PVector prev_pos = this.position.copy();
            float prev_radius = 1.0f;
            int i = 0;
            while (i < this.ball_amount) {
                if (i > 0) {
                    prev_pos = this.balls[i - 1].position.copy();
                    prev_radius = this.balls[i - 1].get_radius();
                }
                this.balls[i] = new Cloud_ball(prev_pos, prev_radius);
                ++i;
            }
        }

        public void draw() {
            cloud.this.stroke(cloud.this.air_color.x, cloud.this.air_color.y, cloud.this.air_color.z, cloud.this.cloud_stroke_alpha);
            cloud.this.strokeWeight(1.0f);
            cloud.this.fill(255);
            int i = 0;
            while (i < this.ball_amount) {
                this.balls[i].draw(this.position);
                ++i;
            }
        }

        public void draw_face() {
            cloud.this.hint(5);
            cloud.this.noFill();
            cloud.this.stroke(0);
            float sixth_pi = 0.5235988f;
            cloud.this.arc(this.position.x + 10.0f, this.position.y, cloud.this.to_size(0.04f), cloud.this.to_size(0.04f), sixth_pi, (float)Math.PI - sixth_pi);
            cloud.this.fill(0);
            cloud.this.strokeWeight(2.0f);
            cloud.this.ellipse(this.position.x, this.position.y - (float)cloud.this.to_size(0.04f), cloud.this.to_size(0.01f), cloud.this.to_size(0.02f));
            cloud.this.ellipse(this.position.x + (float)cloud.this.to_size(0.04f), this.position.y - (float)cloud.this.to_size(0.04f), cloud.this.to_size(0.01f), cloud.this.to_size(0.02f));
            cloud.this.hint(-5);
        }

        public void update(PVector wind_direction) {
            PVector movement = PVector.mult((PVector)wind_direction, (float)cloud.this.cloud_speed);
            this.position.add(movement);
            int i = 0;
            while (i < this.ball_amount) {
                PVector ball_move = movement.copy();
                ball_move.mult(1.0f - this.balls[i].size / cloud.this.cloud_radius_max);
                this.balls[i].position.add(ball_move);
                ++i;
            }
        }
    }

    class Cloud_ball {
        PVector position;
        float size;

        Cloud_ball(PVector prev_ball_pos, float prev_radius) {
            PVector direction = PVector.random3D();
            this.position = direction.mult(prev_radius);
            this.size = cloud.this.random(cloud.this.cloud_radius_min, cloud.this.cloud_radius_max);
        }

        public void draw(PVector cloud_position) {
            cloud.this.pushMatrix();
            cloud.this.translate(cloud_position.x + this.position.x, cloud_position.y + this.position.y, cloud_position.z + this.position.z);
            cloud.this.sphere(this.size);
            cloud.this.popMatrix();
        }

        public float get_radius() {
            return cloud.sqrt((float)(this.size * this.size)) / 2.0f;
        }
    }

    class Greeting {
        PVector position;
        PVector velocity;
        ArrayList<Letter> letters;

        Greeting() {
        }

        public void draw(float time, float time_spacing, PVector gravity) {
            float time_left = time;
            float last_time = time_left - (float)(this.letters.size() - 1) * time_spacing;
            if (last_time > 0.0f && this.get_pos_at((float)last_time, (PVector)gravity).y > cloud.this.greeting_start.y + (float)cloud.this.letter_cube_scale) {
                return;
            }
            int letter_index = 0;
            while (letter_index < this.letters.size() && time_left > 0.0f) {
                this.letters.get(letter_index).draw(this.get_pos_at(time_left, gravity));
                time_left -= time_spacing;
                ++letter_index;
            }
        }

        public PVector get_pos_at(float time, PVector gravity) {
            PVector grav_now = PVector.mult((PVector)gravity, (float)(time * time));
            PVector velo_now = PVector.mult((PVector)this.velocity, (float)time);
            PVector pos_now = PVector.add((PVector)this.position, (PVector)PVector.add((PVector)velo_now, (PVector)grav_now));
            return pos_now;
        }
    }

    class Letter {
        PShape model;

        Letter(PShape model_param) {
            this.model = model_param;
        }

        public void draw(PVector position) {
            cloud.this.pushMatrix();
            cloud.this.translate(position.x, position.y, position.z);
            cloud.this.rotateX(cloud.this.greeting_rot_x);
            cloud.this.rotateY(cloud.this.greeting_rot_y);
            cloud.this.rotateZ(cloud.this.greeting_rot_z);
            cloud.this.scale(cloud.this.letter_cube_scale);
            cloud.this.noStroke();
            cloud.this.shape(this.model);
            cloud.this.popMatrix();
        }
    }

    class Sea {
        int wave_amount = 120;
        PVector position;
        Wave[] waves;

        Sea() {
            this.position = new PVector((float)(cloud.this.width / 2), (float)(cloud.this.height / 2 + cloud.this.height / 14), 100.0f);
            this.waves = new Wave[this.wave_amount];
            int i = 0;
            while (i < this.wave_amount) {
                this.waves[i] = new Wave(this.position, cloud.this.width, cloud.this.sea_scale);
                ++i;
            }
        }

        public void draw() {
            cloud.this.pushMatrix();
            cloud.this.translate(this.position.x, this.position.y, this.position.z);
            cloud.this.scale(cloud.this.sea_scale);
            cloud.this.specular(cloud.this.sun_color.x, cloud.this.sun_color.y, cloud.this.sun_color.z);
            cloud.this.shininess(15.0f);
            cloud.this.shape(cloud.this.sea_quad);
            cloud.this.popMatrix();
            int i = 0;
            while (i < this.wave_amount) {
                this.waves[i].draw(cloud.this.sea_color);
                ++i;
            }
        }

        public void update(PVector wind_dir) {
            PVector wind_flat = wind_dir.copy();
            wind_flat.y = 0.0f;
            int i = 0;
            while (i < this.wave_amount) {
                this.waves[i].update(wind_flat);
                ++i;
            }
        }
    }

    class Wave {
        PVector position;
        float max_height = 8.0f;
        float max_width = 40.0f;
        float change_counter = 0.0f;
        float change_time = 1.0f;
        float change_speed = 0.1f;
        float change_ratio = 0.0f;
        PVector sea_pos;
        float screen_width;
        float sea_depth;

        Wave(PVector sea_pos_P, float screen_width_P, float sea_depth_P) {
            this.sea_pos = sea_pos_P;
            this.screen_width = screen_width_P;
            this.sea_depth = sea_depth_P;
            this.reset();
        }

        public void reset() {
            this.position = new PVector(this.sea_pos.x + cloud.this.random(-this.screen_width, this.screen_width), this.sea_pos.y + 0.0f, this.sea_pos.z + cloud.this.random(-this.sea_depth, this.sea_depth));
            this.change_time = cloud.this.random(8.0f, 16.0f);
            this.change_counter = 0.0f;
            this.change_speed = cloud.this.random(0.1f, 0.3f);
        }

        public void draw(int sea_color) {
            if (this.change_ratio >= 0.0f) {
                float width = this.change_ratio * this.max_width;
                cloud.this.beginShape(9);
                cloud.this.fill(cloud.this.lerpColor(sea_color, cloud.this.color(255, 255, 255), this.change_ratio));
                cloud.this.normal(0.0f, 0.5f, 0.5f);
                cloud.this.vertex(this.position.x, this.position.y, this.position.z);
                cloud.this.vertex(this.position.x + width * 0.5f - this.change_ratio * (width * 0.45f), this.position.y - this.change_ratio * this.max_height, this.position.z);
                cloud.this.vertex(this.position.x + width, this.position.y, this.position.z);
                cloud.this.endShape();
            }
        }

        public void update(PVector wind_dir) {
            this.position.add(wind_dir);
            this.change_counter += this.change_speed;
            this.change_ratio = this.change_counter / this.change_time;
            if (this.change_counter > this.change_time) {
                this.change_speed *= -1.0f;
                this.change_counter = this.change_time;
            } else if (this.change_counter < 0.0f) {
                this.reset();
            }
        }
    }
}

