uniform vec2 resolution;
uniform float hPos;
uniform float width;
uniform vec3 color;
uniform float alpha;
uniform float enabled;
uniform sampler2D texture;   
uniform float time;

varying float vNoise;
varying vec3 vNormal;
varying vec3 vPos;
varying vec2 vUv;

float noise(float v, float amplitude, float frequency, float time) {
    float r = sin(v * frequency);
    float t = 0.01*(-time*130.0);
    r += sin(v*frequency*2.1 + t)*4.5;
    r += sin(v*frequency*1.72 + t*1.121)*4.0;
    r += sin(v*frequency*2.221 + t*0.437)*5.0;
    r += sin(v*frequency*3.1122+ t*4.269)*2.5;
    r *= amplitude*0.06;
    
    return r;
}

float highlight(vec2 p, vec2 p1, vec2 p2, float w) 
{
    float a = p1.x - p2.x;
    float b = -p1.y + p2.y;
    float c = p1.y * p2.x - p2.y * p1.x;
    float d = abs(a * p.x + b * p.y + c) / sqrt(pow(a, 2.0) + pow(b, 2.0));
    return smoothstep(0.0, d, w);
}

float plot(float pct, float thickness, vec2 position) {
    return  smoothstep(pct - thickness, pct, position.x) - smoothstep(pct, pct + thickness, position.x);
}

void main(void) {
    if(enabled >= 1.0) {
        vec2 p = vPos.xy;
        float n = noise(1.0, 2.0, 3.0, time / 10.0);
        vec3 hl = highlight(p, vec2(0.0, hPos), vec2(1.0, hPos), width) * color;
        
        vec4 pixel = texture2D(texture, vUv);

        
        if(pixel.a <= 0.0) {
            discard;
        }
        vec3 temp = vec3(1.0) + pixel.rgb; // * color;
        
        vec3 tc = mix(vec3(0.12), vec3(0.9), pixel.rgb) * vec3(0.2,0.5,0.7);

        tc /= plot(noise(tc.y * 0.01, 1.023, 9.8, time * 0.3)  * 3.4, 1.93, p ) * vec3(0.2, 0.0, 0.9);
        tc /= plot(noise(tc.y * 0.01, 1.06, 5.8, time * 0.76)  * 3.4, 1.90, p) * vec3(0.2, 0.9, 0.1);
        tc /= plot(noise(tc.y * 0.01, 1.96, 7.8, time * 0.5)  * 3.4, 1.93, p) * vec3(0.8, 0.2, 0.8);

        gl_FragColor = vec4(temp, alpha);
    }
    else {
        gl_FragColor = vec4(0.0);
    }
 


}