#version 330 core

uniform sampler2D textu;
uniform sampler2D colorb;

in vec4 oColor;
in vec2 uv;
out vec4 color;

void main() {
	vec4 f = texture(textu, vec2(uv.x, 1.-uv.y));
	if (length(f.xyz - vec3(1.0, 0.0, 1.0)) < .6) {
		discard;
	}
	color = texture(colorb, uv) + 1e-3 * oColor * f;
}
