#version 330 core

// inputz
in vec2 UV;

uniform vec2 iResolution;
uniform sampler2D iChannel0;
uniform sampler2D titleA;
uniform sampler2D titleB;
uniform sampler2D titleC;
uniform sampler2D greets;
uniform float weightBg;
uniform float weightA;
uniform float weightB;
uniform float weightC;
uniform float weightGreets;
uniform float uvYthreshold;
uniform float F;

out vec4 fragColor;

float aspect() {
    float yPix = (9.0 / 21.0) * iResolution.x;
    float dPix = 0.5 * (iResolution.y - yPix);
    float d = dPix / iResolution.y;
    return 1.1*d;
}

void main(){
    vec2 t = 1.0 / iResolution.xy;
    vec2 uv = UV;
    
    vec2 d = texture(iChannel0, uv).xy;
    d += texture(iChannel0, uv+vec2( t.x, 0)).xy;
    d += texture(iChannel0, uv+vec2(-t.x, 0)).xy;
    d += texture(iChannel0, uv+vec2( t.x, t.y)).xy;
    d += texture(iChannel0, uv+vec2(-t.x, t.y)).xy;
    d += texture(iChannel0, uv+vec2( t.x,-t.y)).xy;
    d += texture(iChannel0, uv+vec2(-t.x,-t.y)).xy;
    d += texture(iChannel0, uv+vec2( 0, t.y)).xy;
    d += texture(iChannel0, uv+vec2( 0,-t.y)).xy;
    
    t = 2.0 / iResolution.xy;
    d += texture(iChannel0, uv+vec2( t.x, 0)).xy;
    d += texture(iChannel0, uv+vec2(-t.x, 0)).xy;
    d += texture(iChannel0, uv+vec2( t.x, t.y)).xy;
    d += texture(iChannel0, uv+vec2(-t.x, t.y)).xy;
    d += texture(iChannel0, uv+vec2( t.x,-t.y)).xy;
    d += texture(iChannel0, uv+vec2(-t.x,-t.y)).xy;
    d += texture(iChannel0, uv+vec2( 0, t.y)).xy;
    d += texture(iChannel0, uv+vec2( 0,-t.y)).xy;
    d /= 17.0;
    
    vec3 nr = 0.5 + 0.5 * normalize(vec3(d.x,d.y,sqrt(clamp(1.0-length(d.xy),1.0,0.0))));

    vec3 lp = vec3(2,2,1)*0.5;
    vec3 lv = normalize(lp-vec3(uv,0));
    fragColor.rgb = max(0.0, dot(nr, lv))*normalize(vec3(0.32,0.4,1));

    //vec3 hv = normalize(vec3(0,1,0)+lv);
    //fragColor.rgb += pow(max(0.0, dot(nr, lv))*0.8,60.0)*vec3(1);
    // 0.517
    fragColor.rgb = smoothstep(1.0/3.0, 1.5, fragColor.rgb);
    fragColor.a = 1.0;
    const float gx = 0.517;
    const float dx = (1.0 - gx) / 1.0;
    //vec2 greetUV = vec2(min(1.0-2.0*dx, max(0.0, UV.x - dx))/0.517, (1.0-UV.y)-aspect());
    vec2 greetUV = F*(-1.0+2.0*UV)*vec2(1.0, (gx*9./16.));
    vec2 guv = vec2(0.5+0.5*greetUV); guv.y = 1.0 - guv.y;
    float addGreets = float(guv.x > 0.0 && guv.x < 1.0);

    //guv = clamp(guv,0.0,1.0);

    guv.y *= 1.0-step( 1.0-floor(uvYthreshold*12.0)/12.0, -0.0025+guv.y );

    float mask = (1.0-step(1.0,guv.x))*(1.0-step(0.0,-guv.x)) * (1.0-step(1.0,guv.y))*(1.0-step(0.0,-guv.y));

    fragColor = mix(weightBg *fragColor
              ,
               addGreets*weightGreets * texture(greets, clamp(guv,0.0,1.0))*mask, weightGreets*texture(greets,clamp(guv,0.0,1.0)).a*mask
              );
fragColor +=
              weightA * texture(titleA, vec2(UV.x, 1.0 - UV.y))
              + weightB * texture(titleB, vec2(UV.x, 1.0 - UV.y))
              + weightC * texture(titleC, vec2(UV.x, 1.0 - UV.y));

     fragColor = pow(fragColor, vec4(0.4545));
}

