#version 330 core

in vec2 UV;
uniform sampler2D postex;
uniform float iGlobalTime;
uniform vec3 campos;
uniform vec3 lookDir; // look dir
uniform mat4 P;

layout(location = 0) out vec4 ao;

uniform float aoScale;
//const float aoScale = 1.0; // was: 16
const float AOITER = 32.0;


#define ITERATIONS 4


// *** Change these to suit your range of random numbers..

// *** Use this for integer stepped ranges, ie Value-Noise/Perlin noise functions.
#define HASHSCALE1 .1031
#define HASHSCALE3 vec3(.1031, .1030, .0973)
#define HASHSCALE4 vec4(.1031, .1030, .0973, .1099)

// For smaller input rangers like audio tick or 0-1 UVs use these...
//#define HASHSCALE1 443.8975
//#define HASHSCALE3 vec3(443.897, 441.423, 437.195)
//#define HASHSCALE4 vec3(443.897, 441.423, 437.195, 444.129)



//----------------------------------------------------------------------------------------
//  1 out, 1 in...
float hash11(float p)
{
    vec3 p3  = fract(vec3(p) * HASHSCALE1);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

//----------------------------------------------------------------------------------------
//  1 out, 2 in...
float hash12(vec2 p)
{
    vec3 p3  = fract(vec3(p.xyx) * HASHSCALE1);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

//----------------------------------------------------------------------------------------
//  1 out, 3 in...
float hash13(vec3 p3)
{
    p3  = fract(p3 * HASHSCALE1);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

//----------------------------------------------------------------------------------------
//  2 out, 1 in...
vec2 hash21(float p)
{
    vec3 p3 = fract(vec3(p) * HASHSCALE3);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.xx+p3.yz)*p3.zy);

}

//----------------------------------------------------------------------------------------
///  2 out, 2 in...
vec2 hash22(vec2 p)
{
    vec3 p3 = fract(vec3(p.xyx) * HASHSCALE3);
    p3 += dot(p3, p3.yzx+19.19);
    return fract((p3.xx+p3.yz)*p3.zy);

}

//----------------------------------------------------------------------------------------
///  2 out, 3 in...
vec2 hash23(vec3 p3)
{
    p3 = fract(p3 * HASHSCALE3);
    p3 += dot(p3, p3.yzx+19.19);
    return fract((p3.xx+p3.yz)*p3.zy);
}

//----------------------------------------------------------------------------------------
//  3 out, 1 in...
vec3 hash31(float p)
{
   vec3 p3 = fract(vec3(p) * HASHSCALE3);
   p3 += dot(p3, p3.yzx+19.19);
   return fract((p3.xxy+p3.yzz)*p3.zyx); 
}


//----------------------------------------------------------------------------------------
///  3 out, 2 in...
vec3 hash32(vec2 p)
{
    vec3 p3 = fract(vec3(p.xyx) * HASHSCALE3);
    p3 += dot(p3, p3.yxz+19.19);
    return fract((p3.xxy+p3.yzz)*p3.zyx);
}

//----------------------------------------------------------------------------------------
///  3 out, 3 in...
vec3 hash33(vec3 p3)
{
    p3 = fract(p3 * HASHSCALE3);
    p3 += dot(p3, p3.yxz+19.19);
    return fract((p3.xxy + p3.yxx)*p3.zyx);

}


float rand(vec2 co){
    return hash12(co);
}

void main(){
    vec4 p = texture(postex, UV);
    vec3 ldir = normalize(lookDir);
    if (p.a < 0.5) discard;
    float aoContrib = 0.0;
    for (float i = 0.0; i < AOITER; i+=1.0) {
        vec3 rnd = aoScale * (hash33(vec3(2343.0*UV.x - 0.00101*i*iGlobalTime + i, 523.2*UV.y - 0.00201*iGlobalTime, iGlobalTime*.01)) - vec3(0.5));
        vec3 planar = p.xyz + (rnd - dot(rnd, ldir) * (ldir));
        vec4 projd = P * vec4(planar, 1.0);
        projd.xyz /= projd.w;
        projd.xy = (projd.xy + vec2(1.0)) / 2.0;
        vec4 sample = texture(postex, projd.xy);
        aoContrib += float((length(planar - campos) < length(sample.xyz - campos)) ||
                           sample.w < 0.5);
    }
    ao = vec4(vec3(smoothstep(-0.0, 1.0, aoContrib / AOITER)), 1.0);
    //ao = 0.1 * ao + 0.9 * texture(postex, UV);
    //ao = vec4(1.0, 0.0, 1.0, 1.0);
}
