/*
 * Paraguay collor correction pipe by rimina
 */

THREE.ParaguayColorCorrect = {

	uniforms: {
		"tDiffuse":   { type: "t", value: null },
		"gamma": {type: "v3", value: new THREE.Vector3(2.2, 2.2, 2.2)}
	},

	vertexShader: [

		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n"),

	fragmentShader: [

        "uniform sampler2D tDiffuse;",
        "uniform vec3 gamma;",

        "varying vec2 vUv;",

        "void main() {",
            "vec4 c = texture2D( tDiffuse, vUv );",

            "float vigentOffset = .008;",
            "float darkness = .8;",
            "float dist = distance( vUv, vec2( 0.5 ) );",
            "c.rgb *= smoothstep( 0.8, vigentOffset * 0.799, dist *( darkness + vigentOffset ) );",

            "float luma = dot(c.xyz, vec3(0.2126, 0.7152, 0.0722));",
    		"c.xyz *= ((luma * (1.0 + luma / 4.0) / (1.0 + luma)) / luma);",

            "c.rbg = pow(c.rbg, 1./abs(gamma));",

            "gl_FragColor = c;",
        "}"

	].join("\n")

};
