var Puu = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(4);

    //VIDEO TEXTURE
    this.video = document.getElementById( 'puu' );
    this.texture = new THREE.VideoTexture(this.video);
    this.texture.minFilter = THREE.LinearFilter;
    this.texture.magFilter = THREE.LinearFilter;
    this.texture.format = THREE.RGBFormat;

    //GEOMETRY
    var geometry = new THREE.PlaneGeometry(640, 360);
    var material = new THREE.MeshBasicMaterial({
        map : this.texture,
        //color: 0x8080FF
    });

    var display = new THREE.Mesh(geometry, material);
    this.scene.add(display);
    //console.log(display.position.x + " " + display.position.y + " "+ display.position.z);
};

Puu.prototype = PartBase.prototype.inheritance();

Puu.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);
};

Puu.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    this.video.currentTime = 0;
    this.video.play();
};

Puu.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.video.pause();
};
