var Bars = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setHorizontalBlur(8);
    this.setVerticalBlur(8);
    this.setBloom(6);
    //this.setEdgeDetection();
    

    this.texture = TDEMO.TEXTURES.getTextures().katto;
    this.bGroundTexture = TDEMO.TEXTURES.getTextures().sillanalus;

    this.scene.add(new THREE.AmbientLight(0xFFFFFF));


    //this.scene.fog = new THREE.Fog(0x802000, this.near, 1000);
    //this.scene.fog = new THREE.Fog(0xFF88FF, this.near, 1500);
    var bground = this.createBG();
    this.scene.add(bground);
    this.bars = this.createBars(5);
    this.scene.add(this.bars);
};

Bars.prototype = PartBase.prototype.inheritance();

Bars.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);
    var hb = TDEMO.SYNC.getHeartBeat();
    var ballp = TDEMO.SYNC.getObjPosition();
    this.bars.position.x = ballp.x;
    this.bars.position.y = ballp.y;
    this.bars.position.z = ballp.z;

    var ballr = TDEMO.SYNC.getObjRotation();
    this.bars.rotation.x = ballr.x;
    this.bars.rotation.y = ballr.y;
    this.bars.rotation.z = ballr.z;

    if (hb === 0) {
      this.texture.offset.x += delta*0.055;
      this.texture.needsUpdate = true;
    }
};

Bars.prototype.createBG = function(){
    var geometry = new THREE.SphereGeometry(1600, 128, 128);

    var material = new THREE.MeshStandardMaterial( {
		map: this.bGroundTexture,
		color: 0x8080A0,
		shading: THREE.SmoothShading,
    side : THREE.BackSide
	} );

    var bg = new THREE.Mesh(geometry, material);
    return bg;
};


Bars.prototype.createBars = function(amount) {
    var geometry = new THREE.CylinderGeometry( 10, 20, 300, 128, 128 );
    var material = new THREE.MeshBasicMaterial({
        color : 0x9066ff,
        map : this.texture
    });

    var bar = new THREE.Mesh(geometry, material);
    var barGroup = new THREE.Group();
    
    bar.position.x = -100
    barGroup.add(bar);

    for (var i = 1; i<amount; i++) {
      bar2 = bar.clone();
      bar2.position.x = -100 + i*60; 
      
      if (i === 2) bar2.rotation.z = Math.PI / 2;
      if (i === 3) bar2.rotation.z = Math.PI / 4;

      barGroup.add(bar2);
    }
    
    return barGroup;  
}

