import QtQuick 2.3

import SystemTime 1.0

import AdaptDemoSystem 1.0


Item {
    id: root
    visible: true
    width: 400
    height: 720


    Rectangle {
        anchors.fill: parent
        color: "black"
    }

    Image {
        fillMode: Image.PreserveAspectCrop
        anchors.centerIn: parent
        //source: "../images/startDialog.png"
        source: "../images/PinkMedusaB.png"
        opacity: 0.3
    }

    Keys.onEscapePressed: {
        console.log("esc esc")
        rocket.exitDemo();
    }


    focus: true

    //    MouseArea {
    //        anchors.fill: parent
    //        onClicked: { console.log("klik") }
    //    }

    property real frameTime: 0.0

    property real frameTimeSmooth: 0.0


    Rocket {
        id: rocket
    }

    function syncRocketRoot(track) {
        var a = rocket.sync(track);
        var b = rocket.syncUpdate;
        return a;
    }

    ////   Test that proves we are able to render mesh stuff also into the edit view!
    ////   TBD to make this work: render with correct edit view aspect ratio, maybe edit view
    ////   to have specific 16:9 area for preview etc
    //    Demo {
    //        Scene {
    //            property string sceneName: "editSkene"
    //            property string sceneDir: "fx/"+sceneName+"/"
    //            Camera {
    //                property string name: "camera"
    //                x: 0.0
    //                y: 0.0
    //                z: -150.0
    //                lookAtX: 0.0
    //                lookAtY: 0.0
    //                lookAtZ: 0.0
    //                upX: 0.0
    //                upY: 1.0
    //                upZ: 0.0
    //            }
    //            Mesh {
    //                property string name: "mesh1"
    //                file: "data/aivob.x"
    //                shader: "fx/Skene2/sm"

    ////                Pos { x: 0; y: 0; z: 0 }
    ////                Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0; cx: 0.0; cy: 0.0; cz: 0.0 }
    ////                Sca { x: 1.0; y: 1.0; z: 1.0 }
    //           }
    //        }
    //    }



    // Update the FPS timer
    Timer {
        interval: 1000
        running: true
        repeat: true
        onTriggered: {
            frameTimeSmooth = rocket.getFrameTimeSmooth();
            var fps = (1000.0/frameTimeSmooth).toFixed()
            frameTimeText.text = "FPS:"+fps
        }
    }
    Column {
        id: kolumni
        focus: true
        Text {
            text: demoTimeNow !== undefined ? "demo time:"+demoTimeNow.toFixed(2) : "demo time:0.0"
            color: "white"
        }
        Text {
            id: frameTimeText
            color: "white"
        }
        Item {
            height: 30
        }
    }


    property int tabActive: 0




    Item {

        id: effectsContainer

        anchors.bottom: root.bottom
        anchors.bottomMargin: 110
        anchors.left: root.left
        anchors.right: root.right
        anchors.top: kolumni.bottom
        anchors.topMargin: 55

        opacity: tab1.tabOn
        enabled: tab1.tabOn > 0.01 ? true : false
        // visible: (editViewOn.bState && tab1.tabOn > 0.01) ? true : false

        clip: true


        ListView {
            focus: true
            id: effects


            function doOpenFile(typeName, fileName) {
                console.log("opening file from QML:"+fileName)
                fileName = fileName.replace("<br>", "");
                fileName = fileName.replace("<BR>", "");
                fileName = fileName.replace(rocket.rootPath(), "");

                if (fileName.indexOf(".x") !== -1 ||
                    fileName.indexOf(".lwo") !== -1 ||
                    fileName.indexOf(".dae") !== -1 ||
                    fileName.indexOf(".obj") !== -1) {

                    // 3d object
                    rocket.runCommand("open3DModel.cmd "+fileName);
                } else {
                    rocket.openFile(typeName, fileName);
                }
            }



            function checkForExists(fileName, skeneName, extension) {
                if (fileName !== "" && !rocket.fileExists(fileName+extension)) {
              //      console.log("resolvedFilePath did not exist:"+resolvedFilePath);
                    var tryOut;

                    var bFileFound = false;

                    tryOut = "fx/"+skeneName+"/"+fileName;
                    if (rocket.fileExists(tryOut+extension)) {
                        fileName = tryOut;
                        bFileFound = true;
              //          console.log("tryout #1 file found!");
                    } else {
             //           console.log("tryout #1 resolvedFilePath did not exist:"+tryOut);
                    }

                    if (!bFileFound) {
                        tryOut = "fx/_SharedQML/"+fileName;
                        if (rocket.fileExists(tryOut+extension)) {
                            fileName = tryOut;
                        }
             //           console.log("tryout #2 resolvedFilePath did not exist:"+tryOut);
                    }
                  //  resolvedFilePath = model.modelData.skeneName
                }
                return fileName;
            }

            function replaceAll(find, replace, str) {
              return str.split(find).join(replace)
            }

            function resolveFileName(fileName, skeneName) {
                fileName = checkForExists(fileName, skeneName, "");
                fileName = checkForExists(fileName, skeneName, ".vert");

                if (fileName.indexOf(".png")!==-1 ||
                    fileName.indexOf(".jpeg")!==-1) {
                    fileName = "<br>"+fileName.replace("file:///", "");
                }

                var rootPathi = rocket.rootPath();
                fileName = fileName.replace(rootPathi, "");
                rootPathi = replaceAll("\\", "/", rootPathi);
                fileName = fileName.replace(rootPathi, "");
               // console.log("rootpathi:"+rootPathi);
                return fileName;
            }

            //            anchors.fill: parent
            anchors.left: parent.left
            width: parent.width
            height: myKorkius


            cacheBuffer: 100
            displayMarginBeginning: 100
            displayMarginEnd: 100

            //   anchors.top: kolumni.bottom

            //   contentY: 200

            //  clip: true
            function getModelHeight(mod, deepness) {
                var height = 0;
                if (!mod) {
                    return height;
                }
                if (deepness < editViewLevels.levels) {
                    for (var i=0; i<mod.length; i++) {
                        // height += mod[i].childs.length*35;
                        height += getModelHeight(mod[i].childs, deepness+1);
                        height += 40;
                    }
                }
                return height;
            }

            property real myKorkius: 0.0

            property real currentContentY: 0
            /*
            onContentYChanged: {
                //console.log("content y is :"+contentY);
                if (contentY > 0 && contentY!=160) {
                    if (currentContentY != contentY) {
                         console.log("content y is :"+contentY);
                        rocket.markUpdateFrequent()
                        //console.log("mark update freq");
                    }
                    currentContentY = contentY;
                }
            }
*/
            onContentHeightChanged: {
                if (contentHeight != 0) {
                    // console.log("skenes list height:"+contentHeight)
                }
            }

            onModelChanged: {
                //   contentY = currentContentY;
                myKorkius = getModelHeight(myModel, 0);
            }
            // height: effects.childrenRect.height

            //   width: 300
            //   height: Math.min(effects.getModelHeight(myModel), 1000)
            model: myModel

            property int skeneDescTextSize: 13

            delegate: Item {
                id: sub
                width: 300

                // property real calculatedHeight: 40+effects.getModelHeight(model.modelData.childs, 0)

                // show ALL skenes or On skenes only?
                visible: showSkenes.bState ? true : (model.modelData.childs.length ? true : false)
                // height: showSkenes.bState ? calculatedHeight : (model.modelData.childs.length ? calculatedHeight : 0.0)


                focus: true
                Rectangle {
                    id: sceneNameText
                    //  focus: true
                    anchors.fill: parent
                    anchors.bottomMargin: 5
                    anchors.topMargin: 5
                    color: model.modelData.color
                    opacity: 1.0
                    Text { font.pixelSize: effects.skeneDescTextSize; text: "<b>"+model.modelData.name + "</b>" + " - " + model.modelData.rocketName + " - " + model.modelData.details }
                    MouseAreaOpenFile { bRootLevel: true }
                }


                Rectangle {
                    id: masterRocketButton
                    property bool bIsMasterRocket: masterRocketIndex!==undefined ? ((masterRocketIndex===model.modelData.rocketPortIndex) ? true : false) : false

                    width: 40
                    height: 30
                    color: bIsMasterRocket ? "#559955" : "#995555"
                    anchors.right: parent.right
                    anchors.rightMargin: 80
                    anchors.topMargin: 5
                    anchors.top: parent.top
                    MouseArea {
                        anchors.fill: parent
                        onPressedChanged: {
                            if (pressed) {
                                console.log("mouse pressed on go start:"+model.modelData.rocketNameStack)
                                rocket.findSkeneStart(model.modelData.rocketNameStack);
                            }
                        }
                    }
                    Text {
                        id: goStart
                        anchors.centerIn: parent
                        text: masterRocketButton.bIsMasterRocket ? "go\nstart" : "show\nrocket"
                        color: "white"
                        horizontalAlignment: Text.AlignHCenter
                    }
                }

                Rectangle {
                    anchors.right: sceneNameText.right
                    anchors.top: sceneNameText.top
                    width: 80
                    height: 30
                    color: model.modelData.skeneEnabled ? "orange" : "grey"
                    opacity: 0.8
                    Text {
                        anchors.centerIn: parent
                        text: model.modelData.skeneEnabled ? "ON in rocket" : "OFF in rocket"
                    }
                }
                Component.onCompleted: {
                    //    subList.height = 40+effects.getModelHeight(model.modelData.childs, 1);
                    subList.model = model.modelData.childs;
                }

                height: subList.height+40

                ListView {
                    visible: editViewLevels.levels > 1 ? true: false
                    id: subList
                    y: 30
                    width: 300
                    //height: subList.childrenRect.height

                    height: editViewLevels.levels > 1 ? subList.childrenRect.height : 0.0

                    delegate: Item {
                        id: subsItem
                        // height: 40+effects.getModelHeight(model.modelData.childs, 1)

                        height: subSubList.height+40
                        width: 300
                        Rectangle {
                            id: nimes
                            anchors.fill: parent
                            anchors.margins: 2
                            anchors.leftMargin: 10
                            color: "lightgrey"
                            opacity: 0.8
                            height: 30

                            MouseAreaOpenFile { }
                            EffectDescActions { }

                        }

                        Component.onCompleted: {
                            subSubList.model = model.modelData.childs;
                        }
                        ListView {
                            id: subSubList
                            visible: editViewLevels.levels > 2 ? true: false
                            anchors.leftMargin: 10
                            y: 40
                            width: 300
                            height: editViewLevels.levels > 2 ? subSubList.childrenRect.height : 0.0


                            delegate: Item {
                                id: subssItem
                                //  height: 40+effects.getModelHeight(model.modelData.childs, 2)
                                //  height: 30
                                height: 40+subSubSubList.height
                                anchors.leftMargin: 10

                                width: 300


                                Rectangle {
                                    id: nimesSubSub
                                    anchors.fill: parent
                                    anchors.margins: 2
                                    anchors.leftMargin: 20
                                    color: "grey"
                                    opacity: 0.8

                                    MouseAreaOpenFile { }
                                    EffectDescActions { }

                                }


                                Component.onCompleted: {
                                    //   subSubSubList.height = 40+effects.getModelHeight(model.modelData.childs, 3);
                                    subSubSubList.model = model.modelData.childs;
                                }
                                ListView {
                                    id: subSubSubList
                                    visible: editViewLevels.levels > 3 ? true: false
                                    y: 40
                                    anchors.left: parent.left
                                    anchors.leftMargin: 10
                                    anchors.right: parent.right
                                    // width: 300

                                    height: editViewLevels.levels > 3 ? subSubSubList.childrenRect.height : 0.0

                                    delegate: Item {
                                        id: subsssItem
                                        //    height: 40+effects.getModelHeight(model.modelData.childs, 3)
                                        width: subSubSubList.width
                                        height: 40+subSubSubSubList.height
                                        anchors.leftMargin: 50


                                        Rectangle {
                                            id: nimesSubSubSub
                                            anchors.fill: parent
                                            anchors.margins: 2
                                            anchors.leftMargin: 20
                                            color: "lightgrey"
                                            opacity: 0.8
                                            MouseAreaOpenFile { }
                                            EffectDescActions { }
                                        }


                                        Component.onCompleted: {
                                            subSubSubSubList.model = model.modelData.childs;
                                        }
                                        ListView {
                                            id: subSubSubSubList
                                            visible: editViewLevels.levels > 4 ? true: false
                                            y: 30
                                            anchors.left: parent.left
                                            anchors.leftMargin: 10
                                            anchors.right: parent.right

                                            height: editViewLevels.levels > 4 ? subSubSubSubList.childrenRect.height : 0.0

                                            delegate: Item {
                                                height: 40 // +effects.getModelHeight(model.modelData.childs, 4)
                                                width: subSubSubSubList.width

                                                Rectangle {
                                                    id: nimesSubSubSubSub
                                                    anchors.fill: parent
                                                    anchors.margins: 2
                                                    anchors.leftMargin: 40
                                                    color: "grey"
                                                    opacity: 0.8
                                                    MouseAreaOpenFile { }
                                                    EffectDescActions { }

                                                }

                                            }
                                        }

                                    }
                                }

                            }
                        }

                    }
                }
            }
        }
    }

    ScrollBar {
        id: scrollbar

        height: effectsContainer.height

        opacity: tab1.tabOn*0.8
        enabled: tab1.tabOn > 0.01 ? true : false

        onScrollPosChanged: {
            var newContentY = scrollPos*(effects.myKorkius-effectsContainer.height/2.0+80);
            if (newContentY < 0) {
                newContentY = 0;
            }
            // effects.contentY = newContentY;
            // effects.currentContentY = newContentY;
            effects.y = -newContentY;
        }
    }


    Row {
        anchors.left: parent.left
        anchors.bottom: effectsContainer.top
        //anchors.topMargin: 30
        width: 300
        clip: true
        Rectangle {
            id: tab1
            radius: 4
            width: 100
            height: 50
            property int tabIndex: 0
            anchors.bottom: parent.bottom
            property real tabPos: tabActive==tabIndex ? -10 : -20
            anchors.bottomMargin: tabPos
            color: tabActive==tabIndex ? "white" : "grey"
            property real tabOn: tabActive==tabIndex ? 1.0 : 0.0

            Behavior on color {
                ColorAnimation { duration: 300;  }
            }
            Behavior on tabPos {
                NumberAnimation { duration: 300; }
            }
            Behavior on tabOn {
                NumberAnimation { duration: 300; }
            }

            Text {
                text: "Rocket skenes"
                font.pixelSize: 13
                wrapMode: Text.WordWrap
                rotation: 0
            }
            MouseArea {
                anchors.fill: parent
                onClicked: {
                    tabActive = parent.tabIndex;
                    rocket.markUpdateFrequent()
                }
            }
        }
        Item {
            width: 5
            height: 40
        }
        Rectangle {
            id: tab2
            radius: 4
            width: 100
            height: 50
            property int tabIndex: 1
            anchors.bottom: parent.bottom
            property real tabPos: tabActive==tabIndex ? -10 : -20
            anchors.bottomMargin: tabPos
            color: tabActive==tabIndex ? "white" : "grey"
            property real tabOn: tabActive==tabIndex ? 1.0 : 0.0


            Behavior on color {
                ColorAnimation { duration: 300;  }
            }
            Behavior on tabPos {
                NumberAnimation { duration: 300; }
            }
            Behavior on tabOn {
                NumberAnimation { duration: 300; }
            }


            Text {
                id: tab2TextRow1
                text: "Activate skenes"
                wrapMode: Text.WordWrap
                font.pixelSize: 13
                rotation: 0
            }
            Text {
                anchors.top: tab2TextRow1.bottom
                text: "(for "+activeSkenesSetupFile+")"
                wrapMode: Text.WordWrap
                font.pixelSize: 10
                rotation: 0

            }

            MouseArea {
                anchors.fill: parent
                onClicked: {
                    tabActive = parent.tabIndex;
                    rocket.markUpdateFrequent()
                }
            }

        }

    }



    Item {
        // TAB2: skeneActivation Tab
        id: skeneActivation

        anchors.bottom: root.bottom
        anchors.bottomMargin: 110
        anchors.left: root.left
        anchors.right: root.right
        anchors.top: kolumni.bottom
        anchors.topMargin: 55

        opacity: tab2.tabOn
        enabled: tab2.tabOn > 0.01 ? true : false
        // visible: (editViewOn.bState && tab2.tabOn > 0.01) ? true : false

        //        Rectangle {
        //            anchors.fill: parent
        //            color: "purple"
        //        }

        ListView {
            id: saList
            anchors.left: parent.left
            anchors.top: parent.top
            model: skeneActivationList
            width: parent.width
            height: parent.height
            clip: true

            function getModelHeight(mod) {
                var height = 0;
                if (!mod) {
                    return height;
                }
                for (var i=0; i<mod.length; i++) {
                    height += getModelHeight(mod[i].childs);
                    height += 40;
                }
                return height;
            }

            property real myKorkius: 0.0
            property real currentContentY: 0
            onContentYChanged: {
                if (contentY != 0) {
                    if (currentContentY != contentY) {
                        console.log("SALIST content y is :"+contentY);
                        rocket.markUpdateFrequent()
                        //console.log("mark update freq");
                    }
                    currentContentY = contentY;
                }
            }

            onModelChanged: {
                contentY = currentContentY;

                myKorkius = getModelHeight(model)
                //console.log("skeneActivation.height:"+skeneActivation.height);
                //console.log("myKorkius:"+myKorkius);
                scrollbarTab2.scrollRatio = skeneActivation.height/myKorkius;
                if (scrollbarTab2.scrollRatio > 1.0) {
                    scrollbarTab2.scrollRatio = 1.0;
                }

            }



            delegate: Item {
                width: 300
                height: 40
                anchors.topMargin: 5
                anchors.bottomMargin: 5
                Rectangle {
                    anchors.fill: parent
                    anchors.topMargin: 5
                    anchors.bottomMargin: 5
                    color: "white"
                }
                //                Component.onCompleted: {
                //                    skeneActivationList.height = skeneActivationList.contentHeight
                //                }

                Text {
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: parent.left
                    anchors.leftMargin: 5
                    text: model.modelData.name
                    color: "black"
                    font.pixelSize: 13
                }
                Text {
                    id: rocketPort
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.right: parent.right
                    anchors.rightMargin: 5
                    text: "rocket\nport:"+model.modelData.rocketPort
                    color: "darkred"
                    font.pixelSize: 13
                }

                property int skeneIsActive: model.modelData.rocketPort !== -1

                Rectangle {
                    id: activateButton
                    anchors.fill: activeSign
                    anchors.margins: -5
                    color: model.modelData.rocketPort !== -1 ? "green" : "grey"
                }

                Text {
                    id: activeSign
                    anchors.verticalCenter: parent.verticalCenter
                    anchors.right: parent.right
                    anchors.rightMargin: 60
                    text: model.modelData.rocketPort !== -1 ? "Active" : "Not-Active"
                    color: model.modelData.rocketPort !== -1 ?  "white" : "black"
                    font.pixelSize: 13
                }

                Row {
                    opacity: model.modelData.rocketPort !== -1 ? 1.0: 0.0
                    anchors.right: parent.right
                    anchors.rightMargin: 120
                    anchors.verticalCenter: parent.verticalCenter
                    Text {
                        // move down
                        text: ">"
                        font.pixelSize: 20
                        rotation: 90
                        MouseArea {
                            anchors.fill: parent
                            onPressedChanged: {
                                if (pressed) {
                                    moveSkeneToIndex(model.modelData.name, model.modelData.myIndex+2);
                                    console.log("clicked move down")
                                }
                            }
                        }
                    }
                    Text {
                        // move up
                        text: ">"
                        font.pixelSize: 20
                        rotation: -90
                        MouseArea {
                            anchors.fill: parent
                            onPressedChanged: {
                                if (pressed) {
                                    moveSkeneToIndex(model.modelData.name, model.modelData.myIndex-1);
                                    console.log("clicked move up")
                                }
                            }
                        }

                    }
                }

                MouseArea {
                    anchors.fill: activateButton
                    onPressedChanged: {
                        if (pressed) {
                            if (skeneIsActive) {
                                console.log("callin deActivateSkene from QML")
                                model.modelData.deActivateSkene(model.modelData.name)
                            } else {
                                console.log("callin activateSkene from QML")
                                model.modelData.activateSkene(model.modelData.name)
                            }
                        }
                    }
                }
            }
        }

    }



    ScrollBar {
        id: scrollbarTab2

        height: skeneActivation.height

        opacity: tab2.tabOn*0.8
        enabled: tab2.tabOn > 0.01 ? true : false

        onScrollPosChanged: {
            var newContentY = scrollPos*(saList.myKorkius-skeneActivation.height/2.0+80);
            if (newContentY < 0) {
                newContentY = 0;
            }
            saList.contentY = newContentY;
            saList.currentContentY = newContentY;
        }
    }

    Column {
        anchors.right: parent.right
        anchors.top: parent.top

        CornerButton {
            id: saveAllButton
            buttonText: "Save\nAll"
            buttonColor: "steelblue"
            onButtonPressed: {
                rocket.saveAll();
            }
        }
        CornerButton {
            id: exportTracksButton
            buttonText: "Export\ntracks"
            buttonColor: "steelblue"
            onButtonPressed: {
                rocket.remoteExportAll();
            }
        }


        CornerButton {
            id: showSkenes
            property bool bState: true
            property string showType: bState ? "ALL\nskenes" : "ON\nskenes only"
            buttonText: "Show\n"+showType
            onButtonPressed: {
                if (showSkenes.bState) {
                    showSkenes.bState = false;
                } else {
                    showSkenes.bState = true;
                }
            }
        }
        CornerButtonPlusMinus {
            id: editViewLevels
            property int levels: 2
            buttonText: "Show\nlevels:\n"+levels
            onButtonPressedPlus: {
                editViewLevels.levels++;
                scrollbar.scrollPos = 0.0;
                if (editViewLevels.levels>5) {
                    editViewLevels.levels=1;
                }
            }
            onButtonPressedMinus: {
                editViewLevels.levels--;
                scrollbar.scrollPos = 0.0;
                if (editViewLevels.levels<1) {
                    editViewLevels.levels=5;
                }
            }
        }
    }




    Rectangle {
        id: mouseMoveArea
        color: "grey"
        width: 400
        height: 100
        anchors.bottom: parent.bottom
        Text {
            anchors.centerIn: parent
            text: "Mouse move area\ndrag here to modify selected\nrocket tracks (.x,.y) directly."
        }

        MouseArea {
            //     propagateComposedEvents: true
            anchors.fill: parent

            property int mouseOnPressX: 0
            property int mouseOnPressY: 0

            onPressedChanged: {
                if (pressed) {
                    console.log("mouse pressed on kurko")

                    // rocket.setTrackValue("", 123.0);
                    mouseOnPressX = mouseX;
                    mouseOnPressY = mouseY;

                    rocket.setTrackValue("track", 0.0);
                    rocket.setTrackValue("track+1", 0.0);
                }
            }
            onMouseXChanged: {
                console.log("mouse red x:"+mouseX);
                rocket.setTrackValue("track", (mouseX-mouseOnPressX)*mouseRange.getRange());
                rocket.markUpdateFrequent()
            }
            onMouseYChanged: {
                console.log("mouse red y:"+mouseY);
                if (btnFlipY.value) {
                    rocket.setTrackValue("track+1", -(mouseY-mouseOnPressY)*mouseRange.getRange());
                } else {
                    rocket.setTrackValue("track+1", (mouseY-mouseOnPressY)*mouseRange.getRange());
                }
                rocket.markUpdateFrequent()
            }
        }
    }

    // Mouse move area scale and y-invert options (etc...)
    Column {
        anchors.right: parent.right
        anchors.bottom: mouseMoveArea.top

        Rectangle {
            id: mouseRange
            color: "grey"
            width: 60
            height: 80
            //  anchors.right: parent.right
            //  anchors.top: parent.top

            property int rangeSelection: 0
            property int numRangeSelections: 4

            function getRange() {
                if (rangeSelection == 0) {
                    return 1.0;
                } else if (rangeSelection == 1) {
                    return 0.1;
                } else if (rangeSelection == 2) {
                    return 0.01;
                } else if (rangeSelection == 3) {
                    return 0.001;
                }
            }

            MouseArea {
                anchors.fill: parent
                onPressedChanged: {
                    if (pressed) {
                        console.log("rangeSelection is now:"+mouseRange.rangeSelection);
                        mouseRange.rangeSelection++;
                        if (mouseRange.rangeSelection >= mouseRange.numRangeSelections) {
                            mouseRange.rangeSelection = 0;
                        }
                    }
                }
            }

            Column {
                anchors.centerIn: parent
                Text {
                    width: 40
                    font.pixelSize: 14
                    color: "white"
                    text: "Mouse range:"
                    anchors.horizontalCenter: parent.horizontalCenter
                    wrapMode: Text.WordWrap
                }

                Text {
                    font.pixelSize: 14
                    color: "white"
                    height: 14
                    width: contentWidth
                    anchors.horizontalCenter: parent.horizontalCenter
                    text: {
                        if (mouseRange.rangeSelection==0) {
                            "1.0";
                        } else if (mouseRange.rangeSelection==1) {
                            "0.1";
                        } else if (mouseRange.rangeSelection==2) {
                            "0.01";
                        } else if (mouseRange.rangeSelection==3) {
                            "0.001";
                        } else {
                            "1.0";
                        }
                    }
                }
            }
        }

        Item {
            height: 5
        }

        Rectangle {
            id: btnFlipY
            color: "#777777"
            width: 60
            height: 20
            property bool value: false
            MouseArea {
                anchors.fill: parent
                onPressedChanged: {
                    if (pressed) {
                        btnFlipY.value = !btnFlipY.value;
                    }
                }
            }

            Text {
                anchors.centerIn: parent
                color: "white"
                text: btnFlipY.value ? "flip-Y: ON" : "flip-Y: OFF"
            }
        }

    }



}
