#version 430

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D tex2;
layout(binding=2) uniform sampler2D tex3;
layout(binding=3) uniform sampler2D tex4;
layout(binding=4) uniform sampler2D texPrevBlurFrame;
layout(binding=5) uniform sampler2D texPrevNorm;


in vec4 posG;
in vec3 normalG;
in vec3 normalWSG;
in vec2 uvG;
in vec3 tangentG;
in vec3 colorG;
in vec4 posW;
in float brightG;

layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;


#define PI 3.1415926

uniform float g_time;

uniform float g_uvOfsX = 0.0;
uniform float g_uvScale = 1.0;

uniform float g_texBrightness = 1.0;
uniform float g_texAmbient = 0.0;
uniform float g_prevAmount = 0.0;
uniform float g_prevBlurAmount = 0.0;
uniform float g_bump = 0.0;

uniform vec4 g_color = vec4(1.0);

uniform float g_alpha = 1.0;


uniform mat4 modelViewMatrix;
uniform mat4 modelViewInvMatrix;
uniform mat4 viewInvMatrix;
uniform mat4 viewMatrix;
uniform mat4 projectionMatrix;
uniform mat4 projectionInvMatrix;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

const float zFar = 1.0;
const float zNear = 0.0;

float getPointDist(float z) {
    float clipA = zFar / (zFar - zNear);
    float clipB = zFar*zNear / (zNear - zFar);
    return clipB/(z-clipA);
}
float getPointZ(float d) {
    float clipA = zFar / (zFar - zNear);
    float clipB = zFar*zNear / (zNear - zFar);
    return (clipB + d*clipA)/d;
}

vec4 CalcEyeFromWindow(in vec3 windowSpace) {
    vec3 ndcPos;
    vec4 viewport = vec4(0.0, 0.0, g_windowWidth, g_windowHeight);
    ndcPos.xy = ((2.0 * windowSpace.xy) - (2.0 * viewport.xy)) / (viewport.zw) - 1;
//    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
    vec4 clipPos;
    clipPos.w = projectionMatrix[3][2]/(ndcPos.z-(projectionMatrix[2][2]/projectionMatrix[2][3]));
    clipPos.xyz = ndcPos * clipPos.w;
    return projectionInvMatrix * clipPos;
}

vec2 getBump(vec2 uv) {
    vec2 d = vec2(0.01, 0.0);
    return vec2(texture2D(tex, uv+d.xy).g-texture2D(tex, uv-d.xy).g,
                texture2D(tex, uv+d.yx).g-texture2D(tex, uv-d.yx).g);
}

void main() {

  vec3 normal = normalG;
  vec2 uv = uvG;
  vec3 tangent = tangentG;
  vec3 color = colorG;
  float sk = 0.2;

//  vec2 myUv = vec2(posW.x*1.1+posW.z*0.05, posW.x*0.1+posW.z*1.07+posW.y*0.23)*g_uvScale*1.0+vec2(0.5, 0.5);
//  myUv.y *= -1.0;
//  myUv.x += g_uvOfsX;

//  vec2 myUv2 = vec2(posW.z*1.4+posW.y*2.2, posW.x+posW.y*2.3)*g_uvScale*1.0+vec2(0.5, 0.5);
//  myUv2.y *= -1.0;
//  myUv2.x += g_uvOfsX;

// vec4 diffuse = texture2D(tex, myUv.xy*sk)*(1.0+0.0*texture2D(tex, myUv2.xy*sk*1.1));


  vec4 diffuse = texture2D(tex, uv*g_uvScale);

 //diffuse.rgb =  (vec3(1.0)-diffuse.rgb);
//  diffuse.rgb = clamp((diffuse.rgb-vec3(0.0))*1.0, 0.0, 1.0);
 diffuse.rgb *=diffuse.rgb*g_texBrightness;
 diffuse.rgb += vec3(g_texAmbient);
 diffuse.rgb *= g_color.rgb;

 vec2 b = vec2(0.0); // g_bump*getBump(uv.xy*g_uvScale*sk);
 vec3 normalW = normalize(normalWSG);
 tangent = normalize(tangent);
 vec3 bt = cross(normalW,tangent);
 vec3 normResult = normalW+tangent*b.x+bt*b.y;
 normResult = normalize(normResult);

 float vk =clamp(dot((normResult), normalize(vec3(1.0, 1.0, 0.0))), 0.0, 1.0);
// vk *= 1.0/(dot(posW,posW)*0.01+1.0)*1.0;
// vk *= vk;
// vk *= vk;
// diffuse.rgb *= (0.10+0.0*vk);

 normal = normResult;

// vec2 norkor = posG.xy/posG.z;
// norkor.xy = norkor.xy*0.5+0.5;
 vec3 normalB = (projectionMatrix*viewMatrix*vec4(normal, 0.0)).xyz;
 normalB /= normalB.z;
 vec2 norkor = vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight);
 vec2 paske = (norkor.xy)-0.025*(normalB.xy);
 paske = clamp(paske, 0.0, 1.0);
 float kk = 0.5;

 if (paske.x < 0.01 || paske.y < 0.01 || paske.x > 0.99 || paske.y > 0.99) kk = 0.0;

 vec3 jorge = texture2D(texPrevNorm, paske).rgb*1.0;
 vec4 efe = CalcEyeFromWindow(vec3(paske.x*g_windowWidth, paske.y*g_windowHeight, jorge.r));
 vec3 seze = (viewInvMatrix*vec4(efe.xyz, 1.0)).xyz*1.0;

 vec3 jorgeC = texture2D(texPrevNorm, norkor).rgb*1.0;
 vec4 efeC = CalcEyeFromWindow(vec3(norkor.x*g_windowWidth, norkor.y*g_windowHeight, jorgeC.r));
 vec3 sezeC = (viewInvMatrix*vec4(efeC.xyz, 1.0)).xyz*1.0;

// for (int i=-3;i<=3;i++) {
//     for (int j=-3;j<=3;j++) {
//         jorge = texture2D(texPrevNorm, vec2(norkor.x+i/g_windowWidth, norkor.y+j/g_windowHeight)).rgb;
//         efe = CalcEyeFromWindow(vec3(gl_FragCoord.x+i, gl_FragCoord.y+j, jorge.r));
//         seze += (viewInvMatrix*vec4(efe.xyz, 1.0)).xyz;
//     }
// }

// seze /= 49.0;


 vec3 sp = posW.xyz;
 sp = seze-sezeC;
 float kx = (dot(sp, sp));
 float dok = 0.1/(clamp(kx, 0.0, 10000.0)*0.10+1.0);
 // if (kx > 100.0) dok = 0.0;
 dok = clamp(dok, 0.0, 100.0);

 sp/=sqrt(kx);
 float dok2 = dot(sp, -normal)+0.0;
 dok2 = clamp(dok2*1.0, 0.0, 1.0);

 float dok2a = 0.5;
 dok *= (dok2*dok2a+1.0-dok2a);

// dok = 0.050;

 vec3 prevb = texture2D(texPrevBlurFrame, paske).rgb*clamp(dok*kk, 0.0, 1.0);
// diffuse.rgb *= 0.02;
// diffuse.rgb *= (1.0+30.0*g_prevBlurAmount*pow(clamp(prevb-vec3(0.00), 0.0, 8.0),vec3(0.50)));

 diffuse.rgb *= (1.0+1.0*g_prevBlurAmount*(pow(clamp(prevb-vec3(0.01), 0.0, 8.0),vec3(0.50))-vec3(0.0)));

// diffuse.rgb *= 0.1;
// diffuse.rgb += (0.0+0.06*g_prevBlurAmount*pow(clamp(prevb-vec3(0.00), 0.0, 8.0),vec3(0.50)));

 diffuse.rgb *= brightG;
// diffuse.rgb = prevb;

 //diffuse.rgb *= 0.0;

 //diffuse.rgb = vec3(10.0, 0.0, 0.0);

// diffuse.rgb = pow(diffuse.rgb, vec3(0.5));
 frag.rgb = diffuse.rgb;
 if (g_alpha < 0.0) {
    frag.a = dot(diffuse.rgb, vec3(1.0))*10.0*(-g_alpha);
 } else {
    frag.a = diffuse.a*g_alpha;
 }

 frag.a = clamp(frag.a, 0.0, 100.0);
 
 if (frag.a<0.01) {
   discard;
   return;
 }

 //frag.rgb = vec3(pow(1.0+0.1*sp.z,1.0))*0.1;
// frag.rgb = posW.xyz*0.2;
// frag.rgb = seze.xyz*0.2;
// frag.rgb = normalB.rgb;

// frag.rgb = vec3(dok*10.0);
// frag.rgb = seze.rgb;
// frag.rgb = posW.xyz;

  frag2.rgb = normalize(normResult).xyz;
  frag2 = clamp(frag2, -1.0, 1.0);
  frag2.a = 1.0;


}

