#version 430

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D tex2;
layout(binding=2) uniform sampler2D tex3;
layout(binding=3) uniform sampler2D tex4;
layout(binding=4) uniform sampler2D texPrevBlurFrame;
layout(binding=5) uniform sampler2D texPrevNorm;


in vec4 posG;
in vec3 normalG;
in vec3 normalWSG;
in vec2 uvG;
in vec3 tangentG;
in vec4 posW;
in float brightG;

layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;


#define PI 3.1415926

uniform float g_time;

uniform float g_uvOfsX = 0.0;
uniform float g_uvScale = 1.0;

uniform float g_texBrightness = 1.0;
uniform float g_texAmbient = 0.0;
uniform float g_prevAmount = 0.0;
uniform float g_prevBlurAmount = 0.0;
uniform float g_bump = 0.0;

uniform float g_zoomTime = 0.0;

uniform vec4 g_color = vec4(1.0);


uniform mat4 modelViewMatrix;
uniform mat4 modelViewInvMatrix;
uniform mat4 viewInvMatrix;
uniform mat4 viewMatrix;
uniform mat4 projectionMatrix;
uniform mat4 projectionInvMatrix;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
  return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

const float zFar = 1.0;
const float zNear = 0.0;

float getPointDist(float z) {
    float clipA = zFar / (zFar - zNear);
    float clipB = zFar*zNear / (zNear - zFar);
    return clipB/(z-clipA);
}
float getPointZ(float d) {
    float clipA = zFar / (zFar - zNear);
    float clipB = zFar*zNear / (zNear - zFar);
    return (clipB + d*clipA)/d;
}

vec4 CalcEyeFromWindow(in vec3 windowSpace) {
    vec3 ndcPos;
    vec4 viewport = vec4(0.0, 0.0, g_windowWidth, g_windowHeight);
    ndcPos.xy = ((2.0 * windowSpace.xy) - (2.0 * viewport.xy)) / (viewport.zw) - 1;
//    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
    ndcPos.z = (2.0 * windowSpace.z - zNear - zFar) / (zFar - zNear);
    vec4 clipPos;
    clipPos.w = projectionMatrix[3][2]/(ndcPos.z-(projectionMatrix[2][2]/projectionMatrix[2][3]));
    clipPos.xyz = ndcPos * clipPos.w;
    return projectionInvMatrix * clipPos;
}

vec2 getBump(vec2 uv) {
    vec2 d = vec2(0.01, 0.0);
    return vec2(texture2D(tex, uv+d.xy).g-texture2D(tex, uv-d.xy).g,
                texture2D(tex, uv+d.yx).g-texture2D(tex, uv-d.yx).g);
}

float aTanSafe(float y, float x) {
    float ret;
    if (x!=0.0) {
        if (x>0.0) {
            ret=atan(y/x);
        } else	{
            ret=atan(y/x)+3.141592;
        }
    } else	{
        if (y>=0.0) {
            ret=0.5*3.141592;
        } else {
            ret=-0.5*3.141592;
        }
    }
    return ret;
}

vec4 getRadTex(vec2 uv, vec2 uvd) {
    uv.x *= -1.0;
    float rada = sqrt(dot(uv, uv));
    float ang = aTanSafe(uv.y, uv.x)*1.0;
    float rad = sqrt(dot(uv, uv))*0.1;
    float timePos = 64.0*fract(g_zoomTime);

    float radABase = log(rad)-timePos;
    float radA = fract(radABase);
    float radAC = radABase-radA;
    float radAP = (radA+50.0)/60.0;
    float angA = ang+radAC;
    vec2 uvrA = vec2(cos(ang), sin(ang))*(radA);

    float radBBase = log(rad)-timePos+0.375;
    float radB = fract(radBBase);
    float radBC = radB-radBBase;
    float angB = ang+radBC;
    vec2 uvrB = vec2(cos(ang), sin(ang))*(radB);


    float fader = clamp((sin(radAP*150.0*2.0*3.141592+1.0*3.141592)+1.0)*0.5, 0.0, 1.0);
    vec4 diffuseA = texture2D(tex, uvrA+uvd)*fader;
    vec4 diffuseB = texture2D(tex, uvrB+uvd)*(1.0-fader);

    vec4 diffuse = diffuseA+diffuseB;

    return diffuse;
}

vec2 getRadBump(vec2 uv) {
    vec2 d = vec2(0.01, 0.0);
    return vec2(getRadTex(uv, d.xy).g-getRadTex(uv, -d.xy).g,
                getRadTex(uv, d.yx).g-getRadTex(uv, -d.yx).g);
}

uniform float g_centerAlpha = 1.0;
uniform float g_alphaFade = 1.0;

void main() {
  vec3 normal = normalG;
  vec2 uv = uvG;
  vec3 tangent = tangentG;
  float sk = 0.2;

  uv -= vec2(0.5);

  uv *= g_uvScale;

  vec4 diffuse = getRadTex(uv, vec2(0.0));

 diffuse.rgb *=g_texBrightness*1.0;
 diffuse.rgb += vec3(g_texAmbient);
 diffuse.rgb *= g_color.rgb;

 vec2 b = g_bump*getRadBump(uv.xy);
 vec3 normalW = normalize(normalWSG);
 tangent = normalize(tangent);
 vec3 bt = cross(normalW,tangent);
 vec3 normResult = normalW+tangent*b.x+bt*b.y;
 normResult = normalize(normResult);

 float vk =clamp(dot((normResult), normalize(vec3(1.0, 1.0, 0.0))), 0.0, 1.0);
 normal = normResult;

 vec4 normalBW = (projectionMatrix*viewMatrix*vec4(normal, 0.0));
 vec3 normalB = normalBW.xyz;
 normalB /= -normalBW.w;
 vec2 norkor = vec2(gl_FragCoord.x/g_windowWidth, gl_FragCoord.y/g_windowHeight);
 vec2 paske = (norkor.xy)+0.025*(normalB.xy);
 paske = clamp(paske, 0.0, 1.0);
 float kk = 0.5;

 if (paske.x < 0.01 || paske.y < 0.01 || paske.x > 0.99 || paske.y > 0.99) kk = 0.0;

 vec2 pasked = (norkor.xy)+0.002*(normalB.xy);
 pasked = clamp(pasked, 0.0, 1.0);
// if (paske.x < 0.01 || paske.y < 0.01 || paske.x > 0.99 || paske.y > 0.99) kk = 0.0;
 vec3 jorge = texture2D(texPrevNorm, pasked).rgb*1.0;
 vec4 efe = CalcEyeFromWindow(vec3(paske.x*g_windowWidth, paske.y*g_windowHeight, jorge.r));
 vec3 seze = (viewInvMatrix*vec4(efe.xyz, 1.0)).xyz*1.0;

 vec3 jorgeC = texture2D(texPrevNorm, norkor).rgb*1.0;
 vec4 efeC = CalcEyeFromWindow(vec3(norkor.x*g_windowWidth, norkor.y*g_windowHeight, jorgeC.r));
 vec3 sezeC = (viewInvMatrix*vec4(efeC.xyz, 1.0)).xyz*1.0;

 vec3 sp = posW.xyz;
 sp = seze-sezeC;
 float kx = (dot(sp, sp))*2.0;
 float dok = 0.1/(clamp(kx*kx, 0.0, 10000.0)*0.10+1.0);
 // if (kx > 100.0) dok = 0.0;
 dok = clamp(dok, 0.0, 100.0);

 float kx0 = dot(sp, sp);
 sp/=sqrt(kx0);
 float dok2 = dot(sp, normal)+0.0;
 dok2 = clamp(dok2*1.0, 0.0, 1.0);

 float dok2a = 0.50;
 dok *= (dok2*dok2a+1.0-dok2a);

 vec3 prevb = texture2D(texPrevBlurFrame, paske).rgb*clamp(dok*kk, 0.0, 1.0);
 diffuse.rgb *= (0.10+1.0*g_prevBlurAmount*(pow(clamp(prevb-vec3(0.001), 0.0, 8.0),vec3(1.0))-vec3(0.0)));
 diffuse.rgb *= brightG;




 frag = diffuse;

// if (radA < 1.5) {
//     frag.rgb = vec3(1.0);
// } else {
//     frag.rgb = vec3(0.0);
// }

// frag.rg = b;


 float alphaD = clamp(g_centerAlpha*2.0-0.025*g_alphaFade*sqrt(dot(posW.xz, posW.xz)), 0.0, 1.0);



 frag.a *= g_color.a*alphaD;

 frag.a = clamp(frag.a, 0.0, 1.0);

  frag2.rgb = normalize(normResult).xyz;
  frag2 = clamp(frag2, -1.0, 1.0);
  frag2.a = 1.0;

// float depthi = posG.z/posG.w;
// frag2.r = depthi;
// frag2.gb = normalize(-normalWSG).xy;
// frag2.a = 1.0;

}
