import QtQuick 2.3

import AdaptDemoSystem 1.0

Group {
    id: group
    enabled: syncRoot(group.name+".ON")
    property string file
    property string textureRT
    property int shaderSel: sync(group.name+".blendMode")
    property string shader: {
        if (shaderSel===0) return "fx/_SharedQML/overlay";
        if (shaderSel===1) return "fx/_SharedQML/overlayMul";
        if (shaderSel===2) return "fx/_SharedQML/overlayAdd";
        if (shaderSel===3) return "fx/_SharedQML/overlaySub";
        if (shaderSel===4) return "fx/_SharedQML/overlayScreen";
        return "fx/_SharedQML/overlay";
    }

    property real posX: sync(group.name+".x")
    property real posY: sync(group.name+".y")
    property real flip: sync(group.name+".flip")
    property real overlayAlpha: sync(group.name+".alpha")
    property real overlayScale: sync(group.name+".scale")

    property string textureWrap: "clamp"

    Blit {
        textureRT: "colorBuffer"
    }
    Shader {
        file: group.shader
    }
    Texture {
        textureUnit: 0
        textureRT: "colorBuffer"
    }

//    Texture {
//        textureUnit: 1
//        textureItem: kuvakuva
//        Image {
//            id: kuvakuva
//            visible: false
//            source: "../../images/"+group.file
//        }
//        textureWrap: group.textureWrap
//    }

    TextureSel { textureUnit: 1; name: group.name; textureWrap: sync(group.name+".texClamp") > 0.5 ? "clamp" : "repeat" }

    Texture {
        enabled: group.textureRT !== ""
        textureUnit: 1
        textureRT: group.textureRT
    }

    property real palaAmount: sync(group.name+".palaEmitAmp")*overlayAlpha

    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: group.flip
        }
        ShaderParam {
            paramName: "overlayAlpha"
            paramValue: overlayAlpha
        }
        ShaderParam {
            paramName: "g_overlayScale"
            paramValue: overlayScale
        }
        ShaderParam {
            paramName: "g_posX"
            paramValue: group.posX
        }
        ShaderParam {
            paramName: "g_posY"
            paramValue: group.posY
        }

        ShaderParam { paramName: "g_scaleCX"; paramValue: sync(group.name+".scaleCX") }
        ShaderParam { paramName: "g_scaleCY"; paramValue: sync(group.name+".scaleCY") }
        ShaderParam { paramName: "g_scaleX"; paramValue: sync(group.name+".scaleX") }
        ShaderParam { paramName: "g_scaleY"; paramValue: sync(group.name+".scaleY") }
        ShaderParam { paramName: "g_rot"; paramValue: sync(group.name+".rot") }

        ShaderParam { paramName: "g_emitAmp"; paramValue: palaAmount }
        ShaderParam { paramName: "g_emitThr"; paramValue: sync(group.name+".palaEmitThr") }

        type: "quad"
        depthTest: false
        depthWrite: false
        drawBuffers: (Math.abs(palaAmount) > 0.001) ? 3 : 1
       //  drawBuffers: 3
        blendMode: "off"
    }


}

