//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID11010595_f440_4693_a93d_b8b234660e7a
{
    public class Class__PbrMaterial : OperatorPart.Function, IPbrMaterial
    {
        //>>> _inputids
        private enum InputId
        {
            Scene = 0,
            Albedo = 1,
            Roughness = 2,
            Metal = 3,
            Normal = 4,
            AO = 5,
            Emissive = 6
        }
        //<<< _inputids
    
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Scene = inputs[(int)InputId.Scene];
            var Albedo = inputs[(int)InputId.Albedo].Eval(context).Image; // Needs to be checked for null!
            var Roughness = inputs[(int)InputId.Roughness].Eval(context).Image; // Needs to be checked for null!
            var Metal = inputs[(int)InputId.Metal].Eval(context).Image; // Needs to be checked for null!
            var Normal = inputs[(int)InputId.Normal].Eval(context).Image; // Needs to be checked for null!
            var AO = inputs[(int)InputId.AO].Eval(context).Image; // Needs to be checked for null!
            var Emissive = inputs[(int)InputId.Emissive].Eval(context).Image; // Needs to be checked for null!
            //<<< _params

            // store values for later use of IMaterial
            this.Albedo = Albedo;
            this.Roughness = Roughness;
            this.NormalMap = Normal;
            this.Metal = Metal;
            this.AO = AO;
            this.Emissive = Emissive;

            var prevMaterial = (IPbrMaterial) context.Objects[OperatorPartContext.PBR_MATERIAL_ID];
            context.Objects[OperatorPartContext.PBR_MATERIAL_ID] = this;

            Scene.Eval(context);

            context.Objects[OperatorPartContext.PBR_MATERIAL_ID] = prevMaterial;

            return context;
        }

        public Texture2D Albedo { get; private set; }
        public Texture2D Roughness { get; private set; }
        public Texture2D NormalMap { get; private set; }
        public Texture2D Metal { get; private set; }
        public Texture2D AO { get; private set; }
        public Texture2D Emissive { get; private set; }
    }
}

