//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;

namespace Framefield.Core.IDb4d29ab1_e18e_46c2_9289_e6f7c9c2b2c1
{
    public class Class_VertexTextureFetch : FXSourceCodeFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            Image = 2
        }
        //<<< _inputids

        #region Renderer
        public class Renderer : BaseRenderer
        {
            public override void SetupEffect(OperatorPartContext context)
            {
                base.SetupEffect(context);
                try
                {
                    SetupMaterialConstBuffer(context);
                    SetupFogSettingsConstBuffer(context);
                    SetupPointLightsConstBuffer(context);

                    using(var textureSRV = new ShaderResourceView(context.D3DDevice, Texture))
                    {
                        var textureVariable = context.Effect.GetVariableByName("inputTexture").AsShaderResource();
                        if (textureVariable != null)
                            textureVariable.SetResource(textureSRV);
                    }
                }
                catch (Exception e)
                {
                    Logger.Error(ParentFunc, "Error building constant buffer: {0} - Source: {1}", e.Message, e.Source);
                }
            }
            public OperatorPart.Function ParentFunc { get; set; }
            public Texture2D Texture { get; set; }
            //private ShaderResourceView _textureSRV;
        }
        #endregion

        public Class_VertexTextureFetch()
        {
            _renderer = new Renderer() { ParentFunc = this };
        }

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return context;
            //<<< _params

            _renderer.Texture = Image;
            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            var prevEffect = context.Effect;
            var prevRenderer = context.Renderer;

            context.Effect = _effect;
            context.Renderer = _renderer;

            Scene.Eval(context);

            context.Effect = prevEffect;
            context.Renderer = prevRenderer;            

            return context;
        }

        Renderer _renderer;
    }
}


