//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID9d7c1faf_9417_410d_8ca5_a3028d1c143f
{
    public class Class_Point : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            PositionX = 0,
            PositionY = 1,
            PositionZ = 2,
            Radius = 3
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var PositionX = inputs[(int)InputId.PositionX].Eval(context).Value;
            var PositionY = inputs[(int)InputId.PositionY].Eval(context).Value;
            var PositionZ = inputs[(int)InputId.PositionZ].Eval(context).Value;
            var Position = new Vector3(PositionX, PositionY, PositionZ);
            var Radius = inputs[(int)InputId.Radius].Eval(context).Value;
            //<<< _params
                        
            if(  Math.Abs(Position.X - _positionWithRadius.X) > EPSILON 
              || Math.Abs(Position.Y - _positionWithRadius.Y) > EPSILON 
              || Math.Abs(Position.Z - _positionWithRadius.Z) > EPSILON
              || Math.Abs(Radius - _positionWithRadius.W) > EPSILON
              ) {
              //Changed = true;
              _positionWithRadius = new Vector4( PositionX, PositionY, PositionZ, Radius);
            } 
            else {
                Changed = false;
            }
            
            context.Dynamic = _positionWithRadius;
            return context;
        }
        Vector4 _positionWithRadius = Vector4.Zero;
        const float EPSILON = 0.001f;
    }
}

