//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.IO;

namespace Framefield.Core.IDb9e0cb81_b961_40bb_a939_ea66535b43ba
{
    public class Class_LoadSmesh2 : OperatorPart.Function
    {
        public override void Dispose()
        {
            Utilities.DisposeObj(ref _meshResource);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {

            try
            {
                UpdateMesh(context, inputs);
                if (_meshResource.Meshes.Any())
                {
                    context.Mesh = _meshResource.Meshes[0];
                }
            }
            catch (Exception)
            {
                //Logger.Error(this,"error");
            }

            return context;
        }

        private void UpdateMesh(OperatorPartContext context, IList<OperatorPart> inputs)
        {
            if (!Changed) 
                return;

            var FilePath = inputs[0].Eval(context).Text;

            Dispose();
            if(File.Exists( FilePath)) {
                _meshResource = ResourceManager.ReadSmesh(FilePath);
            }
            else {
                Logger.Warn(this, "File does not exist '{0}'", FilePath);
            }
                
                
            Changed = false;
        }

        private MeshResource _meshResource;
    }
}


