using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID624d15ea_de05_4913_8b76_3279ca4f1652
{
    public class Class_HSB2RGB : OperatorPart.Function
    {
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            var Hue = (float) inputs[0].Eval(context).Value;
            var Saturation = (float) inputs[1].Eval(context).Value;
            var Brightness = (float) inputs[2].Eval(context).Value;
            
            
            // Need to add something here...
            
                // Calculate HSL (c2) from RGB Colour c1 (pSrc)
                // Hue is in degrees
                // Lightness is between 0 and 1
                // Saturation is between 0 and 1
            
                var colors = new List<float>(2);
                //Logger.Debug(this,"HSB: {0} {1} {2}", Hue, Saturation, Brightness);
            
                  float fSatR, fSatG, fSatB;
                  if (Hue < 120.0f) 
                  {
                    fSatR = (120.0f - Hue) / 60.0f;
                    fSatG = Hue / 60.0f;
                    fSatB = 0.0f;
                  } 
                  else if (Hue < 240.0f) 
                  {
                    fSatR = 0.0f;
                    fSatG = (240.0f - Hue) / 60.0f;
                    fSatB = (Hue - 120.0f) / 60.0f;
                  } 
                  else 
                  {
                    fSatR = (Hue - 240.0f) / 60.0f;
                    fSatG = 0.0f;
                    fSatB = (360.0f - Hue) / 60.0f;
                  }
                  fSatR = (fSatR < 1.0f) ? fSatR : 1.0f;
                  fSatG = (fSatG < 1.0f) ? fSatG : 1.0f;
                  fSatB = (fSatB < 1.0f) ? fSatB : 1.0f;
            
                  float fTmpR = 2.0f * Saturation * fSatR + (1.0f - Saturation);
                  float fTmpG = 2.0f * Saturation * fSatG + (1.0f - Saturation);
                  float fTmpB = 2.0f * Saturation * fSatB + (1.0f - Saturation);
            
                  float fR, fG, fB;
                  if (Brightness < 0.5f) 
                  {
                    fR = Brightness * fTmpR;
                    fG = Brightness * fTmpG;
                    fB = Brightness * fTmpB;
                  } 
                  else 
                  {
                    fR = (1.0f - Brightness) * fTmpR + 2.0f * Brightness - 1.0f;
                    fG = (1.0f - Brightness) * fTmpG + 2.0f * Brightness - 1.0f;
                    fB = (1.0f - Brightness) * fTmpB + 2.0f * Brightness - 1.0f;
                  }
                  
                  colors.Add(fR);
                  colors.Add(fG);
                  colors.Add(fB);
                  
                int index= (int)(outputIdx) % 3;
                context.Value = colors[index];
            //!!automatic generated code starts here
            return context;
        }
    }
}

