//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID02b57651_5e54_4a4c_ac9b_b303f11fe18c
{
    public class Class_FallBackImage : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            TestImage = 0,
            ImageFallback = 1
        }
        //<<< _inputids
    
        private bool BuildRenderTarget(OperatorPartContext context, int width, int height) {
            var resourceChanged = ResourceManager.ValidateRenderTargetResource(ref _renderTargetResource, OperatorPart, context.D3DDevice,
                                                                               width, height);
            if (resourceChanged) {
                Utilities.DisposeObj(ref _renderTargetView);
                _renderTargetView = new RenderTargetView(context.D3DDevice, _renderTargetResource.Texture);
            }
            return resourceChanged;
        }

        public override void Dispose() {
            ResourceManager.Dispose(_renderTargetResource);
            Utilities.DisposeObj(ref _renderTargetView);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            var previousTexture = context.Image;
            context.Image =null;

            var TestImage = inputs[(int)InputId.TestImage].Eval(context).Image; 
                        
            //Logger.Info(this, TestImage.Description.Height.ToString());
            var testImageIsInvalid = TestImage == null  || inputs[(int)InputId.TestImage].Connections.Count() == 0;
            if(testImageIsInvalid) {
                var ImageFallback = inputs[(int)InputId.ImageFallback].Eval(context).Image;
                context.Image = ImageFallback;                
            }
            else {
                context.Image = TestImage;                                            
            }
            
            return context;
        }

        Resource _renderTargetResource;
        RenderTargetView _renderTargetView;
    }

}


