;                       /|
;                      //|.
;                     //_| .
;                 __ // /| .
;                /_ \/\__|. 
;                \\_/  _/|_
;                .g.e.n.d.a.
;
;______________________________________________________
;
;
;              rolpower 256b
;
;______________________________________________________
;
;	CODE:	        svoy
;______________________________________________________
;
;         SillyVenture 2K18
;         256b intro (compo filler)
;	  Extended version, w/o run, but works with
;         SIDE, colors randomization, couple of 
;	  stable illegals: LAX, SAX. 
;______________________________________________________
; tomaswoj@gmail.com
; http://pl.linkedin.com/in/tomaswoj
; Cracow

; good illegal opcodes cheatsheet:
; https://xxl.atari.pl/sally-6502c/?fbclid=IwAR3OzILLYZpJnamVOBDI--wNp4vY2LQcgmczaggsgr0E0glVCs9L9vWFS88

	opt h+
	
	
	org $2281

SUNBASE	equ $8000 ; 2K boundary
SCRDAT	equ $4000

FRMSKIP	equ $3 ; this is also used to setup PMG
PMGSKIP	equ $3
FRMDEN	equ $91 ; frame skip counter
PMGDEN	equ $92
FRMCNT	equ $93
FILL_L	equ $94
FILL_H	equ $95


	lda #$fe  ; OS DISABLE, lets rock! 
	sta $d301 

	;lda <nmi ; POT 2 bytes, if we can move the org around, so $fe can be reused for <nmi
	sta $fffa	
	lda >nmi
	sta $fffb


; create display list		
crdlist:

; DL header and ending
	ldy #7	 
dlhedlp:
	lda DLHED-1,y
	;sta $A036-1,y
	sta $c8fd-1,y
	lda DLEND-1,y 
	sta $D401-1,y ; DL set ($D402/$D403)
	;sta $A039+3*201+1,y
	sta $c900+3*201-1,y
	dey
	bne dlhedlp	
	
	; initialize address
	;lda #<($A039) ; POT, swapped nmi address
	;sta FILL_L
	;lda #>($A039) ; POT, swapped nmi address
	;sta FILL_H
	
; DL contents (lines)
	ldx #201;
	;ldx #$c9; FILL_L = $00, FILL_H=$C9, so DList start would be $c8fd
	stx FILL_H 
	;reuse from the upper dey
	;ldy #0
dlist_l:
	ldy #0
	lda #($80+$4F) ; F + DLI + LMS		
	sta (FILL_L),y	
	txa	
	and #%00100000
	lsr
	lsr
	lsr
	; fill it with either 0 or 4 (depending on the 5th bit above)
	iny	
	sta (FILL_L),y	
	lda #>SCRDAT
	iny 
	sta (FILL_L),y	
	; move target addr by 3 bytes
	lda FILL_L
	adc #3
	bcc skipbcc3
	inc FILL_H
skipbcc3
	sta FILL_L	
	

; as a side effect in this loop - populate chessboard table
	txa
	and #%00000100
	bne datf ; data full
	beq date ; data empty
datf	
	lda #$ff
date	
	sta SCRDAT-1,x	
	
	dex
	bne dlist_l
			
	; initialize timers			
	;lda #FRMSKIP ; used 7 above
	;sta FRMDEN ; 
	
; populate all the PMG stuff; POT -5b if pulled into the loop below (but minor artifact appears)
;	ldy #28	
;pmginit
;	lda PMGDAT-1,y
;	sta $D000-1,y
;	dey
;	bne pmginit	

	;lda #>SUNBASE
	;sta $D407; set PMBASE, needs to be at 1K boundary for double resoultuon and 2K boundary for single resolution sprites (Every line)
		
;copy pattern to PMGs
	ldy #128
	; yay, we can reuse it (128->$80) for PMBASE
	sty $D407
ptrncpy	
	tya
	and #%00001111
	tax
	;anx #%00001111; we cannot use it here
	lda PTRN,x
	sta SUNBASE+384,y
	sta SUNBASE+512,y
	sta SUNBASE+512+128,y
	sta SUNBASE+512+256,y
	sta SUNBASE+512+384,y

	lda PMGDAT-1,y; POT 5b
	sta $D000-1,y

	dey
	bne ptrncpy
		
		
	lda #%00 10 11 10
	sta $d400

	;lda #3
	;sta $D01D ; GRACTL -set both players and missles - done below, with nice 'surprise' flow
	
	;rts
				
frame
	; this does nothing! :)	
	bne frame
					
nmi
	dec FRMCNT
	bne skpcol
	; change colors every 4.x seconds
	lax $d20a ; use it for GTIA index and color selection
	and #%00000001 ; works well without anx below (that is unstable!) and is stable
	tay
	lda DLHED,y
setgtia
	sta $D01B ; set GPRIOR to either 80 or 16
	ldy #8
colupd
	txa
	and #%11110000
	ora PMGCOL-1,y
	sta $D012-1,y
	dey
	bne colupd	
	
	;ldx #$ff
	;dex ; nice!
	;jmp skpblk			
skpcol		
	;ldx #$00 ; use value in x POT
skpblk	
	sax $d018 ; POT 1b, but no nice flash, and illegal :)
	sax $d01a
	;stx $d018 ; back to black (or white, every 4.x s) ; POT - this is to get nice clean background in non-GTIA mode
	;stx $d01a ; back to black (or white, every 4.x s)


;update twister and background chessboard 	
	dec FRMDEN
	bne skp	
;update background pattern
;	ldx #48	
;	lda SCRDAT	
;	rol
	; rotate all bytes	
;patloop:
;	rol SCRDAT-1,x
;	dex
;	bne patloop	 
skpat		

; now update the PMG twister AND background pattern

	ldx #128
	ldy SCRDAT
movelp
	; upgrade background pattern (that extends to 201 bytes, so gr8!)
	tya
	rol
	rol SCRDAT-1,x
	ldy SCRDAT-1,x
	; use SCRDAT in y to roll the next one
	;tay
	lda SUNBASE+384+128,x
	rol	
	rol sunbase+384,x ; missles
	rol sunbase+896,x
	rol sunbase+768,x
	rol sunbase+640,x
	rol sunbase+512,x					
	dex	
	bne movelp
	
	lda #FRMSKIP
	sta FRMDEN
	sta $D01D		
			
skp
	rti

;PMGDAT	dta b(60,68,84,116,136,135,134,132,0,1,3,1,168,0,0,0,0,0,$54,$58,$5c,$58,0,0,0,$54,0,80);
;PMGDAT	dta b(90,98,114,146,166,165,164,162,0,1,3,1,168,0,0,0,0,0,$54,$58,$5c,$58,0,0,0,$54,0,80);
;PMGDAT	dta b(90,98,114,146,166,165,164,162,0,1,3,1,168,0,0,0,0,0); moved below, to get 5 zero bytes 
;PMGCOL  dta b($4,$8,$c,$8,0,0,0,$4,0,16);
PMGCOL  dta b($4,$8,$c,$8,0,0,0,$4);0,16); no need for that when we switch the GTIA ourselves
;DLHED   dta b(16,$50,$70); first 2 bytes used for GTIAVAL, a bit assymetric, but no one will notice :)
DLHED	dta b(16,$50);
PTRN	dta b($F0,$F4,$E5,$E1,$C3,$D3,$97,$87,$F,$4F,$5E,$1E,$3C,$3C,$78,$78);
;DLEND	dta b($41,$36,$a0);
DLEND	dta b($41,$fd,$c8);
PMGDAT	dta b(90,98,114,146,166,165,164,162,0,1,3,1,168);,0,0,0,0,0);
;GTIAVAL dta b(16,80);

	end	
		
	