; TIATracker music player
; Copyright 2016 Andre "Kylearan" Wichmann
; Website: https://bitbucket.org/kylearan/tiatracker
; Email: andre.wichmann@gmx.de
;
; Licensed under the Apache License, Version 2.0 (the "License");
; you may not use this file except in compliance with the License.
; You may obtain a copy of the License at
;
;   http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

; Song author: %%AUTHOR%%
; Song name: %%NAME%%

; @com.wudsn.ide.asm.hardware=ATARI2600

        processor 6502
        include vcs.h
        
; TV format switches
PAL = 1 ;%%PAL%%
;NTSC = %%NTSC%%

        IF PAL
TIM_VBLANK      = 43
TIM_OVERSCAN    = 36
TIM_KERNEL      = 19
        ELSE
TIM_VBLANK      = 45
TIM_OVERSCAN    = 38
TIM_KERNEL      = 15
        ENDIF


; =====================================================================
; Variables
; =====================================================================

        SEG.U   variables
        ORG     $80

        include "test12_variables.asm"

; test
player_time_max         ds 1


; =====================================================================
; Start of code
; =====================================================================

        SEG     Bank0
        ORG     $f000

Start   SUBROUTINE

        ; Clear zeropage        
        cld
        ldx #0
        txa
.clearLoop:
        dex
        txs
        pha
        bne .clearLoop

        include "test12_init.asm"

        
; =====================================================================
; MAIN LOOP
; =====================================================================

;                LDA #$00
;                STA COLUBK	; Set Background to Black
MainLoop:

; ---------------------------------------------------------------------
; Overscan
; ---------------------------------------------------------------------

Overscan        SUBROUTINE

                LDA #0 
                STA VBLANK 	; Enable TIA Output
;                sta $FF
                LDA #12*8
                STA COLUPF

       ; Start of Vertival Blank
       ; Count 37 Scanlines
        lda #2
        sta VBLANK
        lda #TIM_OVERSCAN
        sta TIM64T

;        ; Do overscan stuff

;>>>> Free space for code ends here
.waitForIntim
        lda INTIM
        bne .waitForIntim

; ---------------------------------------------------------------------
; VBlank
; ---------------------------------------------------------------------

VBlank  SUBROUTINE

        lda #%1110
.vsyncLoop:
        sta WSYNC
        sta VSYNC
        lsr
        bne .vsyncLoop
        lda #2
        sta VBLANK
        lda #TIM_VBLANK
        sta TIM64T

        ; Do VBlank stuff
        include "test12_player.asm"
        
        ; Measure player worst case timing
        lda #TIM_VBLANK
        sec
        sbc INTIM
        cmp player_time_max
        bcc .noNewMax
        sta player_time_max
.noNewMax:

.waitForVBlank:
        lda INTIM
        bne .waitForVBlank
        sta WSYNC
        sta VBLANK


; ---------------------------------------------------------------------
; Kernel
; ---------------------------------------------------------------------

Kernel  SUBROUTINE
        lda #TIM_KERNEL
;        sta 294;T1024T
        sta T1024T

        ; Do kernel stuff

         LDY #0 
         STY VBLANK       ; Enable TIA Output

;	ldx #0
;cp:
;	jsr apf
;	jsr apf
;	jsr apf
;	jsr apf
;	jsr apf
;	jsr apf
;	jsr apf
;;	jsr apf
;
;	inx
;	cpx #8
;	bne cp
;	
;		lda #0
;		sta PF0
;		sta PF1
;		sta PF2

	ldx $90
	lda sint,x
	tax

;	sec
;	sbc #192
;	eor #$FF
	tay

	lda #192+8+10+8
	sta $91
rasta
	lda raster,x
	;lda sint,x
	sta COLUBK
	stx COLUPF

	stx PF1

;	nop
	nop
	nop
	nop
	nop
	sty COLUPF
	sty PF2

	nop
	nop
	nop
	nop
	lda #0
	stx COLUPF
	nop
	nop
	nop
	nop
;	lda #0
	sty COLUPF

;	lda raster,x
;	sta COLUBK

	STA WSYNC
	
	inx
	dey

	dec $91
	bne rasta

	lda #0
	sta COLUBK
		sta PF0
		sta PF1
		sta PF2

	inc $90
	inc $90

.waitForIntim:
        lda INTIM
        bne .waitForIntim

;        lda #TIM_KERNEL
;        sta T1024T

        jmp MainLoop
;apf:
;
;		lda #0
;		sta PF0
;	lda pf0,x
;		sta PF0
;		lda #0
;		sta PF1
;	lda pf1,x
;		sta PF1
;		lda #0
;		sta PF2
;	lda pf2,x
;		sta PF2
;
;
;		STA WSYNC
;		rts
;pf0
; dc.b 00, $00, $00, $70, $10, $10, $10, $70
;pf1
; dc.b 00, $00, $00, $E8, $AD, $AA, $A8, $E8
;pf2
; dc.b 00, $00, $00, $1D, $15, $1D, $05, $05
raster:
rastba1 = $40
rastbas = $D0

 ds 88-8
 dc.b rastbas+0,rastbas+2,rastbas+4,rastbas+6,rastbas+8,rastbas+10,rastbas+12,rastbas+14
 dc.b rastbas+14,rastbas+12,rastbas+10,rastbas+8,rastbas+6,rastbas+4,rastbas+2,rastbas+0
 ds 88+16+8
 dc.b rastba1+0,rastba1+2,rastba1+4,rastba1+6,rastba1+8,rastba1+10,rastba1+12,rastba1+14
 dc.b rastba1+14,rastba1+12,rastba1+10,rastba1+8,rastba1+6,rastba1+4,rastba1+2,rastba1+0
 ds 64
sint: include "sintab.h"
; =====================================================================
; Data
; =====================================================================

        include "test12_trackdata.asm"


; =====================================================================
; Vectors
; =====================================================================

        echo "ROM left: ", ($fffc - *)

        ORG             $fffc
        .word   Start
        .word   Start
