//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDfda84d27_f278_440b_baf9_4a41fcd7e929
{
    public class Class_DepthStencilState : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            DepthEnabled = 1,
            DepthWriteMask = 2,
            Comparison = 3,
            StencilEnabled = 4,
            StencilReadMask = 5,
            StencilWriteMask = 6
        }
        //<<< _inputids

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _depthStencilState);
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var DepthEnabled = (int) inputs[(int)InputId.DepthEnabled].Eval(context).Value;
            var DepthWriteMask = (int) inputs[(int)InputId.DepthWriteMask].Eval(context).Value;
            var Comparison = (int) inputs[(int)InputId.Comparison].Eval(context).Value;
            var StencilEnabled = (int) inputs[(int)InputId.StencilEnabled].Eval(context).Value;
            var StencilReadMask = inputs[(int)InputId.StencilReadMask].Eval(context).Value;
            var StencilWriteMask = inputs[(int)InputId.StencilWriteMask].Eval(context).Value;
            //<<< _params

            if (Changed)
            {
                var depthStencilDescription = new DepthStencilStateDescription();
                depthStencilDescription.DepthComparison = (Comparison) Comparison;
                depthStencilDescription.DepthWriteMask = (DepthWriteMask) DepthWriteMask;
                depthStencilDescription.IsDepthEnabled = DepthEnabled == 1.0f ? true : false;
                depthStencilDescription.IsStencilEnabled = StencilEnabled == 1.0f ? true : false;
                depthStencilDescription.StencilReadMask = (byte) StencilReadMask;
                depthStencilDescription.StencilWriteMask = (byte) StencilWriteMask;
                //depthStencilDescription.BackFace = ;
                //depthStencilDescription.FrontFace = ;
    
                Utilities.DisposeObj(ref _depthStencilState);
                _depthStencilState = new DepthStencilState(context.D3DDevice, depthStencilDescription);
                Changed = false;
            }

            var prevDepthState = context.DepthStencilState;
            context.DepthStencilState = _depthStencilState;
            SceneInput.Eval(context);
            context.DepthStencilState = prevDepthState;

            return context;
        }

        private DepthStencilState _depthStencilState;
    }
}
