#version 430


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 15) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];
in float bright[3];

out vec4 posG;
out vec3 normalG;
out float axisG;


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;


uniform float g_texW = 1280;
uniform float g_texH = 720;

layout(binding=0) uniform sampler2D tex;

uniform float g_voxelDim;

void main(void) {

    vec3 faceNormal = vec3(0.0);
    for (int i = 0; i < gl_in.length(); ++i) {
        normalG = (modelMatrix*vec4(normal[i],0.0)).xyz;
        faceNormal += normalG;
    }
    vec3 na = abs(faceNormal);
    if (na.x >= na.y && na.x >= na.z) {
        axisG = 0.0;
    } else if (na.y >= na.x && na.y >= na.z) {
        axisG = 1.0;
    } else if (na.z >= na.x && na.z >= na.y) {
        axisG = 2.0;
    }

    //axisG = 2.0;

    for (int i = 0; i < gl_in.length(); ++i) {
        gl_Position = gl_in[i].gl_Position;
        posG = modelMatrix * gl_Position;
        normalG = (modelMatrix*vec4(normal[i],0.0)).xyz;
        if (axisG < 0.5) {
            posG.xyz = posG.zyx;
        } else if (axisG < 1.5) {
            posG.xyz = posG.zxy;
        }
        gl_Position = posG;
        EmitVertex();
    }


    EndPrimitive();
}
