import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    FlyCamera { id: flyCam }
    Defaults { }

    BgBall { }

    BreakIn { name: "bgBreak" }

    BgBlur { }

    Group {
        id: mesh
        name: "mesh"
        enabled: sync(mesh.name+".ON")
        Shader { file: sceneDir+"smLay" }
        TextureSel { textureUnit: 0; name: parent.name }
        DrawMesh {
//            Clear {
//                enabled: sync("bgClear") > 0.5
//                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; cD: 1.0;
//            }

            file: meshSel(mesh.name)
            enabled: true; smoothNormals: true; normalSmoothAngle: 20;
            blendMode: blendSel(bgBall.name)
            depthTest: true; depthWrite: true;
            //  cull: true; cullBack: true
            Pos { x: syncOsc(mesh.name+".posX"); y: syncOscFFT(mesh.name+".posY"); z: 0.0}
            Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: sync(mesh.name+".scale"); x: 1.0; y: 1.0; z: 1.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: sync(mesh.name+".uvScale")}
            ShaderParam { paramName: "g_uvScaleY"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvOfsX"; paramValue: syncOsc(mesh.name+".uvOfsX") }
            ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(mesh.name+".uvOfsY") }
            ShaderParam { paramName: "g_bump"; paramValue: 0.650}
            ShaderParam { paramName: "g_texBrightness"; paramValue: sync(mesh.name+".bright") }
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0 }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
            ShaderParam { paramName: "g_bright"; paramValue: 1.0}
        }
    }

    Blit { textureRT: "currentAlpha" }
    Blit { textureRT: "emitBuf"; blitRT: 2 }
    PalaFlow { }

//    Group {
//        // pala flow
//        id: palaFlow
//        name: "palaFlow"
//        enabled: sync(name+".ON") > 0.5

//        property bool reset: sync(name+".reset") > 0.5

//        RenderTarget {
//            RenderTargetLayer {
//                textureRT: "palaFlowSim1"; format: "RGBA32F";
//                width: demo.windowWidth; height: demo.windowHeight
//                Clear {
//                    enabled: frameIndex<2 || palaFlow.reset
//                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
//                }
//            }
//        }
//        RenderTarget {
//            RenderTargetLayer {
//                textureRT: "palaFlowSim2"; format: "RGBA32F";
//                width: demo.windowWidth; height: demo.windowHeight
//                Clear {
//                    enabled: frameIndex<2 || palaFlow.reset
//                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
//                }
//            }
//        }

//        VariClock {
//            id: flowPhaseClock
//            clockSpeed: sync(palaFlow.name+".noiseSpeed")*0.1*sync(palaFlow.name+".noiseFreq")
//            reset: sync(palaFlow.name+".reset")
//            resetTime: 0.0
//        }

//        Shader { file: sceneDir+"palaFlow" }
//        Blit { textureRT: "current" }
//        Texture { textureUnit: 0; textureRT: "current" }
//        Texture { textureUnit: 1; textureWrap: "clamp"; textureRT: ((frameIndex&1)===0) ? "palaFlowSim1" : "palaFlowSim2" }

//        RenderTarget {
//            RenderTargetLayer {
//                textureRT: ((frameIndex&1)===0) ? "palaFlowSim2" : "palaFlowSim1"
//                format: "RGBA32F";
//                width: demo.windowWidth; height: demo.windowHeight
//            }
//            DrawVB {
//                type: "quad"
//                depthTest: false; depthWrite: false
//                blendMode: "off"
//                drawBuffers: 1
//                ShaderParam { paramName: "g_prevAmount"; paramValue: 1.0 }

//                ShaderParam { paramName: "freq"; paramValue: sync(palaFlow.name+".noiseFreq") }
//                ShaderParam { paramName: "amp"; paramValue: sync(palaFlow.name+".noiseAmp") }
//                ShaderParam { paramName: "prev"; paramValue: sync(palaFlow.name+".flowPrev") }
//                ShaderParam { paramName: "dirX"; paramValue: sync(palaFlow.name+".flowDirX") }
//                ShaderParam { paramName: "dirY"; paramValue: sync(palaFlow.name+".flowDirY") }
//                ShaderParam { paramName: "phase"; paramValue: flowPhaseClock.time }

//                //            float freq = 3.0;
//                //            float amp = 5.0;
//                //            float prev = 0.95;
//                //            float dirX = 0.0;
//                //            float dirY = -0.25;
//                //            float phase = 0.0; // = g_time*freq;
//            }
//        }
//        Shader { file: sceneDir+"mixFlow" }
//        Texture { textureUnit: 0; textureRT: "current" }
//        Texture { textureUnit: 1; textureRT: ((frameIndex&1)===0) ? "palaFlowSim2" : "palaFlowSim1" }
//        Texture { textureUnit: 2; textureRT: "bgBlur" }
//        DrawVB {
//            type: "quad"
//            depthTest: false; depthWrite: false
//            blendMode: "off"
//            drawBuffers: 1
//            ShaderParam { paramName: "g_currentAmount"; paramValue: sync(palaFlow.name+".currentAmount") }
//            ShaderParam { paramName: "g_prevAmount"; paramValue: sync(palaFlow.name+".flowAmount") }
//            ShaderParam { paramName: "g_alphaAmp"; paramValue: sync(palaFlow.name+".alphaAmp") }
//            ShaderParam { paramName: "g_mixMode"; paramValue: sync(palaFlow.name+".mixMode") }


//        }
//    }

    Coords {}
    Tonemap {}
    SMAA {}

}
