import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    FlyCamera { id: flyCam }
    Defaults {}

    BgBall { name: "bgBall" }
    BreakIn { name: "bgBreak" }
    EmitPart {
        id: bgEmitPart
        name: "bgPart"
        // do not modify this dynamically on fly during the demo
        maxParticles: 200000
        voxBD: voxel.baseDim
        voxAS: voxAreaSize
    }

    Blit { textureRT: "bgBlurGlass" }
    BlurRt { name: "bgBlurGlass"; textureRT: "bgBlurGlass" }

    BgBlur { }

    Shader { file: "smPlastic" }
    DrawMesh { // clear only the alpha channel
        Clear { mR: false; mG: false; mB: false; cA: 0.0 }
        file: "mesh/tri.lwo";
        Sca { s: 0.0; x: 1.0; y: 1.0; z: 1.0 }
    }

    BreakIn { name: "breakin" }
    Vox { id: voxel }
    EmitPart {
        id: emitPart
        name: "part"
        // do not modify this dynamically on fly during the demo
        maxParticles: 1000000
        voxBD: voxel.baseDim
        voxAS: voxAreaSize
    }


    //Griizster { }

    Greets { name: "text" }
    Greets { name: "greets1" }
    Greets { name: "greets2" }
    Greets { name: "greets3" }
    Greets { name: "greets4" }
    Greets { name: "greets5" }
    Greets { name: "greets6" }


    Blit { textureRT: "bgBlurMesh" }
    BlurRt { name: "bgBlurMesh"; textureRT: "bgBlurMesh" }

    Aalto { }

    Blit { textureRT: "currentAlpha" }
    Blit { textureRT: "depth"; blitRT: 1 }
    Blit { textureRT: "emitBuf"; blitRT: 2 }
    Reflect { }

    property real palaBreakinPosWeight: sync("palaFlow.breakin.posWeight")

    PalaFlow {
        cenX2D: demo.getSavePointX2D("breakin_SP")*palaBreakinPosWeight+0.5*(1.0-palaBreakinPosWeight)
        cenY2D: demo.getSavePointY2D("breakin_SP")*palaBreakinPosWeight+0.5*(1.0-palaBreakinPosWeight)
    }

    Glow { }

    PrevBlur { }

    Vignette { }

    Coords {}
    Tonemap {}

//    DrawRT {
//        textureRT: "prevNormal"
//    }


    SMAA {}

}
