import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene { 
  FlyCamera { id: flyCam }
  Defaults {}
  BgBall { }

  BgBlur { }

  ZoomPlane { name: "zoomPlane" }

  MirrorMesh { name: "mirrorBall" }

  BoxGrower { }

  Blit { textureRT: "depth"; blitRT: 1}
  PrevBlur {
      id: pb
      Connections {
          function clamp(v) {
              return Math.max(Math.min(v, 1.0), -1.0);
          }
          property real prevTi: 0.0
          target: demo; onFrameRendered: {
              var camAutoEnabled = sync("camera.autoMove.ON");
              var ti = demoTime();
              var deltaTime = (ti-prevTi);
              prevTi = ti;
              if (camAutoEnabled && deltaTime > 0.0) {
                  flyCam.camOfs.x += (-pb.getAvgPosX())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accX")), rocket.timeStepReal/16.67);
                  flyCam.camOfs.y += (-pb.getAvgPosY())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accY")), rocket.timeStepReal/16.67);
                  flyCam.camOfs.z += (-pb.getAvgPosZ())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accZ")), rocket.timeStepReal/16.67);
              }
              var k = Math.pow(0.95, rocket.timeStepReal/16.67);
              flyCam.camOfs.x *= k;
              flyCam.camOfs.y *= k;
              flyCam.camOfs.z *= k;

             // console.log("x:"+pb.getAvgPosX(), "y:"+pb.getAvgPosY(), "z:"+pb.getAvgPosZ());
          }
      }
  }

  Reflect { }
  Fog {
     textureBG: "bgBall"
  }

  // postprocs
  Coords { }
  Tonemap { }
  Glow { }
  Blit { textureRT: "prev" }
  Vignette { }
  SMAA {}
}
