import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {
    FlyCamera { id: flyCam }
    Group {
        //setup default textures
        TextureImage { textureUnit: 1; file: "../../images/_SK57414_normal.png"}
        TextureImage { textureUnit: 2; file: "../../images/area_lights.jpg"}
        Texture { textureUnit: 3; textureRT: "prev" }
        Texture { textureUnit: 4; textureRT: "prevBlur" }
        Texture { textureUnit: 5; textureRT: "prevNormal" }
    }

    // clear RGB & Z here so we are sure it happens at least once properly...
    DrawMesh {
        file: "mesh/tri.lwo"; Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; cD: 1.0; }
        Sca { s: 0.0; }
    }

    Group {
        id: mesh
        name: "mesh"
        enabled: sync(mesh.name+".ON")
        Shader { file: sceneDir+"smLay" }
        TextureSel { textureUnit: 0; name: parent.name }
        DrawMesh {
            file: meshSel(mesh.name)
            enabled: true; smoothNormals: true; normalSmoothAngle: 20;
            blendMode: blendSel(bgBall.name)
            depthTest: true; depthWrite: true;
            //  cull: true; cullBack: true
            Sca { s: sync(mesh.name+".scale"); x: 1.0; y: 1.0; z: 1.0 }
            Pos { x: 0.0; y: 0.0; z: 0.0}
            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: sync(mesh.name+".uvScale")}
            ShaderParam { paramName: "g_uvScaleY"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(mesh.name+".uvOfsY") }
            ShaderParam { paramName: "g_bump"; paramValue: 0.650}
            ShaderParam { paramName: "g_texBrightness"; paramValue: 1.0 }
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0 }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
            ShaderParam { paramName: "g_bright"; paramValue: sync(mesh.name+".bright")}
        }
    }

    Coords {}
    Tonemap {}
    SMAA {}

}
