#version 430


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;


in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];
in float bright[3];

out vec4 posG;
out vec3 normalG;
out vec3 normalWSG;
out vec2 uvG;
out vec3 tangentG;
out vec3 colorG;
out vec4 posW;
out float brightG;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;
uniform float g_triangleTexDim;

layout(binding=0) uniform sampler2D tex;

layout(binding=0, offset=0) uniform atomic_uint ac;


uniform float g_texW;
uniform float g_texH;
layout(binding=0, rgba32f) uniform image2D triangleInfo;
layout(binding=1, rgba32f) uniform image2D triangleIds;
layout(binding=2, r32i) uniform iimage2D edgeGridHeadPointers;
layout(binding=3, rgba32f) uniform image2D edgeDataCenter;
layout(binding=4, rgba32f) uniform image2D edgeDataIds;

uniform float g_hpTexBaseDim;

void main(void) {
    uint triangleId = gl_PrimitiveIDIn;
    uint texMod = uint(g_texW)/3;
    uint tidx = triangleId&(texMod-1);
    ivec2 c = ivec2(tidx*3, (triangleId-tidx)/texMod);
//    imageStore(triangleInfo, c, vec4(origPos[0].xyz, 1.0));
//    imageStore(triangleInfo, c+ivec2(1,0), vec4(origPos[1].xyz, 1.0));
//    imageStore(triangleInfo, c+ivec2(2,0), vec4(origPos[2].xyz, 1.0));

    for (int i=0; i<3; i++) {
        vec3 edgeCen;
        if (i==0) {
            edgeCen = (origPos[0].xyz+origPos[1].xyz)*0.5;
        } else if (i==1) {
            edgeCen = (origPos[1].xyz+origPos[2].xyz)*0.5;
        } else if (i==2) {
            edgeCen = (origPos[2].xyz+origPos[0].xyz)*0.5;
        }
      //  vec3 cell = (floor((edgeCen*2.0+vec3(0.5))*100.0));
        vec3 cell = (fract(edgeCen*100.0+vec3(0.0)));
        if (cell.x < 0.0) cell.x = 1.0-cell.x;
        if (cell.y < 0.0) cell.y = 1.0-cell.y;
        if (cell.z < 0.0) cell.z = 1.0-cell.z;
        float hpTexBaseDim2 = g_hpTexBaseDim*g_hpTexBaseDim;
        cell = floor(cell*hpTexBaseDim2);
        float cellzy = floor(cell.z/g_hpTexBaseDim);
        float cellzx = cell.z-cellzy*g_hpTexBaseDim;
        ivec2 cellUV = ivec2(cell.x+cellzx*hpTexBaseDim2, cell.y+cellzy*hpTexBaseDim2);
   //     imageStore(edgeGridHeadPointers, cellUV, vec4(edgeCen, 0.0));
        vec4 hp;
        uvec4 hpa = imageLoad(edgeGridHeadPointers, cellUV);
        hp.x = hpa.x;

        vec4 hpOrig = hp;
        bool matchFound = false;
        while (hp.x > 0.50) { // value exists
            uint counterHp = uint(round(hp.x+0.0));
            uint hpy = counterHp/(2*int(g_triangleTexDim));
            uint hpx = counterHp-uint(hpy*(2*int(g_triangleTexDim)));
            vec4 hpCen = imageLoad(edgeDataCenter, ivec2(hpx, hpy));
            vec4 hpIds = imageLoad(edgeDataIds, ivec2(hpx, hpy));

            float eps = 0.0001;
            vec3 delta = hpCen.xyz-edgeCen.xyz;
           if (dot(delta,delta)<eps && uint(round(hpIds.x)) != triangleId) {
           // if (true) {
                // match found!

//                uint tid = uint(floor(hpIds.x+0.0))*3;
//                uint tidy = tid/(3*int(g_triangleTexDim));
//                ivec2 tidUV = ivec2(tid*3-uint(tidy*3*int(g_triangleTexDim))+uint(hpIds.y), tidy);
//                imageStore(triangleIds, tidUV, vec4(triangleId, 0.0, 0.0, 0.0));

                uint tid = triangleId*3;
                uint tidy = tid/(3*int(g_triangleTexDim));
                ivec2 tidUV = ivec2(tid-uint(tidy*3*int(g_triangleTexDim))+i, tidy);
                imageStore(triangleIds, tidUV, vec4(hpIds.x, 0.0, 0.0, 0.0));

             //   matchFound = true;
            //    break;
            }

            hp.x = hpIds.z;
        }
//        if (matchFound) {
//            continue;
//        }

  //      hpOrig = hp;

//        uint counter = atomicCounterIncrement(ac);

//        vec3 dids = vec3(triangleId, i, hp.x+0.2);

//        uint cy = counter/2048;
//        uint cx = counter-uint(cy*2048);
//        ivec2 dataUV = ivec2(cx, cy);
//        imageStore(edgeDataCenter, dataUV, vec4(edgeCen, 0.0));
//        imageStore(edgeDataIds, dataUV, vec4(dids, 0.0));
//        imageStore(edgeGridHeadPointers, cellUV, vec4(float(counter)+1.0+0.0, 0.0, 0.0, 0.0));
    }
}
