import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: vignette
    name: "vignette"
    effectName: "Vignette"
    enabled: sync(vignette.name+".ON")

    property real posX: 0.0
    property real posY: 0.0

    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
        textureWrap: "clamp"
    }
    Shader {
        file: (sync(vignette.name+".realSpectrum") > 0.5) ? "vignetteReal" : "vignette"
        ShaderParam {
            paramName: "g_vignette"
            paramValue: sync(vignette.name+".strength")
        }

        ShaderParam {
            paramName: "g_vignetteRealSpecSpacing"
            paramValue: sync(vignette.name+".realSpecSpacing")+1.0
        }
        ShaderParam {
            paramName: "g_radius"
            paramValue: sync(vignette.name+".radius")
        }
        ShaderParam {
            paramName: "g_distortRadius"
            paramValue: sync(vignette.name+".distortRadius")
        }
        ShaderParam {
            paramName: "g_noise"
            paramValue: sync(vignette.name+".noise")
        }
        ShaderParam {
            paramName: "g_posX"
            paramValue: sync(vignette.name+".posX")+vignette.posX
        }
        ShaderParam {
            paramName: "g_posY"
            paramValue: sync(vignette.name+".posY")+vignette.posY
        }
        ShaderParam {
            paramName: "g_aspect"
            paramValue: sync(vignette.name+".aspect")
        }
        ShaderParam {
            paramName: "g_scale"
            paramValue: sync(vignette.name+".scale")
        }

        ShaderParam {
            paramName: "g_edgeChroma"
            paramValue: syncOsc(vignette.name+".chroma")
        }
        ShaderParam {
            paramName: "g_edgeChromaHueFreq"
            paramValue: sync(vignette.name+".chroma.hueFreq")
        }
        ShaderParam {
            paramName: "g_edgeChromaHueOfs"
            paramValue: sync(vignette.name+".chroma.hueOfs")
        }
        ShaderParam {
            paramName: "g_specWeight"
            paramValue: sync(vignette.name+".chroma.specWeight")
        }
        ShaderParam {
            paramName: "g_origWeight"
            paramValue: sync(vignette.name+".chroma.origWeight")
        }

        ShaderParam {
            paramName: "g_edgeChromaClearRadius"
            paramValue: sync(vignette.name+".chroma.clearRad")
        }

        ShaderParam {
            paramName: "g_edgeChromaDistortX"
            paramValue: sync(vignette.name+".chroma.distX")
        }
        ShaderParam {
            paramName: "g_edgeChromaDistortY"
            paramValue: sync(vignette.name+".chroma.distY")
        }
        ShaderParam {
            paramName: "g_edgeChromaDistortOfsX"
            paramValue: sync(vignette.name+".chroma.distOfsX")
        }
        ShaderParam {
            paramName: "g_edgeChromaDistortOfsY"
            paramValue: sync(vignette.name+".chroma.distOfsY")
        }
        ShaderParam {
            paramName: "g_edgeChromaDistortFreqX"
            paramValue: sync(vignette.name+".chroma.distFreqX")
        }
        ShaderParam {
            paramName: "g_edgeChromaDistortFreqY"
            paramValue: sync(vignette.name+".chroma.distFreqY")
        }
        ShaderParam {
            paramName: "g_fadeOut"
            paramValue: sync(vignette.name+".fadeOut")
        }
    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
    }
}
