import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: box
    name: "text"
    effectName: "text"

    // public params
    property string text
    property string meshFilePrefix: "mesh/font/porscha_"
    property string meshFilePostfix: ".lwo"

    property int triggeredRender: 0

    enabled: sync(box.name+".ON");

    Shader { file: "smText" }
    TextureSel { name: box.name }
    TextureImage { textureUnit: 1; file: "../../images/repismap2048.png"}

    function getTextMeshName(asciiCode) {
        var kbString = (asciiCode<100) ? "0"+asciiCode.toString() : asciiCode.toString();
        return meshFilePrefix+kbString+meshFilePostfix;
    }

    property real movePerChar: sync(box.name+".movePerChar")

    property real taxz: sync(box.name+".textAngXZ")
    property real taxy: sync(box.name+".textAngXY")

    property real textAngXZ: taxz/360.0*(2.0*Math.PI)
    property real textAngXY: taxy/360.0*(2.0*Math.PI)

//    r.x = cos(a)*p.x - sin(a)*p.y;
//    r.y = sin(a)*p.x + cos(a)*p.y;
    property real tdx: Math.cos(textAngXY)
    property real tdy: Math.sin(textAngXY)


    property real textDirX: tdx*Math.cos(textAngXZ)
    property real textDirY: tdy
    property real textDirZ: tdx*Math.sin(textAngXZ)

    property int numChars: box.enabled ? text.length : 0

    Repeater {
        model: numChars
        delegate: DrawMesh {
            file: getTextMeshName(text.charCodeAt(index))
            enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "off"; depthTest: true; depthWrite: true;
            Pos { x: sync(box.name+".x")+index*movePerChar*textDirX; y: sync(box.name+".y")+index*movePerChar*textDirY; z: sync(box.name+".z")+index*movePerChar*textDirZ}
            autoCenter: false
            autoScale: false
            Rot { d: sync(box.name+".rotY")-taxz; ax: 0.0; ay: 1.0; az: 0.0 }
            Rot { d: sync(box.name+".rotZ")+taxy; ax: 0.0; ay: 0.0; az: 1.0 }
            Rot { d: sync(box.name+".rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
            Pos { x: sync(box.name+".prX"); y: sync(box.name+".prY"); z: sync(box.name+".prZ")}
            Sca { s: sync(box.name+".scale"); x: sync(box.name+".scaX"); y: sync(box.name+".scaY"); z: sync(box.name+".scaZ") }
            ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
            ShaderParam { paramName: "g_bump"; paramValue: 0.50}
            ShaderParam { paramName: "g_texBrightness"; paramValue: syncFFT(box.name+".bright") }
            ShaderParam { paramName: "g_uvOfsX"; paramValue: syncOsc(box.name+".uvOfsX") }
            ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(box.name+".uvOfsY") }
            ShaderParam { paramName: "g_uvScale"; paramValue: sync(box.name+".uvScale") }
            ShaderParam { paramName: "g_alpha"; paramValue: sync(box.name+".alpha") }
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.00 }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount")*sync(box.name+".prevBlurAmount") }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
            ShaderParam { paramName: "g_bright"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvScaleVoro"; paramValue: sync(box.name+".voroUvScale")}
            ShaderParam { paramName: "g_uvScaleYVoro"; paramValue: sync(box.name+".voroUvScaleY")}
            ShaderParam { paramName: "g_voroUvOfsX"; paramValue: sync(box.name+".voroUvOfsX")}
            ShaderParam { paramName: "g_voroUvOfsY"; paramValue: sync(box.name+".voroUvOfsY")}
            ShaderParam { paramName: "g_voroLift"; paramValue: sync(box.name+".voroLift")}
            ShaderParam { paramName: "g_distToZW"; paramValue: sync(box.name+".voroDistToZW")}
            ShaderParam { paramName: "g_distToZPow"; paramValue: sync(box.name+".voroDistToZPow")}
            ShaderParam { paramName: "g_voroDispYM"; paramValue: sync(box.name+".voroDispYM")}
            ShaderParam { paramName: "g_voroDispYOfs"; paramValue: sync(box.name+".voroDispYOfs")}
            ShaderParam { paramName: "g_genUV"; paramValue: sync(box.name+".genUVs")}

            ShaderParam { paramName: "g_emitThr"; paramValue: sync(box.name+".palaEmitThr", 0.0) }
            ShaderParam { paramName: "g_emitAmp"; paramValue: syncFFT(box.name+".palaEmitAmp", 1.0) }

            ShaderParam { paramName: "g_emitPercent"; paramValue: sync(box.name+".emitPercent", 10.0) }
            ShaderParam { paramName: "g_emitVelX"; paramValue: sync(box.name+".emitVel.x") }
            ShaderParam { paramName: "g_emitVelY"; paramValue: sync(box.name+".emitVel.y") }
            ShaderParam { paramName: "g_emitVelZ"; paramValue: sync(box.name+".emitVel.z") }
            ShaderParam { paramName: "g_emitColorThr"; paramValue: sync(box.name+".emitColThr") }



            triggeredRender: box.triggeredRender;
        }
    }
}
