import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
  // space vortex plane
  id: spaceVortex
  enabled: sync(spaceVortex.name+".ON");
  VariClock { id: vortexZoomTime; clockSpeed: sync(spaceVortex.name+".zoomSpeed")}
  property int maxParticles: 1000000
  property int maxSimParticles: 1000000
//  property string textureVortexPlane: "../../images/palette_shot8.png"
//  property string textureAgeSwipe: "../../images/palette_shot8.png"
//  property string textureDraw: "../../images/palette_shot8.png"



  property string blendMode: "add"
  property string simShader: "simVortex"
  property string drawShader: "partVortex"
  property string file: "mesh/box1m.lwo"
  property alias meshParams: spaceMeshParams.delegate
  property alias mesh2Params: spaceMesh2Params.delegate

  property bool depthTest: false

  VariClock {
      id: vortexRotTime
      clockSpeed: sync(spaceVortex.name+".rotSpeed")
      reset: sync(spaceVortex.name+".reset")
      resetTime: sync(spaceVortex.name+".resetTime")
  }
  RenderTarget {
      RenderTargetLayer {
          textureRT: spaceVortex.name+"emitVortexPartPos"
          format: "RGBA16F"
          width: windowWidth*1
          height: windowHeight*1
      }
  }
  RenderTarget {
      RenderTargetLayer {
          textureRT: spaceVortex.name+"emitVortexPartVel"
          format: "RGBA16F"
          width: windowWidth*1
          height: windowHeight*1
      }
  }
  RenderTarget {
      RenderTargetLayer {
          textureRT: spaceVortex.name+"emitVortexPartCol"
          format: "RGBA16F"
          width: windowWidth*1
          height: windowHeight*1
      }
  }
  ShaderAtomicCounter { name: spaceVortex.name+"sacVortex1"; clear: true }
  Texture { textureUnit: 0; imageUnit: 0; textureRT: spaceVortex.name+"emitVortexPartPos" }
  Texture { textureUnit: 1; imageUnit: 1; textureRT: spaceVortex.name+"emitVortexPartVel" }
  Texture { textureUnit: 2; imageUnit: 2; textureRT: spaceVortex.name+"emitVortexPartCol" }

  Shader { file: sceneDir+"smVortex" }

  // the vortex plane emit color texture
  //TextureImage { textureUnit: 0; file: "../../images/partik.png"}
  //TextureImage { textureUnit: 0; file: "../../images/rocks.png"}
 // TextureImage { textureUnit: 0; file: textureVortexPlane}
  TextureSel { textureUnit: 0; name: spaceVortex.name+".plane"; }
  //TextureImage { textureUnit: 0; file: "../../images/iteata3.png"}
  //TextureImage { textureUnit: 0; file: "../../images/meteor.png"}
 // TextureImage { textureUnit: 0; file: "../../images/scratch1.png"}

  DrawMesh {
    file: spaceVortex.file; enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "normal"; depthTest: spaceVortex.depthTest; depthWrite: false; cull: false; cullBack: false;
	
    ShaderParam { paramName: "g_uvScale"; paramValue: 1.8350}
    ShaderParam { paramName: "g_texBrightness"; paramValue: sync(spaceVortex.name+".emitBright1")*0.01}
    ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0}
    ShaderParam { paramName: "g_bump"; paramValue: 1.50}
    ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
    ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount")}
    ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.10, 1.0"}
    ShaderParam { paramName: "g_bright"; paramValue: 1.0}
    ShaderParam { paramName: "g_zoomTime"; paramValue: vortexZoomTime.time }
    ShaderParam { paramName: "g_vortexRot"; paramValue: vortexRotTime.time }
    ShaderParam { paramName: "g_vortexRotOfs"; paramValue: sync(spaceVortex.name+".rotOfs1") }
    ShaderParam { paramName: "g_vortexScale"; paramValue: sync(spaceVortex.name+".scale1") }
    ShaderParam { paramName: "g_vortexAngSpeed"; paramValue: sync(spaceVortex.name+".angSpd1") }
    ShaderParam { paramName: "g_emitPercent"; paramValue: sync(spaceVortex.name+".emitPercent") }
    ShaderParam { paramName: "g_emitVelX"; paramValue: sync(spaceVortex.name+".emitVel.x") }
    ShaderParam { paramName: "g_emitVelY"; paramValue: sync(spaceVortex.name+".emitVel.y") }
    ShaderParam { paramName: "g_emitVelZ"; paramValue: sync(spaceVortex.name+".emitVel.z") }
    ShaderParam { paramName: "g_emitAmp"; paramValue: sync(spaceVortex.name+".emitAmp") }
    ShaderParam { paramName: "g_emitColorThr"; paramValue: sync(spaceVortex.name+".emitColThr") }
    ShaderParam { paramName: "g_alpha"; paramValue: sync(spaceVortex.name+".alpha") }
    Repeater { id: spaceMeshParams; model: 1 }
    drawBuffers: 1
  }
  DrawMesh {
    file: spaceVortex.file; enabled: false; smoothNormals: true; normalSmoothAngle: 20; blendMode: "add"; depthTest: spaceVortex.depthTest; depthWrite: false; cull: false; cullBack: false;
    ShaderParam { paramName: "g_uvScale"; paramValue: 1.29780}
    ShaderParam { paramName: "g_texBrightness"; paramValue: sync(spaceVortex.name+".emitBright2")*0.01}
    ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0}
    ShaderParam { paramName: "g_bump"; paramValue: 1.50}
    ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
    ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount")}
    ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.10, 1.0"}
    ShaderParam { paramName: "g_bright"; paramValue: 1.0}
    ShaderParam { paramName: "g_zoomTime"; paramValue: vortexZoomTime.time }
    ShaderParam { paramName: "g_vortexRot"; paramValue: vortexRotTime.time }
    ShaderParam { paramName: "g_vortexRotOfs"; paramValue: sync(spaceVortex.name+".rotOfs2") }
    ShaderParam { paramName: "g_vortexScale"; paramValue: sync(spaceVortex.name+".scale2") }
    ShaderParam { paramName: "g_vortexAngSpeed"; paramValue: sync(spaceVortex.name+".angSpd2") }
    ShaderParam { paramName: "g_emitPercent"; paramValue: sync(spaceVortex.name+".emitPercent2") }
    ShaderParam { paramName: "g_emitVelX"; paramValue: sync(spaceVortex.name+".emitVel2.x") }
    ShaderParam { paramName: "g_emitVelY"; paramValue: sync(spaceVortex.name+".emitVel2.y") }
    ShaderParam { paramName: "g_emitVelZ"; paramValue: sync(spaceVortex.name+".emitVel2.z") }
    ShaderParam { paramName: "g_emitAmp"; paramValue: sync(spaceVortex.name+".emitAmp2") }
    ShaderParam { paramName: "g_emitColorThr"; paramValue: sync(spaceVortex.name+".emitColThr2") }
    ShaderParam { paramName: "g_alpha"; paramValue: sync(spaceVortex.name+".alpha") }
    Repeater { id: spaceMesh2Params; model: 1 }
    drawBuffers: 1
  }

//  Blit { textureRT: "depth"; blitRT: 1}

  // vortex partikles
  ShaderAtomicCounter { name: spaceVortex.name+"sacVortex1" }
  Texture { textureUnit: 0; imageUnit: 0; textureRT: spaceVortex.name+"emitVortexPartPos" }
  Texture { textureUnit: 1; imageUnit: 1; textureRT: spaceVortex.name+"emitVortexPartVel" }
  Texture { textureUnit: 2; imageUnit: 2; textureRT: spaceVortex.name+"emitVortexPartCol" }
  PartSim {
      id: vortexSim
      name: "vortexParticles"
      forceName: "vortexForce"


      simShader: spaceVortex.simShader

      simShaderParams: ParamGroup {
          ShaderParam { paramName: "g_partDiscardBright"; paramValue: sync(vortexSim.name+".discardBright") }
          ShaderParam { paramName: "g_maxSimParticles"; paramValue: spaceVortex.maxSimParticles }
      }

      drawShader: spaceVortex.drawShader
      drawShaderParams: ParamGroup {
          ShaderParam { paramName: "g_partBright"; paramValue: sync(vortexSim.name+".partBright") }
          ShaderParam { paramName: "g_partAlpha"; paramValue: sync(vortexSim.name+".partAlpha") }
          ShaderParam { paramName: "g_useTexture"; paramValue: sync(vortexSim.name+".useTexture") }
      }

      drawEnabled: spaceVortex.enabled
    //  drawDepthEnabled: false
      drawBlendMode: spaceVortex.blendMode

//      texture0: textureDraw
//      texture2: textureAgeSwipe

      tex0: TextureSel { textureUnit: 0; name: spaceVortex.name }
      tex2: TextureSel { textureUnit: 2; name: spaceVortex.name }

      shaderVaryings: "
              vec3 posG;
              vec2 uvG;
              vec3 velG;
              vec3 colG;
              float ageG;
              float recG;
              float ageSplitG;
              vec4 posInitG;"
             // vec3 posScrG;"


      // max particles count is gridDimension*gridDimension
      // CHANGE PROPOSAL: make a new parameter maxPoints instead...
      gridDimension: Math.sqrt(maxParticles)

      // This is actually the number of points drawn for the first frame
      // of the simulation (or when reset).
      // As after that, the simulation will continue with own number of particles
      // as some particles might die and others might emit new ones...
      // CHANGE PROPOSAL: because of the above explanation, change this variable name to
      // initNumPoints instead ...
      drawNumPoints: sync(spaceVortex.name+".numParticles")

      partSize: sync(spaceVortex.name+".partSize")
  }

  // leave this atomic counter active so some other effects shaders do not modify this by accident.....
  ShaderAtomicCounter { name: "none"; clear: true }


}
