import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

Group {
    id: partSim
    name: "partSim"
    property string forceName: "partSim"
    property string simShader: "simPart"
    property alias simShaderParams: simPar.delegate
    property string drawShader: "partWater"
    property alias drawShaderParams: drawPar.delegate
    property string drawBlendMode: "add"
    property int gridDimension: 600
    property int drawNumPoints: 100*100
    property bool drawEnabled: true
    property bool drawDepthEnabled: sync(partSim.name+".draw.depthEnabled", 1.0) > 0.5

    property real partSize: 0.50
    property int particleCount: advanceSim.particleCount

    onParticleCountChanged: {
        root.setCustomText(name, name+": particle count", "Particle count:"+particleCount);
    }

    signal particleCountTo(int pc)

    Blit { textureRT: "screenBuffer" }

    property alias tex0: t0.delegate
    Repeater { id: t0; model: 1 }
    Texture {
        textureUnit: 1
        textureItem: particleNoise
        Image {
            id: particleNoise
            visible: false
            source: "../../images/random16.png"
        }
    }

    property alias tex2: t2.delegate
    Repeater { id: t2; model: 1 }

    Texture { textureUnit: 3; textureRT: "depth" } // world space normal in rgb components
    Texture { textureUnit: 4; textureRT: "mainDepth" }
    Texture { textureUnit: 5; textureRT: "prevBlur" }

    // --------------------------------------
    // ADVANCE PARTICLE SIMULATIONS
    // --------------------------------------

    property string shaderVaryings: "
        vec3 posG;
        vec2 uvG;
        vec3 velG;
        float ageG;
        float recG;
        float ageSplitG;"

    Shader {
        file: simShader
        tfVaryings: shaderVaryings
    }

    VariClockTrigger {
        id: simNoiseMoveX
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.x")
        reset: syncTrigger(spaceVortex.name+".sim.reset")
    }
    VariClockTrigger {
        id: simNoiseMoveY
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.y")
        reset: syncTrigger(spaceVortex.name+".sim.reset")
    }
    VariClockTrigger {
        id: simNoiseMoveZ
        clockSpeed: sync(spaceVortex.name+".simNoiseMove.z")
        reset: syncTrigger(spaceVortex.name+".sim.reset")
    }


    DrawVB {
        id: advanceSim
        enabled: true
        type: "pointGrid"
        vboId: sceneName+partSim.name

        property real resetOn: syncTrigger(partSim.name+".sim.reset")

        onResetOnChanged: {
            if (resetOn > 0.5) {
                reset = 1.0;
                resetParticles();
            } else {
                reset = 0.0;
            }
        }

        onParticleCountChanged: {
            particleCountTo(particleCount);
        }

        tfVaryings: shaderVaryings

        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        depthTest: false; depthWrite: false

        ShaderParam { paramName: "g_gridDim"; paramValue: partSim.gridDimension }
        ShaderParam { paramName: "g_velDamping"; paramValue: sync(partSim.name+".sim.velDamping", 1.0) }
        property real noiseScaleAll: sync(partSim.forceName+".simNoiseScale.all", 1.0);
        property real nsx: noiseScaleAll*sync(partSim.forceName+".simNoiseScale.x")
        property real nsy: noiseScaleAll*sync(partSim.forceName+".simNoiseScale.y")
        property real nsz: noiseScaleAll*sync(partSim.forceName+".simNoiseScale.z")

        ShaderParam { paramName: "g_noiseScale"; paramValueVec4: parent.nsx+","+parent.nsy+","+parent.nsz }
        ShaderParam { paramName: "g_noiseMove"; paramValueVec4: simNoiseMoveX.time+","+simNoiseMoveY.time+","+simNoiseMoveZ.time }
        ShaderParam { paramName: "g_noiseOfs"; paramValueVec4: sync(partSim.name+".simDirForce.x")+","+sync(partSim.name+".simDirForce.y")+","+syncFFT(partSim.name+".simDirForce.z") }
        ShaderParam { paramName: "g_force"; paramValue: sync(partSim.forceName+".sim.force", 2.0) }
        ShaderParam { paramName: "g_noiseFreq"; paramValue: sync(partSim.forceName+".sim.noiseFreq", 1.0) }
        ShaderParam { paramName: "g_speed"; paramValue: sync(partSim.forceName+".sim.speed", 1.0) }
        ShaderParam { paramName: "g_maxAge"; paramValue: sync(partSim.name+".sim.maxAge", 10.0) }
        ShaderParam { paramName: "g_elasticity"; paramValue: sync(partSim.name+".sim.elasticity", 0.5) }
        ShaderParam { paramName: "g_splitThr"; paramValue: sync(partSim.name+".sim.splitThr", 0.0) }
        ShaderParam { paramName: "g_splitAmpRand"; paramValue: sync(partSim.name+".sim.splitAmpRand", 1.0) }
        ShaderParam { paramName: "g_splitAmpNorm"; paramValue: sync(partSim.name+".sim.splitAmpNorm", 1.0) }
        ShaderParam { paramName: "g_noiseSpeed"; paramValue: sync(partSim.name+".sim.noiseSpeed", 1.0) }
        ShaderParam { paramName: "g_noiseRec"; paramValue: sync(partSim.name+".sim.noiseRec", 0.0) }

        // inject custom shader params
        Repeater { id: simPar; model: 1 }
    }

    // --------------------------------------
    // RENDER PARTICLES
    // --------------------------------------
    Shader {
        file: drawShader
    }
    DrawVB {
        enabled: drawEnabled
        type: "pointGridDraw"
        name: partSim.name
        vboId: sceneName+partSim.name
        depthTest: true
        depthWrite: false

        // blendMode: "normal"
        blendMode: drawBlendMode
        // blendMode: "off"

        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints

        ShaderParam { paramName: "g_partSize"; paramValue: partSize }
        ShaderParam { paramName: "g_maxAge"; paramValue: sync(partSim.name+".sim.maxAge") }
        ShaderParam { paramName: "g_scale"; paramValue: sync(partSim.name+".draw.globalScale", 1.0) }

        ShaderParam { paramName: "g_palaEmit"; paramValue: sync(partSim.name+".draw.palaEmit", 0.0) }
        ShaderParam { paramName: "g_palaEmitThr"; paramValue: sync(partSim.name+".draw.palaEmitThr", 0.0) }

        // inject custom shader params
        Repeater { id: drawPar; model: 1 }

        drawBuffers: 3
    }

//    Shader {
//        file: sceneDir+"partDepthOnly"
//    }
    DrawVB { // depth only draw
        enabled: drawDepthEnabled
        type: "pointGridDraw"
        name: partSim.name
        vboId: sceneName+partSim.name
        depthTest: true
        depthWrite: true

        // blendMode: "normal"
        blendMode: "add"
        // blendMode: "off"
        tfVaryings: shaderVaryings
        gridWidth: partSim.gridDimension
        gridHeight: partSim.gridDimension
        drawNumPoints: partSim.drawNumPoints
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }
        drawBuffers: 1
    }
}
