import QtQuick 2.3
import AdaptDemoSystem 1.0

import "../."

Group {
    id: loadAssets
    name: "loadAssets"

    property int frameIndex: 0
    Connections {
        target: demo; onFrameRendered: { frameIndex++ }
    }


    // auto browse all TextureSel images
    TextureSel { id: texSel; }
    Repeater {
        model: texSel.texCount0
        delegate: TextureSel { texInd: index }
    }
    Repeater {
        model: texSel.texCount1
        delegate: TextureSel { texInd: index+1000 }
    }
    Repeater {
        model: texSel.texCount2
        delegate: TextureSel { texInd: index+2000 }
    }
    Repeater {
        model: texSel.texCount3
        delegate: TextureSel { texInd: index+3000 }
    }
    Repeater {
        model: texSel.texCount4
        delegate: TextureSel { texInd: index+4000 }
    }

    // auto browse all MeshSel models
    // todo

    MeshList { id: meshList }

    Repeater {
        id: meshLoader
        enabled: frameIndex < 2
        visible: enabled
        model: meshList.content0.length
        delegate: DrawMesh {
            enabled: meshLoader.enabled
            file: meshList.content0[index]
        }
    }


    // manual list of textures if 100% confirmation is wanted...
    TextureImage { file: "../../images/bokeh_housus.png" }

}

