import QtQuick 2.4

Group {
    id: box
    name: "griizster"
    enabled: sync(box.name+".ON")


    Shader { file: "smGriizter" }
    DrawMesh {
        property string name: box.name
        file: meshSel(box.name)
        depthTest: sync(box.name+".depthEnabled", 1.0) > 0.5
        depthWrite: depthTest
        blendMode: blendSel(box.name)
        tfVaryings: shaderVaryings

        smoothNormals: true; normalSmoothAngle: 60;

        Pos { x: sync(box.name+".posX"); y: sync(box.name+".posY"); z: sync(box.name+".posZ")}
        Rot { d: sync(box.name+".rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync(box.name+".rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sync(box.name+".rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync(box.name+".scale"); x: sync(box.name+".scaX"); y: sync(box.name+".scaY"); z: sync(box.name+".scaZ") }

        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(box.name+".bright", 1.0) }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync(box.name+".ambient", 0.1) }
        ShaderParam { paramName: "g_uvScale"; paramValue: sync(box.name+".uvScale", 1.0) }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(box.name+".prevBlur", 0.5) }
        ShaderParam { paramName: "g_prevBlurType"; paramValue: sync(box.name+".prevBlurType") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(box.name+".bump", 0.25) }
        ShaderParam { paramName: "g_genUV"; paramValue: sync(box.name+".genUV", 1.0) }
        ShaderParam { paramName: "g_alpha"; paramValue: sync(box.name+".alpha", 1.0) }

        ShaderParam { paramName: "g_emitThr"; paramValue: sync(box.name+".emitThr", 0.0) }
        ShaderParam { paramName: "g_emitAmp"; paramValue: syncFFT(box.name+".emitAmp", 1.0) }

//        SavePoint {
//            target: meshInst.name+"_SP"
//            x: meshInst.posX+sync(meshInst.name+".spx")/meshInst.sca; y: meshInst.posY/meshInst.sca+sync(meshInst.name+".spy"); z: meshInst.posZ/(meshInst.sca*meshInst.scaZ)+sync(meshInst.name+".spz");
//        }

    }

}
