import QtQuick 2.2
import QtQuick.Window 2.2

import AdaptDemoSystem 1.0

import "./_SharedQML"

Scene {
    id: scene
    property string name: "skene"
    property string sceneName: ""
    property string sceneDir: "fx\\"+sceneName+"\\"
    property bool bSceneEnabled: sync("ON")

    onSetSceneName: {
        sceneName = sn;
        name = sn;
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT0"
            format: "RGBA32F"
            width: 1024
            height: 1
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT1"
            format: "RGBA32F"
            width: 1024
            height: 1
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT2"
            format: "RGBA32F"
            width: 1024
            height: 1
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT3"
            format: "RGBA32F"
            width: 1024
            height: 1
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }



    FFT {
        id: fft1
        areaWidth: sync("_fft1.width")*0.5
        freq: sync("_fft1.freq")
        smooth: Math.pow(0.5, 1.0/(sync("_fft1.split")*60.0))
        smoothAttack: Math.pow(0.5, 1.0/(sync("_fft1.splitAttack")*60.0))
        targetTexRT: "texFFT0"
        targetSmoothTexRT: "texFFT1"
    }
    FFT {
        id: fft2
        areaWidth: sync("_fft2.width")*0.5
        freq: sync("_fft2.freq")
        smooth: Math.pow(0.5, 1.0/(sync("_fft2.split")*60.0))
        smoothAttack: Math.pow(0.5, 1.0/(sync("_fft2.splitAttack")*60.0))
        targetSmoothTexRT: "texFFT2"
    }
    FFT {
        id: fft3
        areaWidth: sync("_fft3.width")*0.5
        freq: sync("_fft3.freq")
        smooth: Math.pow(0.5, 1.0/(sync("_fft3.split")*60.0))
        smoothAttack: Math.pow(0.5, 1.0/(sync("_fft3.splitAttack")*60.0))
        targetSmoothTexRT: "texFFT3"
    }


    property int frameInd: 0
    Connections {
        target: demo; onFrameRendered: {
            frameInd++;
        }
    }

    property int fftDelayHeight: 512

    // FFT0 (RAW)
    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT0Delay"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
            Clear {
                enabled: frameInd < 4
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT0Delay2"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
            Clear {
                enabled: frameInd < 4
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: ((frameInd&1)===0) ? "texFFT0Delay2" : "texFFT0Delay"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
        }
        Shader { file: "fftDelay" }
        Texture { textureUnit: 0; textureRT: "texFFT0" } // 1024x1 source
        Texture { textureUnit: 1; textureRT: ((frameInd&1)===0) ? "texFFT0Delay" : "texFFT0Delay2" }
        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            blendMode: "off"
            drawBuffers: 1
            ShaderParam { paramName: "flip"; paramValue: 0.0 }
            ShaderParam { paramName: "delayHeight"; paramValue: fftDelayHeight }
        }
    }

    //FFT1
    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT1Delay"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
            Clear {
                enabled: frameInd < 4
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT1Delay2"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
            Clear {
                enabled: frameInd < 4
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: ((frameInd&1)===0) ? "texFFT1Delay2" : "texFFT1Delay"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
        }
        Shader { file: "fftDelay" }
        Texture { textureUnit: 0; textureRT: "texFFT1" } // 1024x1 source
        Texture { textureUnit: 1; textureRT: ((frameInd&1)===0) ? "texFFT1Delay" : "texFFT1Delay2" }
        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            blendMode: "off"
            drawBuffers: 1
            ShaderParam { paramName: "flip"; paramValue: 0.0 }
        }
    }

    // FFT2
    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT2Delay"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
            Clear {
                enabled: frameInd < 4
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT2Delay2"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
            Clear {
                enabled: frameInd < 4
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: ((frameInd&1)===0) ? "texFFT2Delay2" : "texFFT2Delay"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
        }
        Shader { file: "fftDelay" }
        Texture { textureUnit: 0; textureRT: "texFFT2" } // 1024x1 source
        Texture { textureUnit: 1; textureRT: ((frameInd&1)===0) ? "texFFT2Delay" : "texFFT2Delay2" }
        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            blendMode: "off"
            drawBuffers: 1
            ShaderParam { paramName: "flip"; paramValue: 0.0 }
        }
    }

    // FFT3
    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT3Delay"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
            Clear {
                enabled: frameInd < 4
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "texFFT3Delay2"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
            Clear {
                enabled: frameInd < 4
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: ((frameInd&1)===0) ? "texFFT3Delay2" : "texFFT3Delay"
            format: "RGBA32F"
            width: 1024
            height: fftDelayHeight
        }
        Shader { file: "fftDelay" }
        Texture { textureUnit: 0; textureRT: "texFFT3" } // 1024x1 source
        Texture { textureUnit: 1; textureRT: ((frameInd&1)===0) ? "texFFT3Delay" : "texFFT3Delay2" }
        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            blendMode: "off"
            drawBuffers: 1
            ShaderParam { paramName: "flip"; paramValue: 0.0 }
        }
    }

    function getFFTDelayTex(ind) {
        if (ind===0) {
            return ((frameInd&1)===0) ? "texFFT0Delay2" : "texFFT0Delay"
        }
        if (ind===1) {
            return ((frameInd&1)===0) ? "texFFT1Delay2" : "texFFT1Delay"
        }
        if (ind===2) {
            return ((frameInd&1)===0) ? "texFFT2Delay2" : "texFFT2Delay"
        }
        if (ind===3) {
            return ((frameInd&1)===0) ? "texFFT3Delay2" : "texFFT3Delay"
        }

    }


//    Shader { file: "drawRt" }



    function getFft(ind) {
        if (ind < 0.999) {
            return 0.0;
        }
        if (ind < 1.999) {
            return fft1.value;
        }
        if (ind < 2.999) {
            return fft2.value;
        }
        if (ind < 3.999) {
            return fft3.value;
        }
    }

    function hasFft(ind) {
        if (ind < 0.999) {
            return false;
        }
        return true;
    }

    property real rocket_bpm: 88.0


    Component {
        id: localOscComp
        OscClock {
            reset: (name !== "") ? syncTrigger(name+".reset")+fftReset : 0.0
            clockSpeed: (name !== "") ? (sync(name+".freq")+fftToFreq*fftValue)*60.0/rocket_bpm : 0.0
            resetTime: (name !== "") ? sync(name+".reset") : 0.0

            property real fftReset: 0.0
            property bool evalHasFft: (name !== "") ? hasFft(sync(name+"_fft")) : false
            property real fftValue: (name !== "") ? getFft(sync(name+"_fft")) : 0.0
            property real fftThr: ((name !== "") && evalHasFft) ? sync(name+"_fft.resetThr") : 0.0
            property real fftGain: ((name !== "") && evalHasFft) ? sync(name+"_fft.resetGain") : 0.0
            property real fftToFreq: ((name !== "") && evalHasFft) ? sync(name+"_fft.FM") : 0.0

            property real valueScale: 1.0
            property real valueAccu: 0.0
            property real accu: 0.0

            property real resetAccu: (name !== "") ? syncTrigger(name+".resetAccu") : 0.0
            onResetAccuChanged: {
                accu = resetAccu;
            }

            onResetDone: {
              //  console.log("osc:"+name, "osc reset, valueAccu:"+valueAccu, "accu:"+accu)
                accu += valueAccu;
                valueAccu = 0.0;
            }

            onFftValueChanged: {
                if ((fftValue > fftThr) && (time >= 1.0) && (fftThr>0.01)) {
                    fftReset += 1.0;
                    valueScale = fftValue*fftGain+1.0;
                }
            }
        }
    }

    Component {
        id: localFftComp
        FFT {
            areaWidth: (name !== "") ? sync(name+".width")*0.5 : 0.0
            freq: (name !== "") ? sync(name+".freq") : 0.0
            smooth: (name !== "") ? Math.pow(0.5, 1.0/(sync(name+".split")*60.0)) : 0.0
            smoothAttack: Math.pow(0.5, 1.0/(sync(name+".splitAttack")*60.0))
        }
    }

    Component {
        id: localNoiseComp
        NoiseGenerator {
            id: ngen
            freq: (name !== "") ? (sync(ngen.name+".freq")+ngen.fftToFreq*ngen.fftValue)*60.0/rocket_bpm : 0.0
            seed: (name !== "") ? syncTrigger(name+".reset") : 0.0
            interpolation: (name !== "") ? sync(name+".interpolation") : 0.0

            property real fftReset: 0.0
            property bool evalHasFft: (name !== "") ? hasFft(sync(name+"_fft")) : false
            property real fftValue: (name !== "") ? getFft(sync(name+"_fft")) : 0.0
            property real fftThr: ((name !== "") && evalHasFft) ? sync(name+"_fft.resetThr") : 0.0
            property real fftGain: ((name !== "") && evalHasFft) ? sync(name+"_fft.resetGain") : 0.0
            property real fftToFreq: ((name !== "") && evalHasFft) ? sync(name+"_fft.FM") : 0.0

            property real time: clock.time
            OscClock {
                id: clock
                reset: (ngen.name !== "") ? syncTrigger(ngen.name+".reset")+ngen.fftReset : 0.0
                clockSpeed: (ngen.name !== "") ? (sync(ngen.name+".freq")+ngen.fftToFreq*ngen.fftValue)*60.0/rocket_bpm : 0.0
                resetTime: 0.0

                onResetDone: {
                  //  console.log("osc:"+name, "osc reset, valueAccu:"+valueAccu, "accu:"+accu)
                    ngen.accu += ngen.valueAccu;
                    ngen.valueAccu = 0.0;
                }
            }

            property real valueScale: 1.0
            property real valueAccu: 0.0
            property real accu: 0.0

            property real resetAccu: (name !== "") ? syncTrigger(name+".resetAccu") : 0.0
            onResetAccuChanged: {
                accu = resetAccu;
            }

            onFftValueChanged: {
                if ((fftValue > fftThr) && (time >= 1.0) && (fftThr>0.01)) {
                    fftReset += 1.0;
                    valueScale = fftValue*fftGain+1.0;
                }
            }
        }
    }

    function getSceneDir() {
        return sceneDir
    }

    property var localOscs: []
    property var localFfts: []

    function smoothstep(edge0, edge1, x) {
      x = clamp((x-edge0)/(edge1-edge0), 0.0, 1.0);
      return x*x*(3.0-2.0*x);
    }

    function clamp(x, lowerlimit, upperlimit) {
      if (x < lowerlimit)
        x = lowerlimit;
      if (x > upperlimit)
        x = upperlimit;
      return x;
    }

    function syncOscBase(track, oscName, defaultValue) {
        if (sceneName == "") {
            console.log("sync called before init done");
            return 1.0;
        } else {
            var rv = sync(track, defaultValue);
            var oscNum = sync(track+"."+oscName+".num");
            if (oscNum > 0) {
                oscNum = Math.min(oscNum, 3);
                for (var oscIndex=0; oscIndex < oscNum; oscIndex++) {
                    var oscNameNum = oscName+oscIndex;
                    var oscInd = sync(track+"."+oscNameNum+".global");
                    if (((oscInd < 0) || (oscInd > 0)) && (oscInd<4)) {
                        var oscAmp = sync(track+"."+oscNameNum+".amp");
                        var oscMode = sync(track+"."+oscNameNum+".mode");
                        if (oscInd > 0) {
                            oscNameNum = "_osc"+oscInd;
                        }

                        var localId;
                        localId = track+oscNameNum;

                        if (oscMode < 9.999) { // regular oscillator
                            localId = track+oscNameNum;
                            if (localOscs[localId] === undefined) {
                                localOscs[localId] = localOscComp.createObject(scene);
                            }
                        } else if (oscMode < 19.999) { // noise oscillator
                            localId = track+oscNameNum+"noise";
                            if (localOscs[localId] === undefined) {
                                localOscs[localId] = localNoiseComp.createObject(scene);
                            }
                        }

                        if (oscInd > 0) {
                            // global
                            localOscs[localId].name = "_osc"+oscInd;
                        } else {
                            localOscs[localId].name = track+"."+oscNameNum+"local";
                        }

                        var subMode = (oscMode-oscMode.toFixed(0))*10.0;
                        var doAccu = false;
                        if (subMode < 0.9) {
                            doAccu = false;
                        } else {
                            doAccu = true;
                        }

                        oscMode = oscMode.toFixed();

                        var osc = localOscs[localId];

                        oscAmp *= osc.valueScale;

                        var v = 0.0;

                        if (oscMode < 10) { // modes up to 9 reserved for osc
//                            switch (oscMode) {
//                                case 0: // mode 0: sine wave
//                                    v = Math.sin(osc.time*2.0*Math.PI);
//                                break;
//                                case 1: // mode 1: smooth step
//                                    v = smoothstep(0.0, 1.0, osc.time);
//                                break;
//                                case 2:
//                                    v = (smoothstep(0.0, 0.50, osc.time))*(smoothstep(0.0, 0.50, 1.0-osc.time));
//                                break;
//                                case 3:
//                                    v = (smoothstep(0.0, 0.50, osc.time))*(smoothstep(0.0, 0.50, 1.0-osc.time))*Math.sin(osc.time);
//                                break;
//                                case 4: // saw up
//                                    v = Math.fract(osc.time);
//                                break;
//                                case 5: // saw down
//                                    v = 1.0-Math.fract(osc.time);
//                                break;
//                                case 6: // triangle
//                                    var ph = Math.fract(osc.time);
//                                    if (ph < 0.5) {
//                                        v = ph*2.0;
//                                    } else {
//                                        v = 1.0-(ph-0.5)*2.0;
//                                    }
//                                break;
//                            }
                           // v = Math.sin(osc.time*2.0*Math.PI);

                            if (oscMode < 0.999) { // mode 0: sine wave
                                v = Math.sin(osc.time*2.0*Math.PI);
                            } else if (oscMode < 1.999) { // mode 1: smooth step
                                v = smoothstep(0.0, 1.0, osc.time);
                            } else if (oscMode < 2.999) { // mode 2: smooth "bell" (step in & out)
                                v = (smoothstep(0.0, 0.50, osc.time))*(smoothstep(0.0, 0.50, 1.0-osc.time));
                            } else if (oscMode < 3.999) { // mode 3: smooth "bell" (step in & out) with sine
                                v = (smoothstep(0.0, 0.50, osc.time))*(smoothstep(0.0, 0.50, 1.0-osc.time))*Math.sin(osc.time*2.0*Math.PI);
                            } else if (oscMode < 4.999) { // mode 4: saw up
                                v = (osc.time-Math.floor(osc.time))*2.0-1.0;
                            } else if (oscMode < 5.999) { // mode 5: saw down
                                v = (1.0-(osc.time-Math.floor(osc.time)))*2.0-1.0;
                            } else if (oscMode < 6.999) { // mode 6: triangle
                                var ph = osc.time-Math.floor(osc.time);
                                if (ph < 0.5) {
                                    v = ph*2.0;
                                } else {
                                    v = 1.0-(ph-0.5)*2.0;
                                }
                                v = v*2.0-1.0;
                            } else if (oscMode < 7.999) { // mode 7: cosine wave
                                v = Math.cos(osc.time*2.0*Math.PI);
                            }
                            v *= oscAmp;

                        } else if (oscMode < 20) { // modes from 10 to 19 reserved for noise oscs
                            if (oscMode < 10.999) { // mode 10: noise gen
                                v = oscAmp*osc.value;
                            }
                        }
                        rv += v+osc.accu;
                        if (doAccu && (osc.time>=0.001)) {
                            osc.valueAccu = v;
                        }
                    }
                }
            }
            return rv;
        }
    }

    function syncFFTBase(track, fftName, defaultValue) {
        if (sceneName == "") {
            console.log("sync called before init done");
            return 1.0;
        } else {
            var rv = sync(track, defaultValue);
            var fftNum = sync(track+"."+fftName+".num");
            if (fftNum > 0) {
                fftNum = Math.min(fftNum, 3);
                for (var fftIndex=0; fftIndex < fftNum; fftIndex++) {
                    var fftNameNum = fftName+fftIndex;
                    var fftInd = sync(track+"."+fftNameNum+".global").toFixed(0);


                    if (((fftInd < 0) || (fftInd > 0)) && (fftInd<4)) {
                        var fftAmp = sync(track+"."+fftNameNum+".amp");
                   //     var fftThr = sync(track+"."+fftNameNum+".thr");
                   //     var fftExp = sync(track+"."+fftNameNum+".exp");
                        if (fftInd > 0) {
                            fftNameNum = "_fft"+fftInd;
                        }
                        var localId = track+fftNameNum;

                        if ((fftInd>0) && (fftInd<4)) {
                            if (fftInd===1) localFfts[localId] = fft1;
                            if (fftInd===2) localFfts[localId] = fft2;
                            if (fftInd===3) localFfts[localId] = fft3;
                        }

                        if (localFfts[localId] === undefined) {
                            localFfts[localId] = localFftComp.createObject(scene);
                        }
                        var localName;
                        if (fftInd > 0) {
                            // global
                            localName = "_fft"+fftInd;
                        } else {
                            localName = track+"."+fftNameNum+"local";
                        }
                        localFfts[localId].name = localName;
                        var fft = localFfts[localId];
                        var fftThr = sync(localName+".thr");
                        var fftExp = sync(localName+".exp");
                        rv += fftAmp*Math.pow(Math.max(fft.value-fftThr, 0.0), 1.0+fftExp);
                    }
                }
            }
            return rv;
        }
    }

    function syncOsc(track, defaultValue) {
        return syncOscBase(track, "-osc", defaultValue);
    }
    function syncFFT(track, defaultValue) {
        return syncFFTBase(track, "-fft", defaultValue);
     //   return sync(track);
    }
    function syncOscFFT(track, defaultValue) {
        return syncOscBase(track, "-osc", defaultValue)+syncFFTBase(track, "-fft", defaultValue)-sync(track, defaultValue);
    }

    function sync(track, defaultValue) {
        if (sceneName == "") {
            // not yet finished initializing the skenes...
            console.log("sync called before init done");
            return 1.0;
        } else {
            return syncRocketRoot(sceneName+"."+track, defaultValue)
          //   return syncRocketRoot(sceneName+"."+track)
        }
    }

    function syncTrigger(track) {
        if (sceneName == "") {
           // console.log("ERROR: specify \"sceneName\" for RocketScene");
            // not yet finished initializing the skenes...
            console.log("sync called before init done");
            return 1.0;
        } else {
            return syncTriggerRocketRoot(sceneName+"."+track)
            //return syncRocketRoot(track)
       //     return 1.0;
        }
    }

    function blendMode(rn) {
        var v = sync(rn+".blendMode");
        return v;
    }

    function blendSel(rn) {
        var v = sync(rn+".blendMode");
        if (v===0) return "off";
        if (v===1) return "normal";
        if (v===2) return "add";
        if (v===3) return "mul";
        if (v===4) return "sub";
        return "off";
    }

    MeshList {
        id: meshList
    }

    function meshSel(rn) {
        var v = sync(rn+".meshIndex", 18).toFixed(0);

        if (v < 1000) {
            v = Math.min(Math.max(0, v), meshList.content0.length-1);
            return "mesh/"+meshList.content0[v];
        }
        if (v < 2000) {
            v-=1000;
            v = Math.min(Math.max(0, v), meshList.content1.length-1);
            return "mesh/"+meshList.content1[v];
        }
        if (v < 3000) {
            v-=2000;
            v = Math.min(Math.max(0, v), meshList.content2.length-1);
            return "mesh/"+meshList.content2[v];
        }
        if (v < 4000) {
            v-=3000;
            v = Math.min(Math.max(0, v), meshList.content3.length-1);
            return "mesh/"+meshList.content3[v];
        }
        if (v < 5000) {
            v-=4000;
            v = Math.min(Math.max(0, v), meshList.content4.length-1);
            return "mesh/"+meshList.content4[v];
        }
        if (v < 6000) {
            v-=5000;
            v = Math.min(Math.max(0, v), meshList.content5.length-1);
            return "mesh/"+meshList.content5[v];
        }
        if (v < 10000) {
            v-=9000;
            v = Math.min(v, meshList.content9.length-1);
            return "mesh/"+meshList.content9[v];
        }

    }
    function meshSelPrefix(rn, prefix) {
        var v = sync(rn+".meshIndex").toFixed(0);
        v = Math.min(Math.max(0, v), meshList.content.length-1);
        return prefix+meshList.content[v];
    }

    sceneEnabled: bSceneEnabled
    enabled: bSceneEnabled
    visible: bSceneEnabled

}

