/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.post;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.MagnifyingFilter;
import org.openrndr.draw.MinifyingFilter;
import org.openrndr.draw.RenderTarget;
import org.openrndr.filter.antialias.FXAA;
import org.openrndr.filter.blend.BlendFiltersKt;
import org.openrndr.filter.blur.ApproximateGaussianBlur;
import org.openrndr.filter.blur.BoxBlur;
import org.openrndr.filter.blur.HashBlur;
import org.openrndr.filter.color.ColorFiltersKt;
import org.openrndr.filter.color.ColorLookup;
import org.openrndr.filter.screenspace.HexDof;
import org.openrndr.filter.screenspace.IterativeVelocityBlur;
import org.openrndr.filter.screenspace.OcclusionBlur;
import org.openrndr.filter.screenspace.PositionToCoc;
import org.openrndr.filter.screenspace.Ssao;
import org.openrndr.filter.screenspace.Sslr;
import org.openrndr.filter.screenspace.VelocityBlur;
import org.openrndr.filter.unary.SubtractConstant;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;
import post.BloomCombine;
import post.BloomDownscale;
import post.BloomUpscale;
import post.FlareCombine;
import post.FlareGhost;
import post.FloorCoc;
import studio.rndr.post.Move;
import studio.rndr.post.PostProcessor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u00a8\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J&\u0010\u00a1\u0001\u001a\u00030\u00a2\u00012\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\u0007\u0010\u00a5\u0001\u001a\u00020\u00132\t\b\u0002\u0010\u00a6\u0001\u001a\u00020\u0007J\b\u0010\u00a7\u0001\u001a\u00030\u00a4\u0001R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u0011\u0010'\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u0011\u0010)\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010$R\u0011\u0010+\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010$R\u0011\u0010-\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$R\u000e\u0010/\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u000f\"\u0004\b=\u0010\u0011R\u001a\u0010>\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\t\"\u0004\b@\u0010\u000bR\u0011\u0010A\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010$R\u000e\u0010C\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010D\u001a\u00020E\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u000e\u0010H\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020JX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010L\u001a\u00020MX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u001a\u0010R\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\t\"\u0004\bT\u0010\u000bR\u001a\u0010U\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\t\"\u0004\bW\u0010\u000bR\u001a\u0010X\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\u001a\u0010]\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010\u000f\"\u0004\b_\u0010\u0011R\u0011\u0010`\u001a\u00020a\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010cR\u000e\u0010d\u001a\u00020eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010ZR\u000e\u0010g\u001a\u00020hX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010i\u001a\u00020j\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010lR\u0011\u0010m\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010oR\u0011\u0010p\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010oR\u0011\u0010r\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\bs\u0010oR$\u0010u\u001a\u00020\u00132\u0006\u0010t\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bv\u0010o\"\u0004\bw\u0010xR\u0011\u0010y\u001a\u00020z\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010|R\u000e\u0010}\u001a\u00020~X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u007f\u001a\t\u0012\u0004\u0012\u00020\u00130\u0080\u0001\u00a2\u0006\r\n\u0003\u0010\u0083\u0001\u001a\u0006\b\u0081\u0001\u0010\u0082\u0001R\u001d\u0010\u0084\u0001\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0085\u0001\u0010\t\"\u0005\b\u0086\u0001\u0010\u000bR\u000f\u0010\u0087\u0001\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000f\u0010\u0088\u0001\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0089\u0001\u001a\u00030\u008a\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u008b\u0001\u001a\u00030\u008c\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u008d\u0001\u001a\u00030\u008e\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008f\u0001\u0010\u0090\u0001\"\u0006\b\u0091\u0001\u0010\u0092\u0001R\u000f\u0010\u0093\u0001\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0094\u0001\u001a\u00020\u0013\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0095\u0001\u0010oR\u0010\u0010\u0096\u0001\u001a\u00030\u0097\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0098\u0001\u001a\u00030\u0099\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u009a\u0001\u001a\u00030\u009b\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u009c\u0001\u001a\u00030\u009d\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u009e\u0001\u001a\u00030\u009f\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a0\u0001\u0010Z\u00a8\u0006\u00a9\u0001"}, d2={"Lstudio/rndr/post/PostProcessor;", "", "width", "", "height", "(II)V", "aperture", "", "getAperture", "()D", "setAperture", "(D)V", "applyMove", "", "getApplyMove", "()Z", "setApplyMove", "(Z)V", "bloom1", "Lorg/openrndr/draw/ColorBuffer;", "bloom2", "bloom3", "bloom4", "bloom5", "bloom6", "bloomCombine", "Lpost/BloomCombine;", "getBloomCombine", "()Lpost/BloomCombine;", "bloomDownscale", "Lpost/BloomDownscale;", "bloomUpscale", "Lpost/BloomUpscale;", "blur1", "Lorg/openrndr/filter/blur/ApproximateGaussianBlur;", "getBlur1", "()Lorg/openrndr/filter/blur/ApproximateGaussianBlur;", "blur2", "getBlur2", "blur3", "getBlur3", "blur4", "getBlur4", "blur5", "getBlur5", "blur6", "getBlur6", "coc", "cocBlurred", "colorLookup", "Lorg/openrndr/filter/color/ColorLookup;", "getColorLookup", "()Lorg/openrndr/filter/color/ColorLookup;", "dof", "emissive", "emissive2", "emissive3", "emissiveBlur", "emissiveBlur2", "enableHDR", "getEnableHDR", "setEnableHDR", "exposure", "getExposure", "setExposure", "flareBlur", "getFlareBlur", "flareBlurred", "flareCombine", "Lpost/FlareCombine;", "getFlareCombine", "()Lpost/FlareCombine;", "flareFeatures", "flareGhost", "Lpost/FlareGhost;", "flareInput", "floorCoc", "Lpost/FloorCoc;", "getFloorCoc", "()Lpost/FloorCoc;", "setFloorCoc", "(Lpost/FloorCoc;)V", "focalLength", "getFocalLength", "setFocalLength", "focalPlane", "getFocalPlane", "setFocalPlane", "frame", "getFrame", "()I", "setFrame", "(I)V", "freakMode", "getFreakMode", "setFreakMode", "fxaa", "Lorg/openrndr/filter/antialias/FXAA;", "getFxaa", "()Lorg/openrndr/filter/antialias/FXAA;", "hashBlur", "Lorg/openrndr/filter/blur/HashBlur;", "getHeight", "hexDof", "Lorg/openrndr/filter/screenspace/HexDof;", "lapBlur", "Lorg/openrndr/filter/blur/BoxBlur;", "getLapBlur", "()Lorg/openrndr/filter/blur/BoxBlur;", "lapBlurred0", "getLapBlurred0", "()Lorg/openrndr/draw/ColorBuffer;", "lapBlurred1", "getLapBlurred1", "lensDirt", "getLensDirt", "value", "lut", "getLut", "setLut", "(Lorg/openrndr/draw/ColorBuffer;)V", "luts", "Lstudio/rndr/post/PostProcessor$Luts;", "getLuts", "()Lstudio/rndr/post/PostProcessor$Luts;", "move", "Lstudio/rndr/post/Move;", "moveBuffers", "", "getMoveBuffers", "()[Lorg/openrndr/draw/ColorBuffer;", "[Lorg/openrndr/draw/ColorBuffer;", "moveThreshold", "getMoveThreshold", "setMoveThreshold", "occlusion", "occlusion2x", "occlusionBlur", "Lorg/openrndr/filter/screenspace/OcclusionBlur;", "positionToCoc", "Lorg/openrndr/filter/screenspace/PositionToCoc;", "projection", "Lorg/openrndr/math/Matrix44;", "getProjection", "()Lorg/openrndr/math/Matrix44;", "setProjection", "(Lorg/openrndr/math/Matrix44;)V", "reflection", "result2", "getResult2", "ssao", "Lorg/openrndr/filter/screenspace/Ssao;", "sslr", "Lorg/openrndr/filter/screenspace/Sslr;", "subtractConstant", "Lorg/openrndr/filter/unary/SubtractConstant;", "velocityBlur", "Lorg/openrndr/filter/screenspace/VelocityBlur;", "velocityBlur2", "Lorg/openrndr/filter/screenspace/IterativeVelocityBlur;", "getWidth", "apply", "", "gbuffer", "Lorg/openrndr/draw/RenderTarget;", "result", "time", "createGBuffer", "Luts", "demo-strap"})
public final class PostProcessor {
    private boolean freakMode;
    private boolean enableHDR;
    @NotNull
    private Matrix44 projection;
    @NotNull
    private FloorCoc floorCoc;
    @NotNull
    private final ColorBuffer lensDirt;
    @NotNull
    private final Luts luts;
    @NotNull
    private final ColorLookup colorLookup;
    private final FlareGhost flareGhost;
    private final BloomDownscale bloomDownscale;
    private final BloomUpscale bloomUpscale;
    @NotNull
    private final FXAA fxaa;
    @NotNull
    private final ApproximateGaussianBlur blur1;
    @NotNull
    private final ApproximateGaussianBlur blur2;
    @NotNull
    private final ApproximateGaussianBlur blur3;
    @NotNull
    private final ApproximateGaussianBlur blur4;
    @NotNull
    private final ApproximateGaussianBlur blur5;
    @NotNull
    private final ApproximateGaussianBlur blur6;
    @NotNull
    private final BloomCombine bloomCombine;
    private final ColorBuffer bloom1;
    private final ColorBuffer bloom2;
    private final ColorBuffer bloom3;
    private final ColorBuffer bloom4;
    private final ColorBuffer bloom5;
    private final ColorBuffer bloom6;
    private final ColorBuffer flareInput;
    private final ColorBuffer flareFeatures;
    private final ColorBuffer flareBlurred;
    private final Ssao ssao;
    private final Sslr sslr;
    private final HexDof hexDof;
    private final VelocityBlur velocityBlur;
    private final IterativeVelocityBlur velocityBlur2;
    private final PositionToCoc positionToCoc;
    private OcclusionBlur occlusionBlur;
    private final ColorBuffer reflection;
    private final ColorBuffer occlusion;
    private final ColorBuffer occlusion2x;
    private final ColorBuffer coc;
    private final ColorBuffer cocBlurred;
    private final SubtractConstant subtractConstant;
    private final ColorBuffer emissive;
    private final ColorBuffer emissive2;
    private final ColorBuffer emissive3;
    private final HashBlur hashBlur;
    private final ApproximateGaussianBlur emissiveBlur;
    private final ApproximateGaussianBlur emissiveBlur2;
    private final Move move;
    @NotNull
    private final ColorBuffer[] moveBuffers;
    @NotNull
    private final BoxBlur lapBlur;
    @NotNull
    private final ColorBuffer lapBlurred0;
    @NotNull
    private final ColorBuffer lapBlurred1;
    @NotNull
    private final ApproximateGaussianBlur flareBlur;
    @NotNull
    private final FlareCombine flareCombine;
    private final ColorBuffer dof;
    private double aperture;
    private double focalPlane;
    private double focalLength;
    private double exposure;
    private int frame;
    private boolean applyMove;
    private double moveThreshold;
    @NotNull
    private final ColorBuffer result2;
    private final int width;
    private final int height;

    public final boolean getFreakMode() {
        return this.freakMode;
    }

    public final void setFreakMode(boolean bl) {
        this.freakMode = bl;
    }

    public final boolean getEnableHDR() {
        return this.enableHDR;
    }

    public final void setEnableHDR(boolean bl) {
        this.enableHDR = bl;
    }

    @NotNull
    public final Matrix44 getProjection() {
        return this.projection;
    }

    public final void setProjection(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.projection = matrix44;
    }

    @NotNull
    public final FloorCoc getFloorCoc() {
        return this.floorCoc;
    }

    public final void setFloorCoc(@NotNull FloorCoc floorCoc) {
        Intrinsics.checkParameterIsNotNull(floorCoc, "<set-?>");
        this.floorCoc = floorCoc;
    }

    @NotNull
    public final ColorBuffer getLensDirt() {
        return this.lensDirt;
    }

    @NotNull
    public final Luts getLuts() {
        return this.luts;
    }

    @NotNull
    public final ColorLookup getColorLookup() {
        return this.colorLookup;
    }

    @NotNull
    public final ColorBuffer getLut() {
        return this.colorLookup.getLookup();
    }

    public final void setLut(@NotNull ColorBuffer value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.colorLookup.setLookup(value);
    }

    @NotNull
    public final FXAA getFxaa() {
        return this.fxaa;
    }

    @NotNull
    public final ApproximateGaussianBlur getBlur1() {
        return this.blur1;
    }

    @NotNull
    public final ApproximateGaussianBlur getBlur2() {
        return this.blur2;
    }

    @NotNull
    public final ApproximateGaussianBlur getBlur3() {
        return this.blur3;
    }

    @NotNull
    public final ApproximateGaussianBlur getBlur4() {
        return this.blur4;
    }

    @NotNull
    public final ApproximateGaussianBlur getBlur5() {
        return this.blur5;
    }

    @NotNull
    public final ApproximateGaussianBlur getBlur6() {
        return this.blur6;
    }

    @NotNull
    public final BloomCombine getBloomCombine() {
        return this.bloomCombine;
    }

    @NotNull
    public final ColorBuffer[] getMoveBuffers() {
        return this.moveBuffers;
    }

    @NotNull
    public final BoxBlur getLapBlur() {
        return this.lapBlur;
    }

    @NotNull
    public final ColorBuffer getLapBlurred0() {
        return this.lapBlurred0;
    }

    @NotNull
    public final ColorBuffer getLapBlurred1() {
        return this.lapBlurred1;
    }

    @NotNull
    public final ApproximateGaussianBlur getFlareBlur() {
        return this.flareBlur;
    }

    @NotNull
    public final FlareCombine getFlareCombine() {
        return this.flareCombine;
    }

    public final double getAperture() {
        return this.aperture;
    }

    public final void setAperture(double d) {
        this.aperture = d;
    }

    public final double getFocalPlane() {
        return this.focalPlane;
    }

    public final void setFocalPlane(double d) {
        this.focalPlane = d;
    }

    public final double getFocalLength() {
        return this.focalLength;
    }

    public final void setFocalLength(double d) {
        this.focalLength = d;
    }

    public final double getExposure() {
        return this.exposure;
    }

    public final void setExposure(double d) {
        this.exposure = d;
    }

    public final int getFrame() {
        return this.frame;
    }

    public final void setFrame(int n2) {
        this.frame = n2;
    }

    public final boolean getApplyMove() {
        return this.applyMove;
    }

    public final void setApplyMove(boolean bl) {
        this.applyMove = bl;
    }

    public final double getMoveThreshold() {
        return this.moveThreshold;
    }

    public final void setMoveThreshold(double d) {
        this.moveThreshold = d;
    }

    @NotNull
    public final ColorBuffer getResult2() {
        return this.result2;
    }

    @NotNull
    public final RenderTarget createGBuffer() {
        return DrawerKt.renderTarget$default(this.width, this.height, 0.0, createGBuffer.1.INSTANCE, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void apply(@NotNull RenderTarget gbuffer, @NotNull ColorBuffer result, double time) {
        boolean effectiveApply;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(gbuffer, "gbuffer");
        Intrinsics.checkParameterIsNotNull(result, "result");
        this.hashBlur.setTime(time);
        gbuffer.colorBuffer(1).setFilterMin(MinifyingFilter.NEAREST);
        gbuffer.colorBuffer(2).setFilterMin(MinifyingFilter.NEAREST);
        this.ssao.setColors(gbuffer.colorBufferIndex("albedo"));
        this.ssao.setPositions(gbuffer.colorBufferIndex("position"));
        this.ssao.setNormals(gbuffer.colorBufferIndex("normal"));
        this.ssao.setProjection(this.projection);
        this.ssao.setRadius(32.0);
        Collection collection = gbuffer.getColorBuffers();
        Ssao ssao = this.ssao;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v0;
        ColorBuffer[] colorBufferArray = thisCollection$iv.toArray(new ColorBuffer[0]);
        if (colorBufferArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ColorBuffer[] colorBufferArray2 = colorBufferArray;
        ssao.apply(colorBufferArray2, this.occlusion);
        this.occlusionBlur.apply(this.occlusion, this.occlusion2x);
        BlendFiltersKt.getMultiply().apply(new ColorBuffer[]{gbuffer.colorBuffer(0), this.occlusion2x}, this.occlusion2x);
        this.sslr.setColors(gbuffer.colorBufferIndex("albedo"));
        this.sslr.setPositions(gbuffer.colorBufferIndex("position"));
        this.sslr.setNormals(gbuffer.colorBufferIndex("normal"));
        this.sslr.setProjection(TransformsKt.scale((double)gbuffer.getWidth() / 2.0, (double)gbuffer.getHeight() / 2.0, 1.0).times(TransformsKt.translate(new Vector3(1.0, 1.0, 0.0))).times(this.projection));
        this.sslr.apply(new ColorBuffer[]{this.occlusion2x, gbuffer.colorBuffer(1), gbuffer.colorBuffer(2)}, this.reflection);
        BlendFiltersKt.getAdd().apply(new ColorBuffer[]{this.occlusion2x, this.reflection}, this.reflection);
        this.positionToCoc.setMinCoc(2.0);
        this.positionToCoc.setMaxCoc(20.0 * ((double)gbuffer.getWidth() / 1280.0));
        this.positionToCoc.setAperture(this.aperture * ((double)gbuffer.getWidth() / 1280.0));
        this.positionToCoc.setFocalPlane(this.focalPlane);
        this.positionToCoc.setFocalLength(this.focalLength);
        this.positionToCoc.setExposure(this.exposure);
        this.hexDof.setSamples((int)((double)20 * ((double)gbuffer.getWidth() / 1280.0)));
        this.positionToCoc.apply(new ColorBuffer[]{this.reflection, gbuffer.colorBuffer("position")}, this.coc);
        this.velocityBlur2.setIterations(10 + this.width / 1280 - 1);
        this.velocityBlur2.apply(new ColorBuffer[]{this.coc, gbuffer.colorBuffer("velocity")}, this.cocBlurred);
        this.floorCoc.apply(this.cocBlurred, this.cocBlurred);
        this.hexDof.apply(this.cocBlurred, this.dof);
        this.subtractConstant.setConstant(ColorRGBa.Companion.getWHITE().shade(0.4));
        this.subtractConstant.apply(this.dof, this.emissive);
        this.subtractConstant.setConstant(ColorRGBa.Companion.getWHITE());
        this.subtractConstant.apply(this.dof, this.flareInput);
        this.flareGhost.apply(this.flareInput, this.flareFeatures);
        this.bloomDownscale.apply(this.emissive, this.bloom1);
        this.blur1.apply(this.bloom1, this.bloom1);
        this.blur1.apply(this.bloom1, this.bloom1);
        this.bloomDownscale.apply(this.bloom1, this.bloom2);
        this.blur2.apply(this.bloom2, this.bloom2);
        this.blur2.apply(this.bloom2, this.bloom2);
        this.bloomDownscale.apply(this.bloom2, this.bloom3);
        this.blur3.apply(this.bloom3, this.bloom3);
        this.blur3.apply(this.bloom3, this.bloom3);
        this.bloomDownscale.apply(this.bloom3, this.bloom4);
        this.blur4.apply(this.bloom4, this.bloom4);
        this.blur4.apply(this.bloom4, this.bloom4);
        this.bloomDownscale.apply(this.bloom4, this.bloom5);
        this.blur5.apply(this.bloom5, this.bloom5);
        this.blur5.apply(this.bloom5, this.bloom5);
        this.bloomDownscale.apply(this.bloom5, this.bloom6);
        this.blur6.apply(this.bloom6, this.bloom6);
        this.blur6.apply(this.bloom6, this.bloom6);
        this.bloom1.filter(MinifyingFilter.LINEAR, MagnifyingFilter.LINEAR);
        this.bloom2.filter(MinifyingFilter.LINEAR, MagnifyingFilter.LINEAR);
        this.bloom3.filter(MinifyingFilter.LINEAR, MagnifyingFilter.LINEAR);
        this.bloom4.filter(MinifyingFilter.LINEAR, MagnifyingFilter.LINEAR);
        this.bloom5.filter(MinifyingFilter.LINEAR, MagnifyingFilter.LINEAR);
        this.bloom6.filter(MinifyingFilter.LINEAR, MagnifyingFilter.LINEAR);
        this.bloomUpscale.setShape(0.25);
        this.bloomUpscale.apply(new ColorBuffer[]{this.bloom1, this.bloom2, this.bloom3, this.bloom4, this.bloom5, this.bloom6}, this.emissive3);
        this.bloomCombine.setGain(0.2);
        this.bloomCombine.apply(new ColorBuffer[]{this.dof, this.emissive3}, this.dof);
        this.bloomCombine.setGain(1.0);
        this.flareBlur.apply(this.flareFeatures, this.flareFeatures);
        this.flareCombine.setTime(time);
        this.flareCombine.apply(new ColorBuffer[]{this.dof, this.flareFeatures, this.lensDirt}, this.dof);
        if (!this.enableHDR) {
            ColorFiltersKt.getDelinearize().apply(this.dof, this.result2);
        } else {
            BlendFiltersKt.getPassthrough().apply(this.dof, this.result2);
        }
        this.colorLookup.apply(this.result2, this.result2);
        this.fxaa.setMaxSpan(16.0);
        this.fxaa.setDirectionReduceMinimum(0.5);
        this.fxaa.setDirectionReduceMultiplier(0.5);
        this.fxaa.setLumaThreshold(0.5);
        this.fxaa.apply(this.result2, result);
        boolean bl = effectiveApply = this.applyMove || this.freakMode;
        if (!effectiveApply) {
            BlendFiltersKt.getPassthrough().apply(result, this.moveBuffers[this.frame % 2]);
        }
        if (effectiveApply) {
            if (this.freakMode) {
                this.move.setThreshold(0.5);
            }
            this.lapBlur.setWindow(1);
            this.lapBlur.apply(result, this.lapBlurred0);
            this.lapBlur.apply(this.lapBlurred0, this.lapBlurred1);
            BlendFiltersKt.getSubtract().apply(new ColorBuffer[]{this.lapBlurred0, this.lapBlurred1}, this.lapBlurred1);
            BlendFiltersKt.getSubtract().apply(new ColorBuffer[]{result, this.lapBlurred0}, this.lapBlurred0);
            this.move.setTime(time);
            this.move.setThreshold(this.moveThreshold);
            this.move.apply(new ColorBuffer[]{this.moveBuffers[(this.frame + 1) % 2], gbuffer.colorBuffer("velocity"), this.lapBlurred0, this.lapBlurred1, result}, this.moveBuffers[this.frame % 2]);
            BlendFiltersKt.getPassthrough().apply(this.moveBuffers[this.frame % 2], result);
        }
        int n2 = this.frame;
        this.frame = n2 + 1;
    }

    public static /* bridge */ /* synthetic */ void apply$default(PostProcessor postProcessor, RenderTarget renderTarget, ColorBuffer colorBuffer, double d, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d = 0.0;
        }
        postProcessor.apply(renderTarget, colorBuffer, d);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    /*
     * WARNING - void declaration
     */
    public PostProcessor(int width, int height) {
        void size$iv;
        this.width = width;
        this.height = height;
        this.projection = Matrix44.Companion.getIDENTITY();
        this.floorCoc = new FloorCoc();
        this.lensDirt = ColorBuffer.Companion.fromUrl("file:data/textures/lensdirt.png");
        this.luts = new Luts();
        Object object = new ColorLookup(this.luts.getPurple03());
        PostProcessor postProcessor = this;
        Object $receiver = object;
        ((ColorLookup)$receiver).setNoiseGain(0.01);
        Object object2 = object;
        postProcessor.colorLookup = object2;
        this.flareGhost = new FlareGhost();
        this.bloomDownscale = new BloomDownscale();
        this.bloomUpscale = new BloomUpscale();
        this.fxaa = new FXAA();
        this.blur1 = new ApproximateGaussianBlur();
        this.blur2 = new ApproximateGaussianBlur();
        this.blur3 = new ApproximateGaussianBlur();
        this.blur4 = new ApproximateGaussianBlur();
        this.blur5 = new ApproximateGaussianBlur();
        this.blur6 = new ApproximateGaussianBlur();
        this.bloomCombine = new BloomCombine();
        this.bloom1 = DrawerKt.colorBuffer(this.width / 2, this.height / 2, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.bloom2 = DrawerKt.colorBuffer(this.width / 4, this.height / 4, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.bloom3 = DrawerKt.colorBuffer(this.width / 8, this.height / 8, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.bloom4 = DrawerKt.colorBuffer(this.width / 16, this.height / 16, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.bloom5 = DrawerKt.colorBuffer(this.width / 32, this.height / 32, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.bloom6 = DrawerKt.colorBuffer(this.width / 64, this.height / 64, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.flareInput = DrawerKt.colorBuffer(this.width / 2, this.height / 2, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.flareFeatures = DrawerKt.colorBuffer(this.width / 8, this.height / 8, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.flareBlurred = DrawerKt.colorBuffer(this.width / 8, this.height / 8, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.ssao = new Ssao();
        this.sslr = new Sslr();
        this.hexDof = new HexDof();
        this.velocityBlur = new VelocityBlur();
        this.velocityBlur2 = new IterativeVelocityBlur();
        this.positionToCoc = new PositionToCoc();
        this.occlusionBlur = new OcclusionBlur();
        this.reflection = DrawerKt.colorBuffer(this.width, this.height, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.occlusion = DrawerKt.colorBuffer(this.width / 2, this.height / 2, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.occlusion2x = DrawerKt.colorBuffer(this.width, this.height, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.coc = DrawerKt.colorBuffer(this.width, this.height, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.cocBlurred = DrawerKt.colorBuffer(this.width, this.height, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.subtractConstant = new SubtractConstant();
        this.emissive = DrawerKt.colorBuffer(this.width / 2, this.height / 2, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.emissive2 = DrawerKt.colorBuffer(this.width / 4, this.height / 4, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.emissive3 = DrawerKt.colorBuffer(this.width / 1, this.height / 1, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        object = new HashBlur();
        postProcessor = this;
        $receiver = object;
        ((HashBlur)$receiver).setGain(0.05);
        object2 = object;
        postProcessor.hashBlur = object2;
        object = new ApproximateGaussianBlur();
        postProcessor = this;
        $receiver = object;
        ((ApproximateGaussianBlur)$receiver).setSigma(3.0);
        ((ApproximateGaussianBlur)$receiver).setWindow(9);
        object2 = object;
        postProcessor.emissiveBlur = object2;
        object = new ApproximateGaussianBlur();
        postProcessor = this;
        $receiver = object;
        ((ApproximateGaussianBlur)$receiver).setSigma(3.0);
        ((ApproximateGaussianBlur)$receiver).setWindow(9);
        object2 = object;
        postProcessor.emissiveBlur2 = object2;
        this.move = new Move();
        int n2 = 2;
        postProcessor = this;
        ColorBuffer[] result$iv = new ColorBuffer[size$iv];
        int $i$a$1$apply = 0;
        int n3 = result$iv.length;
        while ($i$a$1$apply < n3) {
            ColorBuffer colorBuffer;
            void i$iv;
            void var7_11 = i$iv;
            void var12_12 = i$iv++;
            object2 = result$iv;
            object2[var12_12] = colorBuffer = DrawerKt.colorBuffer(this.width, this.height, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        }
        object2 = result$iv;
        postProcessor.moveBuffers = object2;
        this.lapBlur = new BoxBlur();
        this.lapBlurred0 = DrawerKt.colorBuffer(this.width, this.height, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.lapBlurred1 = DrawerKt.colorBuffer(this.width, this.height, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        ApproximateGaussianBlur approximateGaussianBlur = new ApproximateGaussianBlur();
        postProcessor = this;
        $receiver = approximateGaussianBlur;
        ((ApproximateGaussianBlur)$receiver).setSigma(3.0);
        ((ApproximateGaussianBlur)$receiver).setWindow(9);
        postProcessor.flareBlur = object2 = approximateGaussianBlur;
        this.flareCombine = new FlareCombine();
        this.dof = DrawerKt.colorBuffer(this.width, this.height, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
        this.aperture = 1.0;
        this.focalPlane = 100.0;
        this.focalLength = 10.0;
        this.exposure = 1.0;
        this.moveThreshold = 140.0;
        this.result2 = DrawerKt.colorBuffer(this.width, this.height, 1.0, ColorFormat.RGBa, ColorType.FLOAT16);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\bR\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lstudio/rndr/post/PostProcessor$Luts;", "", "()V", "cripWinter", "Lorg/openrndr/draw/ColorBuffer;", "getCripWinter", "()Lorg/openrndr/draw/ColorBuffer;", "setCripWinter", "(Lorg/openrndr/draw/ColorBuffer;)V", "horrorBlue", "getHorrorBlue", "neutral", "getNeutral", "setNeutral", "purple03", "getPurple03", "demo-strap"})
    public static final class Luts {
        @NotNull
        private final ColorBuffer purple03 = ColorBuffer.Companion.fromUrl("file:data/color-lookup/purple-03.png");
        @NotNull
        private final ColorBuffer horrorBlue = ColorBuffer.Companion.fromUrl("file:data/color-lookup/horror-blue.png");
        @NotNull
        private ColorBuffer cripWinter = ColorBuffer.Companion.fromUrl("file:data/color-lookup/crisp-winter.png");
        @NotNull
        private ColorBuffer neutral = ColorBuffer.Companion.fromUrl("file:data/color-lookup/neutral.png");

        @NotNull
        public final ColorBuffer getPurple03() {
            return this.purple03;
        }

        @NotNull
        public final ColorBuffer getHorrorBlue() {
            return this.horrorBlue;
        }

        @NotNull
        public final ColorBuffer getCripWinter() {
            return this.cripWinter;
        }

        public final void setCripWinter(@NotNull ColorBuffer colorBuffer) {
            Intrinsics.checkParameterIsNotNull(colorBuffer, "<set-?>");
            this.cripWinter = colorBuffer;
        }

        @NotNull
        public final ColorBuffer getNeutral() {
            return this.neutral;
        }

        public final void setNeutral(@NotNull ColorBuffer colorBuffer) {
            Intrinsics.checkParameterIsNotNull(colorBuffer, "<set-?>");
            this.neutral = colorBuffer;
        }
    }
}

