/*
 * Decompiled with CFR 0.152.
 */
package sketches;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.DropEvent;
import org.openrndr.KeyEvent;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.DepthTestPass;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.RenderTarget;
import org.openrndr.filter.blend.MultiplyContrast;
import org.openrndr.math.Matrix44;
import org.openrndr.math.QuaternionKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformsKt;
import scenes.BackBox;
import scenes.CityFloor;
import scenes.Crawlers;
import scenes.CrawlersIntro;
import scenes.Crowd02;
import scenes.CrowdIntro;
import scenes.CrowdOutro;
import scenes.DisplayLines;
import scenes.Floor;
import scenes.MegaMarchingCrawlers;
import scenes.RenderStyle;
import scenes.SkyBox;
import scenes.TexturedRectangle;
import sketches.CameraTool;
import studio.rndr.camera.CameraKey;
import studio.rndr.camera.CameraKeyframer;
import studio.rndr.camera.FirstPersonCamera;
import studio.rndr.camera.TweenMode;
import studio.rndr.post.PostProcessor;
import studio.rndr.screens.City;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010T\u001a\u00020\u001cH\u0016J\b\u0010U\u001a\u00020\u001cH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010*\"\u0004\b5\u0010,R\u001a\u00106\u001a\u00020\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010$\"\u0004\b8\u0010&R\u001a\u00109\u001a\u00020:X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u001a\u0010K\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\u0006\"\u0004\bM\u0010\bR\u001a\u0010N\u001a\u00020OX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010S\u00a8\u0006V"}, d2={"Lsketches/CameraTool;", "Lorg/openrndr/Program;", "()V", "activeInterval", "", "getActiveInterval", "()D", "setActiveInterval", "(D)V", "activeTweenMode", "Lstudio/rndr/camera/TweenMode;", "getActiveTweenMode", "()Lstudio/rndr/camera/TweenMode;", "setActiveTweenMode", "(Lstudio/rndr/camera/TweenMode;)V", "animationTime", "getAnimationTime", "setAnimationTime", "camera", "Lstudio/rndr/camera/FirstPersonCamera;", "getCamera", "()Lstudio/rndr/camera/FirstPersonCamera;", "cameraKeyFramer", "Lstudio/rndr/camera/CameraKeyframer;", "getCameraKeyFramer", "()Lstudio/rndr/camera/CameraKeyframer;", "drawFunction", "Lkotlin/Function1;", "", "getDrawFunction", "()Lkotlin/jvm/functions/Function1;", "setDrawFunction", "(Lkotlin/jvm/functions/Function1;)V", "font", "Lorg/openrndr/draw/FontImageMap;", "getFont", "()Lorg/openrndr/draw/FontImageMap;", "setFont", "(Lorg/openrndr/draw/FontImageMap;)V", "gbuffer", "Lorg/openrndr/draw/RenderTarget;", "getGbuffer", "()Lorg/openrndr/draw/RenderTarget;", "setGbuffer", "(Lorg/openrndr/draw/RenderTarget;)V", "multiplyContrast", "Lorg/openrndr/filter/blend/MultiplyContrast;", "getMultiplyContrast", "()Lorg/openrndr/filter/blend/MultiplyContrast;", "setMultiplyContrast", "(Lorg/openrndr/filter/blend/MultiplyContrast;)V", "overlay", "getOverlay", "setOverlay", "overlayFont", "getOverlayFont", "setOverlayFont", "postProcessor", "Lstudio/rndr/post/PostProcessor;", "getPostProcessor", "()Lstudio/rndr/post/PostProcessor;", "setPostProcessor", "(Lstudio/rndr/post/PostProcessor;)V", "previousViewMatrix", "Lorg/openrndr/math/Matrix44;", "getPreviousViewMatrix", "()Lorg/openrndr/math/Matrix44;", "setPreviousViewMatrix", "(Lorg/openrndr/math/Matrix44;)V", "replayAnimation", "", "getReplayAnimation", "()Z", "setReplayAnimation", "(Z)V", "replayStart", "getReplayStart", "setReplayStart", "result", "Lorg/openrndr/draw/ColorBuffer;", "getResult", "()Lorg/openrndr/draw/ColorBuffer;", "setResult", "(Lorg/openrndr/draw/ColorBuffer;)V", "draw", "setup", "demo-strap"})
public final class CameraTool
extends Program {
    @NotNull
    public PostProcessor postProcessor;
    @NotNull
    public ColorBuffer result;
    @NotNull
    public RenderTarget gbuffer;
    @NotNull
    private final FirstPersonCamera camera = new FirstPersonCamera();
    @NotNull
    private Matrix44 previousViewMatrix = Matrix44.Companion.getIDENTITY();
    @NotNull
    public RenderTarget overlay;
    @NotNull
    public MultiplyContrast multiplyContrast;
    @NotNull
    private final CameraKeyframer cameraKeyFramer = new CameraKeyframer();
    @NotNull
    private TweenMode activeTweenMode = TweenMode.LINEAR;
    private double activeInterval = 1.0;
    private boolean replayAnimation;
    private double replayStart;
    @NotNull
    public FontImageMap font;
    @NotNull
    public FontImageMap overlayFont;
    @NotNull
    public Function1<? super Double, Unit> drawFunction;
    private double animationTime;

    @NotNull
    public final PostProcessor getPostProcessor() {
        PostProcessor postProcessor = this.postProcessor;
        if (postProcessor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("postProcessor");
        }
        return postProcessor;
    }

    public final void setPostProcessor(@NotNull PostProcessor postProcessor) {
        Intrinsics.checkParameterIsNotNull(postProcessor, "<set-?>");
        this.postProcessor = postProcessor;
    }

    @NotNull
    public final ColorBuffer getResult() {
        ColorBuffer colorBuffer = this.result;
        if (colorBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("result");
        }
        return colorBuffer;
    }

    public final void setResult(@NotNull ColorBuffer colorBuffer) {
        Intrinsics.checkParameterIsNotNull(colorBuffer, "<set-?>");
        this.result = colorBuffer;
    }

    @NotNull
    public final RenderTarget getGbuffer() {
        RenderTarget renderTarget = this.gbuffer;
        if (renderTarget == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gbuffer");
        }
        return renderTarget;
    }

    public final void setGbuffer(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkParameterIsNotNull(renderTarget, "<set-?>");
        this.gbuffer = renderTarget;
    }

    @NotNull
    public final FirstPersonCamera getCamera() {
        return this.camera;
    }

    @NotNull
    public final Matrix44 getPreviousViewMatrix() {
        return this.previousViewMatrix;
    }

    public final void setPreviousViewMatrix(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.previousViewMatrix = matrix44;
    }

    @NotNull
    public final RenderTarget getOverlay() {
        RenderTarget renderTarget = this.overlay;
        if (renderTarget == null) {
            Intrinsics.throwUninitializedPropertyAccessException("overlay");
        }
        return renderTarget;
    }

    public final void setOverlay(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkParameterIsNotNull(renderTarget, "<set-?>");
        this.overlay = renderTarget;
    }

    @NotNull
    public final MultiplyContrast getMultiplyContrast() {
        MultiplyContrast multiplyContrast = this.multiplyContrast;
        if (multiplyContrast == null) {
            Intrinsics.throwUninitializedPropertyAccessException("multiplyContrast");
        }
        return multiplyContrast;
    }

    public final void setMultiplyContrast(@NotNull MultiplyContrast multiplyContrast) {
        Intrinsics.checkParameterIsNotNull(multiplyContrast, "<set-?>");
        this.multiplyContrast = multiplyContrast;
    }

    @NotNull
    public final CameraKeyframer getCameraKeyFramer() {
        return this.cameraKeyFramer;
    }

    @NotNull
    public final TweenMode getActiveTweenMode() {
        return this.activeTweenMode;
    }

    public final void setActiveTweenMode(@NotNull TweenMode tweenMode) {
        Intrinsics.checkParameterIsNotNull((Object)tweenMode, "<set-?>");
        this.activeTweenMode = tweenMode;
    }

    public final double getActiveInterval() {
        return this.activeInterval;
    }

    public final void setActiveInterval(double d) {
        this.activeInterval = d;
    }

    public final boolean getReplayAnimation() {
        return this.replayAnimation;
    }

    public final void setReplayAnimation(boolean bl) {
        this.replayAnimation = bl;
    }

    public final double getReplayStart() {
        return this.replayStart;
    }

    public final void setReplayStart(double d) {
        this.replayStart = d;
    }

    @NotNull
    public final FontImageMap getFont() {
        FontImageMap fontImageMap = this.font;
        if (fontImageMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("font");
        }
        return fontImageMap;
    }

    public final void setFont(@NotNull FontImageMap fontImageMap) {
        Intrinsics.checkParameterIsNotNull(fontImageMap, "<set-?>");
        this.font = fontImageMap;
    }

    @NotNull
    public final FontImageMap getOverlayFont() {
        FontImageMap fontImageMap = this.overlayFont;
        if (fontImageMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("overlayFont");
        }
        return fontImageMap;
    }

    public final void setOverlayFont(@NotNull FontImageMap fontImageMap) {
        Intrinsics.checkParameterIsNotNull(fontImageMap, "<set-?>");
        this.overlayFont = fontImageMap;
    }

    @NotNull
    public final Function1<Double, Unit> getDrawFunction() {
        Function1<Double, Unit> function1 = this.drawFunction;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawFunction");
        }
        return function1;
    }

    public final void setDrawFunction(@NotNull Function1<? super Double, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, "<set-?>");
        this.drawFunction = function1;
    }

    @Override
    public void setup() {
        Floor floor2 = new Floor(0.0, 0.0, 3, null);
        CrowdOutro crowdOutro = new CrowdOutro();
        CrowdIntro scene = new CrowdIntro();
        CrawlersIntro crawlersIntro = new CrawlersIntro();
        Crawlers crawlers = new Crawlers();
        Crowd02 crowd02 = new Crowd02();
        BackBox backBox = new BackBox(1000.0);
        City city = new City();
        MegaMarchingCrawlers megaMarchingCrawlers = new MegaMarchingCrawlers();
        SkyBox skyBox = new SkyBox(0.0, 1, null);
        CityFloor cityFloor = new CityFloor(city.getIrradiance(), 0.0, 0.0, 6, null);
        DisplayLines displayLines = new DisplayLines();
        TexturedRectangle texturedRectangle = new TexturedRectangle(displayLines.getRt().colorBuffer(0), 0.0, 0.0, 6, null);
        this.drawFunction = new Function1<Double, Unit>(this, skyBox, crowdOutro){
            final /* synthetic */ CameraTool this$0;
            final /* synthetic */ SkyBox $skyBox;
            final /* synthetic */ CrowdOutro $crowdOutro;

            public final void invoke(double time) {
                RenderStyle renderStyle = new RenderStyle();
                renderStyle.setSkyIntensity(0.125);
                this.this$0.getDrawer().setFill(ColorRGBa.Companion.getWHITE().shade(0.2));
                this.$skyBox.draw(this.this$0.getDrawer(), renderStyle);
                this.$crowdOutro.draw(this.this$0.getDrawer(), time, renderStyle);
            }
            {
                this.this$0 = cameraTool;
                this.$skyBox = skyBox;
                this.$crowdOutro = crowdOutro;
                super(1);
            }
        };
        this.font = FontImageMap.Companion.fromUrl$default(FontImageMap.Companion, "file:data/fonts/IBMPLexMono-Bold.ttf", 16.0, 0.0, 4, null);
        this.overlayFont = FontImageMap.Companion.fromUrl$default(FontImageMap.Companion, "file:data/fonts/IBMPLexMono-Bold.ttf", 196.0, 0.0, 4, null);
        this.overlay = DrawerKt.renderTarget$default(this.getWidth(), this.getHeight(), 0.0, setup.2.INSTANCE, 4, null);
        this.gbuffer = DrawerKt.renderTarget$default(this.getWidth(), this.getHeight(), 0.0, setup.3.INSTANCE, 4, null);
        this.result = DrawerKt.colorBuffer$default(this.getWidth(), this.getHeight(), 0.0, null, null, 28, null);
        this.postProcessor = new PostProcessor(this.getWidth(), this.getHeight());
        this.multiplyContrast = new MultiplyContrast();
        this.camera.setup(this);
        this.getWindow().getDrop().listen(new Function1<DropEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull DropEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                String json = FilesKt.readText$default(CollectionsKt.first(it2.getFiles()), null, 1, null);
                CameraKey[] cameraKeyArray = new Gson().fromJson(json, CameraKey[].class);
                Intrinsics.checkExpressionValueIsNotNull(cameraKeyArray, "Gson().fromJson(json, Ar\u2026y<CameraKey>::class.java)");
                List<Object> keys2 = ArraysKt.toList((Object[])cameraKeyArray);
                this.this$0.getCameraKeyFramer().getKeys().clear();
                this.this$0.getCameraKeyFramer().getKeys().addAll((Collection<CameraKey>)keys2);
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getMouse().getClicked().listen(new Function1<Program.Mouse.MouseEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull Program.Mouse.MouseEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.this$0.getGbuffer().colorBuffer("position").getShadow().download();
                double z = this.this$0.getGbuffer().colorBuffer("position").getShadow().read((int)this.this$0.getMouse().getPosition().getX(), (int)this.this$0.getMouse().getPosition().getY()).getB();
                this.this$0.getCamera().setFocalPlane(Math.abs(z));
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.6.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.this$0.getPostProcessor().setApplyMove(!this.this$0.getPostProcessor().getApplyMove());
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.8.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                double last = -this.this$0.getActiveInterval();
                if (this.this$0.getCameraKeyFramer().getKeys().size() > 0) {
                    last = CollectionsKt.last(this.this$0.getCameraKeyFramer().getKeys()).getTime();
                }
                this.this$0.getCameraKeyFramer().getKeys().add(new CameraKey(this.this$0.getCamera().getPosition(), this.this$0.getCamera().getCameraQuat(), this.this$0.getCamera().getFov(), this.this$0.getCamera().getAperture(), this.this$0.getCamera().getFocalPlane(), this.this$0.getCamera().getExposure(), this.this$0.getCamera().getCenterX(), this.this$0.getCamera().getCenterY(), last + this.this$0.getActiveInterval(), this.this$0.getActiveTweenMode()));
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.10.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.this$0.getCameraKeyFramer().getKeys().clear();
                this.this$0.setReplayAnimation(false);
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.12.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                CameraTool cameraTool = this.this$0;
                double d = cameraTool.getActiveInterval();
                cameraTool.setActiveInterval(d + 1.0);
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.14.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                CameraTool cameraTool = this.this$0;
                double d = cameraTool.getActiveInterval();
                cameraTool.setActiveInterval(d + -1.0);
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.16.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.this$0.setActiveTweenMode(TweenMode.values()[(this.this$0.getActiveTweenMode().ordinal() + 1) % ((Object[])TweenMode.values()).length]);
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.18.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.this$0.setActiveTweenMode(TweenMode.values()[((this.this$0.getActiveTweenMode().ordinal() - 1) % ((Object[])TweenMode.values()).length + ((Object[])TweenMode.values()).length) % ((Object[])TweenMode.values()).length]);
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.20.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                if (this.this$0.getCameraKeyFramer().getKeys().size() > 0) {
                    this.this$0.getCameraKeyFramer().getKeys().remove(CollectionsKt.getLastIndex(this.this$0.getCameraKeyFramer().getKeys()));
                }
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.22.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                this.this$0.setReplayAnimation(!this.this$0.getReplayAnimation());
                if (this.this$0.getReplayAnimation()) {
                    this.this$0.setReplayStart(this.this$0.getSeconds());
                }
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.24.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                if (this.this$0.getCameraKeyFramer().getKeys().size() > 0) {
                    this.this$0.getCamera().setCameraQuat(CollectionsKt.last(this.this$0.getCameraKeyFramer().getKeys()).getOrientation());
                }
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.26.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                if (this.this$0.getCameraKeyFramer().getKeys().size() > 0) {
                    this.this$0.getCamera().setPosition(CollectionsKt.last(this.this$0.getCameraKeyFramer().getKeys()).getPosition());
                }
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.28.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull KeyEvent it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                LocalDateTime dt = LocalDateTime.now();
                StringBuilder stringBuilder = new StringBuilder().append("camera-recording-");
                LocalDateTime localDateTime = dt;
                Intrinsics.checkExpressionValueIsNotNull(localDateTime, "dt");
                Month month = localDateTime.getMonth();
                Intrinsics.checkExpressionValueIsNotNull(month, "dt.month");
                File f = new File(stringBuilder.append(month.getValue()).append('-').append(dt.getDayOfMonth()).append('_').append(dt.getHour()).append('-').append(dt.getMinute()).append(".json").toString());
                String string = new GsonBuilder().setPrettyPrinting().create().toJson(this.this$0.getCameraKeyFramer().getKeys());
                Intrinsics.checkExpressionValueIsNotNull(string, "GsonBuilder().setPrettyP\u2026son(cameraKeyFramer.keys)");
                FilesKt.writeText$default(f, string, null, 2, null);
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
    }

    public final double getAnimationTime() {
        return this.animationTime;
    }

    public final void setAnimationTime(double d) {
        this.animationTime = d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        this.getDrawer().background(ColorRGBa.Companion.getPINK());
        Drawer drawer = this.getDrawer();
        RenderTarget renderTarget = this.gbuffer;
        if (renderTarget == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gbuffer");
        }
        DrawerKt.isolatedWithTarget(drawer, renderTarget, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this){
            final /* synthetic */ CameraTool this$0;

            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.this$0.getDrawer().setDepthTestPass(DepthTestPass.LESS_OR_EQUAL);
                this.this$0.getDrawer().setDepthWrite(true);
                this.this$0.getDrawer().background(ColorRGBa.Companion.getBLACK());
                this.this$0.getDrawer().perspective(this.this$0.getCamera().getFov(), (double)$receiver.getWidth() * 1.0 / (double)$receiver.getHeight(), 0.1, 1400.0);
                if (this.this$0.getReplayAnimation()) {
                    this.this$0.setAnimationTime((this.this$0.getSeconds() - this.this$0.getReplayStart()) * 1.8666666666666667);
                } else {
                    double last = -this.this$0.getActiveInterval();
                    if (this.this$0.getCameraKeyFramer().getKeys().size() > 0) {
                        last = CollectionsKt.last(this.this$0.getCameraKeyFramer().getKeys()).getTime();
                    }
                    this.this$0.setAnimationTime(last + this.this$0.getActiveInterval());
                }
                if (this.this$0.getReplayAnimation()) {
                    CameraKey frame = this.this$0.getCameraKeyFramer().frame(this.this$0.getAnimationTime());
                    this.this$0.getCamera().setPosition(frame.getPosition());
                    this.this$0.getCamera().setCameraQuat(frame.getOrientation());
                    this.this$0.getCamera().setFov(frame.getFov());
                    this.this$0.getCamera().setAperture(frame.getAperture());
                    this.this$0.getCamera().setFocalPlane(frame.getFocalPlane());
                    this.this$0.getCamera().setExposure(frame.getExposure());
                    this.this$0.getCamera().setCenterX(frame.getCenterX());
                    this.this$0.getCamera().setCenterY(frame.getCenterY());
                    this.this$0.getCamera().update();
                }
                this.this$0.getDrawer().setProjection(TransformsKt.perspective(this.this$0.getCamera().getFov(), (double)$receiver.getWidth() * 1.0 / (double)$receiver.getHeight(), 0.1, 1400.0, this.this$0.getCamera().getCenterX() * 0.1, this.this$0.getCamera().getCenterY() * 0.1));
                this.this$0.getPostProcessor().setProjection(this.this$0.getDrawer().getProjection());
                this.this$0.getPostProcessor().setAperture(this.this$0.getCamera().getAperture());
                this.this$0.getPostProcessor().setFocalPlane(this.this$0.getCamera().getFocalPlane());
                this.this$0.getPostProcessor().setExposure(this.this$0.getCamera().getExposure());
                this.this$0.getDrawer().setView(this.this$0.getCamera().getViewMatrix());
                this.this$0.getDrawFunction().invoke(this.this$0.getAnimationTime());
                this.this$0.setPreviousViewMatrix(this.this$0.getDrawer().getView());
            }
            {
                this.this$0 = cameraTool;
                super(1);
            }
        });
        PostProcessor postProcessor = this.postProcessor;
        if (postProcessor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("postProcessor");
        }
        RenderTarget renderTarget2 = this.gbuffer;
        if (renderTarget2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gbuffer");
        }
        ColorBuffer colorBuffer = this.result;
        if (colorBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("result");
        }
        PostProcessor.apply$default(postProcessor, renderTarget2, colorBuffer, 0.0, 4, null);
        Drawer drawer2 = this.getDrawer();
        ColorBuffer colorBuffer2 = this.result;
        if (colorBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("result");
        }
        drawer2.image(colorBuffer2);
        Drawer drawer3 = this.getDrawer();
        FontImageMap fontImageMap = this.font;
        if (fontImageMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("font");
        }
        drawer3.setFontMap(fontImageMap);
        this.getDrawer().setFill(new ColorRGBa(1.0, 0.5, 0.0, 0.0, null, 24, null));
        this.getDrawer().text("aperture: " + this.camera.getAperture(), 40.0, 100.0);
        this.getDrawer().text("exposure: " + this.camera.getExposure(), 40.0, 120.0);
        this.getDrawer().text("focal plane: " + this.camera.getFocalPlane(), 40.0, 140.0);
        this.getDrawer().text("fov: " + this.camera.getFov(), 40.0, 180.0);
        this.getDrawer().text("center: " + this.camera.getCenterX() + ' ' + this.camera.getCenterY(), 40.0, 200.0);
        this.getDrawer().text("tween: " + this.activeTweenMode.name(), 40.0, 220.0);
        this.getDrawer().text("interval: " + this.activeInterval, 40.0, 240.0);
        if (this.cameraKeyFramer.getKeys().size() > 0) {
            CameraKey last = CollectionsKt.last(this.cameraKeyFramer.getKeys());
            this.getDrawer().text("last: " + last.getTime(), 40.0, 260.0);
            this.getDrawer().text("distance from last: " + this.camera.getPosition().minus(last.getPosition()).getLength(), 40.0, 280.0);
            this.getDrawer().text("rotation from last: " + QuaternionKt.dot(this.camera.getCameraQuat().getNormalized(), last.getOrientation().getNormalized()), 40.0, 300.0);
        }
        Iterable iterable = $receiver$iv = (Iterable)this.cameraKeyFramer.getKeys();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            CameraKey cameraKey = (CameraKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            double x = it2.getTime() % 16.0 * 16.0 + (double)(this.getWidth() - 300);
            double y = Math.floor(it2.getTime() / 16.0) * 16.0 + 100.0;
            Vector2 vector2 = new Vector2(x, y);
            collection.add(vector2);
        }
        List circles = (List)destination$iv$iv;
        this.getDrawer().circles((List<Vector2>)circles, 6.0);
    }
}

