/*
 * Decompiled with CFR 0.152.
 */
package scenes;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.ShapeContour;
import scenes.Walker;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0012"}, d2={"Lscenes/PathWalker2;", "Lscenes/Walker;", "path", "Lorg/openrndr/shape/ShapeContour;", "speed", "", "(Lorg/openrndr/shape/ShapeContour;D)V", "lastTime", "getLastTime", "()D", "setLastTime", "(D)V", "getPath", "()Lorg/openrndr/shape/ShapeContour;", "getSpeed", "updatePositionAndDirection", "", "time", "demo-strap"})
public final class PathWalker2
extends Walker {
    private double lastTime;
    @NotNull
    private final ShapeContour path;
    private final double speed;

    public final double getLastTime() {
        return this.lastTime;
    }

    public final void setLastTime(double d) {
        this.lastTime = d;
    }

    @Override
    public boolean updatePositionAndDirection(double time) {
        double t2 = Math.floor(time / (double)2);
        double tf = time / (double)2 - t2;
        double stf = MappingKt.smoothstep(0.0, 0.5, tf);
        double stime = (t2 + stf) * (double)2;
        Vector2 p = this.path.position(this.speed * stime / 150.0);
        Vector2 d = this.path.normal(this.speed * stime / 150.0);
        Vector2 dp = d.getPerpendicular();
        this.setLegStepSize(1.0);
        this.setLegOffsetSize(2.5);
        this.setDirection(new Vector3(dp.getX(), 0.0, dp.getY()).getNormalized());
        if (time < this.lastTime) {
            this.setSmoothDirection(this.getDirection());
        }
        this.setSmoothDirection(this.getDirection().times(this.getSmoothDirection()).times(0.9999).plus(this.getDirection().times(1.0E-4)).getNormalized());
        this.lastTime = time;
        this.setX(p.getX());
        this.setZ(p.getY());
        if (!this.hasAnimations()) {
            this.animate("dummy", 1.0, (long)((double)250 / this.speed));
            return true;
        }
        return false;
    }

    @NotNull
    public final ShapeContour getPath() {
        return this.path;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public PathWalker2(@NotNull ShapeContour path, double speed) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        this.path = path;
        this.speed = speed;
        this.updatePositionAndDirection(0.0);
    }

    public /* synthetic */ PathWalker2(ShapeContour shapeContour, double d, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d = 1.0;
        }
        this(shapeContour, d);
    }
}

