/*
 * Decompiled with CFR 0.152.
 */
package scenes;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import modeling.OBJLoaderKt;
import modeling.Triangle;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexFormat;
import org.openrndr.math.Matrix44;
import scenes.Crowd;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lscenes/Crowd;", "", "()V", "irradiance", "Lorg/openrndr/draw/Cubemap;", "getIrradiance", "()Lorg/openrndr/draw/Cubemap;", "persons", "", "Lorg/openrndr/draw/VertexBuffer;", "getPersons", "()Ljava/util/List;", "previousModelView", "Lorg/openrndr/math/Matrix44;", "getPreviousModelView", "()Lorg/openrndr/math/Matrix44;", "setPreviousModelView", "(Lorg/openrndr/math/Matrix44;)V", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "lightMap", "Lorg/openrndr/draw/ColorBuffer;", "lightProj", "lightView", "drawShadow", "demo-strap"})
public final class Crowd {
    @NotNull
    private final List<VertexBuffer> persons;
    @NotNull
    private final Cubemap irradiance;
    @NotNull
    private Matrix44 previousModelView;

    @NotNull
    public final List<VertexBuffer> getPersons() {
        return this.persons;
    }

    @NotNull
    public final Cubemap getIrradiance() {
        return this.irradiance;
    }

    @NotNull
    public final Matrix44 getPreviousModelView() {
        return this.previousModelView;
    }

    public final void setPreviousModelView(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.previousModelView = matrix44;
    }

    public final void drawShadow(@NotNull Drawer drawer) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, drawer){
            final /* synthetic */ Crowd this$0;
            final /* synthetic */ Drawer $drawer;

            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.$drawer.setShadeStyle(ShadeStyleKt.shadeStyle(drawShadow.1.INSTANCE));
                for (VertexBuffer person : this.this$0.getPersons()) {
                    Drawer.vertexBuffer$default($receiver, person, DrawPrimitive.TRIANGLES, 0, 0, 12, null);
                }
            }
            {
                this.this$0 = crowd;
                this.$drawer = drawer;
                super(1);
            }
        });
    }

    public final void draw(@NotNull Drawer drawer, @NotNull ColorBuffer lightMap2, @NotNull Matrix44 lightProj, @NotNull Matrix44 lightView) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(lightMap2, "lightMap");
        Intrinsics.checkParameterIsNotNull(lightProj, "lightProj");
        Intrinsics.checkParameterIsNotNull(lightView, "lightView");
        RenderTarget gbuffer = RenderTarget.Companion.getActive();
        DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, drawer, gbuffer, lightView, lightProj, lightMap2){
            final /* synthetic */ Crowd this$0;
            final /* synthetic */ Drawer $drawer;
            final /* synthetic */ RenderTarget $gbuffer;
            final /* synthetic */ Matrix44 $lightView;
            final /* synthetic */ Matrix44 $lightProj;
            final /* synthetic */ ColorBuffer $lightMap;

            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.$drawer.setShadeStyle(ShadeStyleKt.shadeStyle((Function1<? super ShadeStyle, Unit>)new Function1<ShadeStyle, Unit>(this){
                    final /* synthetic */ draw.1 this$0;

                    public final void invoke(@NotNull ShadeStyle $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        $receiver.setVertexPreamble("\n                    out vec4 previousView;\n                    out vec4 previousClip;\n                    out vec4 currentClip;\n                ");
                        $receiver.setFragmentPreamble("\n                    in vec4 previousView;\n                    in vec4 previousClip;\n                    in vec4 currentClip;\n                ");
                        $receiver.setVertexTransform("\n                    previousView = (p_previousModelView * vec4(x_position,1.0));\n                    previousClip = u_projectionMatrix * previousView;\n                    currentClip = u_projectionMatrix * u_viewMatrix * u_modelMatrix * vec4(x_position, 1.0);\n                ");
                        $receiver.setFragmentTransform("\n                    x_fill.rgb = pow(texture(p_irradiance, normalize(v_worldNormal)).rgb, vec3(2.2))*0.5;\n\n\n                   vec4 lightClip = p_lightProj * p_lightView * vec4(v_worldPosition, 1.0);\n                    vec3 lightPersp = (lightClip.xyz / lightClip.w) * 0.5 + 0.5;\n\n                    vec4 lightRef  = p_lightView * vec4(v_worldPosition, 1.0);\n                    vec4 positionOfLight = inverse(p_lightView)* vec4(0.0,0.0,0.0,1.0);\n\n\n                    vec3 d = normalize(positionOfLight.xyz);// - v_worldPosition);\n                    float dd = max(0.0, dot(d, normalize(v_worldNormal)));\n                    float bias = max(0.5* (1.0 - dd), 0.1);\n\n\n\n\n                    vec2 step = 1.0 / textureSize(p_lightMap, 0 );\n\n                    float sum = 0;\n                    for (int j = -2; j <=2 ;++j) {\n                    for (int i = -2; i <=2; ++i) {\n                        vec3 lightPos = texture(p_lightMap, lightPersp.xy + vec2(i,j)*step).rgb;\n                            if (lightPos.z < 0 && lightPos.z-bias > lightRef.z) {\n                                sum += 1.0;\n                             }\n                        }\n                    }\n                    x_fill.rgb *= vec3( (1.0 - 0.5 * sum/25.0) );\n\n                    //x_fill.rgb = vec3(0.1, 0.0, 0.0) + vec3( max(0.0, v_worldNormal.y));\n                    o_normal.xyz = v_viewNormal;\n                    o_normal.w = 1.0;\n                    o_position.xyz = v_viewPosition;\n                    o_position.w = 0.1;\n                    o_velocity.xy = (currentClip/currentClip.w - previousClip/previousClip.w).xy*vec2(1280, 720)*0.08;\n                    ");
                        $receiver.output("position", this.this$0.$gbuffer.colorBufferIndex("position"));
                        $receiver.output("normal", this.this$0.$gbuffer.colorBufferIndex("normal"));
                        $receiver.output("velocity", this.this$0.$gbuffer.colorBufferIndex("velocity"));
                        $receiver.parameter("lightView", this.this$0.$lightView);
                        $receiver.parameter("lightProj", this.this$0.$lightProj);
                        $receiver.parameter("lightMap", this.this$0.$lightMap);
                        $receiver.parameter("irradiance", this.this$0.this$0.getIrradiance());
                        $receiver.parameter("previousModelView", this.this$0.this$0.getPreviousModelView());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                $receiver.setFill(ColorRGBa.Companion.getRED());
                for (VertexBuffer person : this.this$0.getPersons()) {
                    Drawer.vertexBuffer$default($receiver, person, DrawPrimitive.TRIANGLES, 0, 0, 12, null);
                }
                this.this$0.setPreviousModelView(this.$drawer.getView().times(this.$drawer.getModel()));
            }
            {
                this.this$0 = crowd;
                this.$drawer = drawer;
                this.$gbuffer = renderTarget;
                this.$lightView = matrix44;
                this.$lightProj = matrix442;
                this.$lightMap = colorBuffer;
                super(1);
            }
        });
    }

    public Crowd() {
        List list;
        Crowd crowd = this;
        crowd.persons = list = (List)new ArrayList();
        this.irradiance = Cubemap.Companion.fromUrl("file:data/textures/garage_iem.dds");
        this.previousModelView = Matrix44.Companion.getIDENTITY();
        Map<String, List<Triangle>> meshes = OBJLoaderKt.loadOBJfromLZMA(new URL("file:data/meshes/crowd.obj.lzma"));
        VertexFormat format2 = DrawerKt.vertexFormat(format.1.INSTANCE);
        for (final List<Triangle> mesh2 : meshes.values()) {
            VertexBuffer person = DrawerKt.vertexBuffer(format2, mesh2.size() * 3);
            person.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void invoke(@NotNull BufferWriter $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                    Iterable $receiver$iv = mesh2;
                    for (Object element$iv : $receiver$iv) {
                        Triangle it2 = (Triangle)element$iv;
                        int n2 = 0;
                        int n3 = 3;
                        while (n2 < n3) {
                            void i;
                            $receiver.write(it2.getPositions()[i].div(50.0));
                            $receiver.write(it2.getNormals()[i]);
                            ++i;
                        }
                    }
                }
            });
            this.persons.add(person);
        }
    }
}

