/*
 * Decompiled with CFR 0.152.
 */
package scenes;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import modeling.ModelingKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.DepthTestPass;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexFormat;
import org.openrndr.draw.WrapMode;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;
import scenes.CrawlersBase;
import scenes.CrawlersKt;
import scenes.RenderStyle;
import scenes.Walker;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J,\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lscenes/CrawlersBase;", "", "width", "", "depth", "(DD)V", "body", "Lorg/openrndr/draw/VertexBuffer;", "getBody", "()Lorg/openrndr/draw/VertexBuffer;", "format", "Lorg/openrndr/draw/VertexFormat;", "getFormat", "()Lorg/openrndr/draw/VertexFormat;", "irradiance", "Lorg/openrndr/draw/Cubemap;", "getIrradiance", "()Lorg/openrndr/draw/Cubemap;", "normalMap", "Lorg/openrndr/draw/ColorBuffer;", "getNormalMap", "()Lorg/openrndr/draw/ColorBuffer;", "walkers", "", "Lscenes/Walker;", "getWalkers", "()Ljava/util/List;", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "time", "renderStyle", "Lscenes/RenderStyle;", "update", "", "drawShadow", "demo-strap"})
public class CrawlersBase {
    @NotNull
    private final Cubemap irradiance;
    @NotNull
    private final ColorBuffer normalMap;
    @NotNull
    private final List<Walker> walkers;
    @NotNull
    private final VertexBuffer body;
    @NotNull
    private final VertexFormat format;

    @NotNull
    public final Cubemap getIrradiance() {
        return this.irradiance;
    }

    @NotNull
    public final ColorBuffer getNormalMap() {
        return this.normalMap;
    }

    @NotNull
    public final List<Walker> getWalkers() {
        return this.walkers;
    }

    @NotNull
    public final VertexBuffer getBody() {
        return this.body;
    }

    @NotNull
    public final VertexFormat getFormat() {
        return this.format;
    }

    public void drawShadow(@NotNull Drawer drawer, double time) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, drawer, time){
            final /* synthetic */ CrawlersBase this$0;
            final /* synthetic */ Drawer $drawer;
            final /* synthetic */ double $time;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.$drawer.setDepthWrite(true);
                this.$drawer.setDepthTestPass(DepthTestPass.LESS_OR_EQUAL);
                this.$drawer.setShadeStyle(ShadeStyleKt.shadeStyle(drawShadow.1.INSTANCE));
                Iterable $receiver$iv = this.this$0.getWalkers();
                int index$iv = 0;
                for (T item$iv : $receiver$iv) {
                    void it2;
                    int n2 = index$iv++;
                    Walker walker = (Walker)item$iv;
                    int index = n2;
                    it2.update(this.$time);
                    ShadeStyle shadeStyle = this.$drawer.getShadeStyle();
                    if (shadeStyle != null) {
                        shadeStyle.parameter("id", (float)index);
                    }
                    CrawlersKt.access$drawNode(this.$drawer, it2.getRoot());
                }
            }
            {
                this.this$0 = crawlersBase;
                this.$drawer = drawer;
                this.$time = d;
                super(1);
            }
        });
    }

    public void draw(@NotNull Drawer drawer, double time, @NotNull RenderStyle renderStyle, boolean update2) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(renderStyle, "renderStyle");
        RenderTarget gbuffer = RenderTarget.Companion.getActive();
        DrawerKt.isolated(drawer, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this, drawer, renderStyle, time, gbuffer, update2){
            final /* synthetic */ CrawlersBase this$0;
            final /* synthetic */ Drawer $drawer;
            final /* synthetic */ RenderStyle $renderStyle;
            final /* synthetic */ double $time;
            final /* synthetic */ RenderTarget $gbuffer;
            final /* synthetic */ boolean $update;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                this.$drawer.setDepthWrite(true);
                this.$drawer.setDepthTestPass(DepthTestPass.LESS_OR_EQUAL);
                this.$drawer.setShadeStyle(ShadeStyleKt.shadeStyle((Function1<? super ShadeStyle, Unit>)new Function1<ShadeStyle, Unit>(this){
                    final /* synthetic */ draw.1 this$0;

                    public final void invoke(@NotNull ShadeStyle $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        $receiver.setVertexPreamble("\n                    out vec4 previousView;\n                    out vec4 previousClip;\n                    out vec4 currentClip;\n                ");
                        $receiver.setFragmentPreamble("\n                    in vec4 previousView;\n                    in vec4 previousClip;\n                    in vec4 currentClip;\n\n                    #define HASHSCALE 443.8975\n                    vec2 hash22(vec2 p) {\n\t                    vec3 p3 = fract(vec3(p.xyx) * HASHSCALE);\n                        p3 += dot(p3, p3.yzx+19.19);\n                        return fract(vec2((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y));\n                    }\n                ");
                        $receiver.setVertexTransform("\n                    previousView = (p_previousModelView * vec4(x_position,1.0));\n                    previousClip = u_projectionMatrix * previousView;\n                    currentClip = u_projectionMatrix * u_viewMatrix * u_modelMatrix * vec4(x_position, 1.0);\n                ");
                        $receiver.setFragmentTransform("\n\n                    vec2 uv = va_position.xz*0.1;\n//                    vec3 normal = normalize(texture(p_normalMap, uv).xzy - vec3(0.5, 0.5, 0.5));\n\n                    mat3 tbn = mat3(u_modelNormalMatrix * u_viewNormalMatrix);\n                    mat3 tbnW = mat3(u_modelNormalMatrix);\n\n                    x_fill.rgb += max(0.0, v_worldNormal.y);\n                    x_fill.rgb = pow(texture(p_irradiance, normalize(v_worldNormal)).rgb, vec3(2.2))*vec3(0.4, 0.05, 0.02) * 20.0; //*(11.0 + 9.0*cos(p_id+p_time*4.0));\n                    x_fill.a = 1.0;\n                    o_position.xyz = v_viewPosition.xyz;\n                    o_position.w = 1.0;\n                    o_normal.xyz = v_viewNormal.xyz;\n                    o_normal.w = 1.0;\n                    o_velocity.xy = (currentClip/currentClip.w - previousClip/previousClip.w).xy*vec2(1280, 720) * 0.08; //p_velocityScale;\n//                    o_velocity.z = 0.cos(p_id + p_time*5.0 + va_position.y*3.0) * 0.5 + 0.5;\n\n//                                        x_fill *= max(1.0 + v_viewPosition.z/100.0, 0.0);\n\n                ");
                        this.this$0.this$0.getNormalMap().setWrapV(WrapMode.REPEAT);
                        this.this$0.this$0.getNormalMap().setWrapU(WrapMode.REPEAT);
                        $receiver.parameter("irradiance", this.this$0.this$0.getIrradiance());
                        $receiver.parameter("normalMap", this.this$0.this$0.getNormalMap());
                        $receiver.parameter("time", Math.random());
                        $receiver.parameter("velocityScale", this.this$0.$renderStyle.getVelocityScale());
                        $receiver.parameter("time", this.this$0.$time);
                        $receiver.parameter("id", 0.0);
                        $receiver.output("position", this.this$0.$gbuffer.colorBufferIndex("position"));
                        $receiver.output("normal", this.this$0.$gbuffer.colorBufferIndex("normal"));
                        $receiver.output("velocity", this.this$0.$gbuffer.colorBufferIndex("velocity"));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                Iterable $receiver$iv = this.this$0.getWalkers();
                int index$iv = 0;
                for (T item$iv : $receiver$iv) {
                    void it2;
                    int n2 = index$iv++;
                    Walker walker = (Walker)item$iv;
                    int index = n2;
                    if (this.$update) {
                        it2.update(this.$time);
                    }
                    ShadeStyle shadeStyle = this.$drawer.getShadeStyle();
                    if (shadeStyle != null) {
                        shadeStyle.parameter("id", (float)index);
                    }
                    CrawlersKt.access$drawNode(this.$drawer, it2.getRoot());
                }
            }
            {
                this.this$0 = crawlersBase;
                this.$drawer = drawer;
                this.$renderStyle = renderStyle;
                this.$time = d;
                this.$gbuffer = renderTarget;
                this.$update = bl;
                super(1);
            }
        });
    }

    public static /* bridge */ /* synthetic */ void draw$default(CrawlersBase crawlersBase, Drawer drawer, double d, RenderStyle renderStyle, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: draw");
        }
        if ((n2 & 4) != 0) {
            renderStyle = new RenderStyle();
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        crawlersBase.draw(drawer, d, renderStyle, bl);
    }

    public CrawlersBase(double width, double depth) {
        List list;
        this.irradiance = Cubemap.Companion.fromUrl("file:data/textures/garage_iem.dds");
        this.normalMap = ColorBuffer.Companion.fromUrl("file:data/textures/ground_normal.png");
        CrawlersBase crawlersBase = this;
        crawlersBase.walkers = list = (List)new ArrayList();
        this.format = DrawerKt.vertexFormat(format.1.INSTANCE);
        this.body = DrawerKt.vertexBuffer(this.format, 100);
        ModelingKt.extrudeContour(new Rectangle(new Vector2(-2.0, -1.5), 4.0, 1.0).getContour(), 4.0, 0.0, this.body.getShadow().writer(), true, true, -2.0);
        this.body.getShadow().writer().rewind();
        VertexBufferShadow.DefaultImpls.upload$default(this.body.getShadow(), 0, 0, 3, null);
    }

    public /* synthetic */ CrawlersBase(double d, double d2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            d = 50.0;
        }
        if ((n2 & 2) != 0) {
            d2 = 50.0;
        }
        this(d, d2);
    }

    public CrawlersBase() {
        this(0.0, 0.0, 3, null);
    }
}

