/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003H\u0086\u0002J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0014\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006)"}, d2={"Lorg/openrndr/math/Vector4;", "Ljava/io/Serializable;", "x", "", "y", "z", "w", "(DDDD)V", "div", "Lorg/openrndr/math/Vector3;", "getDiv", "()Lorg/openrndr/math/Vector3;", "length", "getLength", "()D", "normalized", "getNormalized", "()Lorg/openrndr/math/Vector4;", "getW", "getX", "xyz", "getXyz", "getY", "getZ", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "times", "s", "toString", "", "unaryMinus", "Companion", "openrndr-math"})
public final class Vector4
implements Serializable {
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    @NotNull
    private static final Vector4 UNIT_X;
    @NotNull
    private static final Vector4 UNIT_Y;
    @NotNull
    private static final Vector4 UNIT_Z;
    @NotNull
    private static final Vector4 UNIT_W;
    @NotNull
    private static final Vector4 ZERO;
    @NotNull
    private static final Vector4 ONE;
    public static final Companion Companion;

    @NotNull
    public final Vector3 getXyz() {
        return new Vector3(this.x, this.y, this.z);
    }

    @NotNull
    public final Vector3 getDiv() {
        return new Vector3(this.x / this.w, this.y / this.w, this.z / this.w);
    }

    public final double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    @NotNull
    public final Vector4 getNormalized() {
        double d;
        double it2 = d = this.getLength();
        return new Vector4(this.x / it2, this.y / it2, this.z / it2, this.w / it2);
    }

    @NotNull
    public final Vector4 unaryMinus() {
        return new Vector4(-this.x, -this.y, -this.z, -this.w);
    }

    @NotNull
    public final Vector4 times(double s) {
        return new Vector4(this.x * s, this.y * s, this.z * s, this.w * s);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getW() {
        return this.w;
    }

    public Vector4(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    static {
        Companion = new Companion(null);
        UNIT_X = new Vector4(1.0, 0.0, 0.0, 0.0);
        UNIT_Y = new Vector4(0.0, 1.0, 0.0, 0.0);
        UNIT_Z = new Vector4(0.0, 0.0, 1.0, 0.0);
        UNIT_W = new Vector4(0.0, 0.0, 0.0, 1.0);
        ZERO = new Vector4(0.0, 0.0, 0.0, 0.0);
        ONE = new Vector4(1.0, 1.0, 1.0, 1.0);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    public final double component4() {
        return this.w;
    }

    @NotNull
    public final Vector4 copy(double x, double y, double z, double w) {
        return new Vector4(x, y, z, w);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Vector4 copy$default(Vector4 vector4, double d, double d2, double d3, double d4, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = vector4.x;
        }
        if ((n2 & 2) != 0) {
            d2 = vector4.y;
        }
        if ((n2 & 4) != 0) {
            d3 = vector4.z;
        }
        if ((n2 & 8) != 0) {
            d4 = vector4.w;
        }
        return vector4.copy(d, d2, d3, d4);
    }

    public String toString() {
        return "Vector4(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + ")";
    }

    public int hashCode() {
        return ((Double.hashCode(this.x) * 31 + Double.hashCode(this.y)) * 31 + Double.hashCode(this.z)) * 31 + Double.hashCode(this.w);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vector4)) break block3;
                Vector4 vector4 = (Vector4)object;
                if (Double.compare(this.x, vector4.x) != 0 || Double.compare(this.y, vector4.y) != 0 || Double.compare(this.z, vector4.z) != 0 || Double.compare(this.w, vector4.w) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/openrndr/math/Vector4$Companion;", "", "()V", "ONE", "Lorg/openrndr/math/Vector4;", "getONE", "()Lorg/openrndr/math/Vector4;", "UNIT_W", "getUNIT_W", "UNIT_X", "getUNIT_X", "UNIT_Y", "getUNIT_Y", "UNIT_Z", "getUNIT_Z", "ZERO", "getZERO", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final Vector4 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final Vector4 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final Vector4 getUNIT_Z() {
            return UNIT_Z;
        }

        @NotNull
        public final Vector4 getUNIT_W() {
            return UNIT_W;
        }

        @NotNull
        public final Vector4 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector4 getONE() {
            return ONE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

