/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.url;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/openrndr/internal/url/ClassPathHandler;", "Ljava/net/URLStreamHandler;", "()V", "classLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "openConnection", "Ljava/net/URLConnection;", "u", "Ljava/net/URL;", "openrndr-gl3"})
public final class ClassPathHandler
extends URLStreamHandler {
    private final ClassLoader classLoader;

    @Override
    @NotNull
    protected URLConnection openConnection(@NotNull URL u) throws IOException {
        Intrinsics.checkParameterIsNotNull(u, "u");
        URL uRL = this.classLoader.getResource(u.getPath());
        if (uRL == null) {
            throw (Throwable)new IOException("resource not found: " + u.getPath());
        }
        URL resourceUrl = uRL;
        URLConnection uRLConnection = resourceUrl.openConnection();
        Intrinsics.checkExpressionValueIsNotNull(uRLConnection, "resourceUrl.openConnection()");
        return uRLConnection;
    }

    public ClassPathHandler() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Intrinsics.checkExpressionValueIsNotNull(classLoader, "javaClass.classLoader");
        this.classLoader = classLoader;
    }

    public ClassPathHandler(@NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull(classLoader, "classLoader");
        this.classLoader = classLoader;
    }
}

