/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J \u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J(\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J \u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020 H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020!H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\"H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020#H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\u000f\u00a8\u0006%"}, d2={"Lorg/openrndr/internal/gl3/BufferWriterGL3;", "Lorg/openrndr/draw/BufferWriter;", "buffer", "Ljava/nio/ByteBuffer;", "elementSize", "", "(Ljava/nio/ByteBuffer;I)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "getElementSize", "()I", "value", "position", "getPosition", "setPosition", "(I)V", "positionElements", "getPositionElements", "setPositionElements", "rewind", "", "write", "v", "", "x", "y", "z", "w", "a", "", "offset", "size", "Lorg/openrndr/color/ColorRGBa;", "Lorg/openrndr/math/Matrix44;", "Lorg/openrndr/math/Vector2;", "Lorg/openrndr/math/Vector3;", "Lorg/openrndr/math/Vector4;", "openrndr-gl3"})
public final class BufferWriterGL3
implements BufferWriter {
    @NotNull
    private final ByteBuffer buffer;
    private final int elementSize;

    @Override
    public void write(@NotNull float[] a, int offset, int size) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        this.buffer.asFloatBuffer().put(a, offset, size);
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).position(this.buffer.position() + size * 4);
    }

    @Override
    public void write(@NotNull Vector3 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.buffer.putFloat((float)v.getX());
        this.buffer.putFloat((float)v.getY());
        this.buffer.putFloat((float)v.getZ());
    }

    @Override
    public void write(@NotNull Vector2 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.buffer.putFloat((float)v.getX());
        this.buffer.putFloat((float)v.getY());
    }

    @Override
    public void write(@NotNull Vector4 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.buffer.putFloat((float)v.getX());
        this.buffer.putFloat((float)v.getY());
        this.buffer.putFloat((float)v.getZ());
        this.buffer.putFloat((float)v.getW());
    }

    @Override
    public void write(@NotNull Matrix44 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.buffer.putFloat((float)v.getC0r0());
        this.buffer.putFloat((float)v.getC0r1());
        this.buffer.putFloat((float)v.getC0r2());
        this.buffer.putFloat((float)v.getC0r3());
        this.buffer.putFloat((float)v.getC1r0());
        this.buffer.putFloat((float)v.getC1r1());
        this.buffer.putFloat((float)v.getC1r2());
        this.buffer.putFloat((float)v.getC1r3());
        this.buffer.putFloat((float)v.getC2r0());
        this.buffer.putFloat((float)v.getC2r1());
        this.buffer.putFloat((float)v.getC2r2());
        this.buffer.putFloat((float)v.getC2r3());
        this.buffer.putFloat((float)v.getC3r0());
        this.buffer.putFloat((float)v.getC3r1());
        this.buffer.putFloat((float)v.getC3r2());
        this.buffer.putFloat((float)v.getC3r3());
    }

    @Override
    public void write(float v) {
        this.buffer.putFloat(v);
    }

    @Override
    public void write(float x, float y, float z) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.buffer.putFloat(z);
    }

    @Override
    public void write(float x, float y, float z, float w) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
        this.buffer.putFloat(z);
        this.buffer.putFloat(w);
    }

    @Override
    public void write(float x, float y) {
        this.buffer.putFloat(x);
        this.buffer.putFloat(y);
    }

    @Override
    public void write(@NotNull ColorRGBa v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        this.buffer.putFloat((float)v.getR());
        this.buffer.putFloat((float)v.getG());
        this.buffer.putFloat((float)v.getB());
        this.buffer.putFloat((float)v.getA());
    }

    @Override
    public int getPosition() {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        return ((Buffer)byteBuffer).position();
    }

    @Override
    public void setPosition(int value) {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).position(value);
    }

    @Override
    public int getPositionElements() {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        return ((Buffer)byteBuffer).position() / this.elementSize;
    }

    @Override
    public void setPositionElements(int value) {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).position(value * this.elementSize);
    }

    @Override
    public void rewind() {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)byteBuffer).rewind();
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final int getElementSize() {
        return this.elementSize;
    }

    public BufferWriterGL3(@NotNull ByteBuffer buffer, int elementSize) {
        Intrinsics.checkParameterIsNotNull(buffer, "buffer");
        this.buffer = buffer;
        this.elementSize = elementSize;
        this.buffer.order(ByteOrder.nativeOrder());
    }

    public /* synthetic */ BufferWriterGL3(ByteBuffer byteBuffer, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        this(byteBuffer, n2);
    }

    @Override
    public void write(Vector3 ... v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        BufferWriter.DefaultImpls.write(this, v);
    }
}

