/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.File;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowPosCallbackI;
import org.lwjgl.glfw.GLFWWindowRefreshCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryStack;
import org.openrndr.Application;
import org.openrndr.Configuration;
import org.openrndr.DropEvent;
import org.openrndr.KeyEvent;
import org.openrndr.KeyEventType;
import org.openrndr.KeyboardModifier;
import org.openrndr.MouseButton;
import org.openrndr.MouseEventType;
import org.openrndr.Program;
import org.openrndr.UnfocusBehaviour;
import org.openrndr.WindowEvent;
import org.openrndr.WindowEventType;
import org.openrndr.draw.Drawer;
import org.openrndr.events.Event;
import org.openrndr.internal.Driver;
import org.openrndr.internal.gl3.ApplicationGL3;
import org.openrndr.internal.gl3.ApplicationGL3Kt;
import org.openrndr.internal.gl3.DriverGL3;
import org.openrndr.internal.gl3.ProgramRenderTargetGL3;
import org.openrndr.math.IntVector2;
import org.openrndr.math.Vector2;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J>\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u001aJ\b\u00102\u001a\u00020)H\u0002J\n\u00103\u001a\u0004\u0018\u000104H\u0002J\b\u00105\u001a\u00020)H\u0016J\b\u00106\u001a\u00020)H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010:\u001a\u00020+H\u0002J\u0006\u0010;\u001a\u00020)J\b\u0010<\u001a\u00020)H\u0016J\b\u0010=\u001a\u00020)H\u0002R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\u001f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R$\u0010%\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u000b\"\u0004\b'\u0010\r\u00a8\u0006>"}, d2={"Lorg/openrndr/internal/gl3/ApplicationGL3;", "Lorg/openrndr/Application;", "program", "Lorg/openrndr/Program;", "configuration", "Lorg/openrndr/Configuration;", "(Lorg/openrndr/Program;Lorg/openrndr/Configuration;)V", "value", "", "clipboardContents", "getClipboardContents", "()Ljava/lang/String;", "setClipboardContents", "(Ljava/lang/String;)V", "driver", "Lorg/openrndr/internal/gl3/DriverGL3;", "exitRequested", "", "fixWindowSize", "realWindowTitle", "seconds", "", "getSeconds", "()D", "setupCalled", "startTimeMillis", "", "vaos", "", "window", "windowFocused", "Lorg/openrndr/math/Vector2;", "windowPosition", "getWindowPosition", "()Lorg/openrndr/math/Vector2;", "setWindowPosition", "(Lorg/openrndr/math/Vector2;)V", "windowTitle", "getWindowTitle", "setWindowTitle", "cb", "", "source", "", "type", "id", "severity", "length", "message", "userParam", "createPrimaryWindow", "drawFrame", "", "exit", "loop", "modifierSet", "", "Lorg/openrndr/KeyboardModifier;", "mods", "preloop", "setup", "setupSizes", "openrndr-gl3"})
public final class ApplicationGL3
extends Application {
    private boolean windowFocused;
    private long window;
    private DriverGL3 driver;
    private String realWindowTitle;
    private boolean exitRequested;
    private final boolean fixWindowSize;
    private boolean setupCalled;
    private long startTimeMillis;
    private final int[] vaos;
    private final Program program;
    private final Configuration configuration;

    @Override
    @NotNull
    public Vector2 getWindowPosition() {
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetWindowPos(this.window, x, y);
        return new Vector2(this.fixWindowSize ? (double)x[0] / this.program.getWindow().getScale().getX() : (double)x[0], this.fixWindowSize ? (double)y[0] / this.program.getWindow().getScale().getY() : (double)y[0]);
    }

    @Override
    public void setWindowPosition(@NotNull Vector2 value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        GLFW.glfwSetWindowPos(this.window, this.fixWindowSize ? (int)(value.getX() * this.program.getWindow().getScale().getX()) : (int)value.getX(), this.fixWindowSize ? (int)(value.getY() * this.program.getWindow().getScale().getY()) : (int)value.getY());
    }

    @Override
    @Nullable
    public String getClipboardContents() {
        String string;
        try {
            String result = GLFW.glfwGetClipboardString(this.window);
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    @Override
    public void setClipboardContents(@Nullable String value) {
        if (value == null) {
            throw (Throwable)new RuntimeException("clipboard contents can't be null");
        }
        GLFW.glfwSetClipboardString(this.window, value);
    }

    @Override
    public double getSeconds() {
        return (double)(System.currentTimeMillis() - this.startTimeMillis) / 1000.0;
    }

    @Override
    @NotNull
    public String getWindowTitle() {
        return this.realWindowTitle;
    }

    @Override
    public void setWindowTitle(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        GLFW.glfwSetWindowTitle(this.window, value);
        this.realWindowTitle = value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setup() {
        void readyFrames;
        long l;
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(139266, 3);
        GLFW.glfwWindowHint(139267, 3);
        GLFW.glfwWindowHint(139270, 1);
        GLFW.glfwWindowHint(139272, 204801);
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, this.configuration.getWindowResizable() ? 1 : 0);
        GLFW.glfwWindowHint(131077, this.configuration.getHideWindowDecorations() ? 0 : 1);
        GLFW.glfwWindowHint(135169, 8);
        GLFW.glfwWindowHint(135170, 8);
        GLFW.glfwWindowHint(135171, 8);
        GLFW.glfwWindowHint(135174, 8);
        GLFW.glfwWindowHint(135173, 24);
        String string = GLFW.glfwGetVersionString();
        System.out.println((Object)string);
        float[] xscale = new float[1];
        float[] yscale = new float[1];
        GLFW.glfwGetMonitorContentScale(GLFW.glfwGetPrimaryMonitor(), xscale, yscale);
        if (this.configuration.getFullscreen()) {
            xscale[0] = 1.0f;
            yscale[0] = 1.0f;
        }
        ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(xscale, yscale){
            final /* synthetic */ float[] $xscale;
            final /* synthetic */ float[] $yscale;

            @NotNull
            public final String invoke() {
                return "content scale " + this.$xscale[0] + ' ' + this.$yscale[0];
            }
            {
                this.$xscale = fArray;
                this.$yscale = fArray2;
                super(0);
            }
        });
        this.program.getWindow().setScale(new Vector2(xscale[0], yscale[0]));
        ApplicationGL3Kt.access$getLogger$p().debug(setup.2.INSTANCE);
        if (!this.configuration.getFullscreen()) {
            int adjustedWidth = this.fixWindowSize ? (int)(xscale[0] * (float)this.configuration.getWidth()) : this.configuration.getWidth();
            int adjustedHeight = this.fixWindowSize ? (int)(yscale[0] * (float)this.configuration.getHeight()) : this.configuration.getHeight();
            l = GLFW.glfwCreateWindow(adjustedWidth, adjustedHeight, this.configuration.getTitle(), 0L, ApplicationGL3Kt.access$getPrimaryWindow$p());
        } else {
            ApplicationGL3Kt.access$getLogger$p().info(setup.3.INSTANCE);
            int requestWidth = this.configuration.getWidth();
            int requestHeight = this.configuration.getHeight();
            if (requestWidth == -1 || requestHeight == -1) {
                GLFWVidMode mode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
                if (mode != null) {
                    requestWidth = mode.width();
                    requestHeight = mode.height();
                } else {
                    throw (Throwable)new RuntimeException("failed to determine current video mode");
                }
            }
            l = GLFW.glfwCreateWindow(requestWidth, requestHeight, this.configuration.getTitle(), GLFW.glfwGetPrimaryMonitor(), ApplicationGL3Kt.access$getPrimaryWindow$p());
        }
        this.window = l;
        ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(this){
            final /* synthetic */ ApplicationGL3 this$0;

            @NotNull
            public final String invoke() {
                return "window created: " + ApplicationGL3.access$getWindow$p(this.this$0);
            }
            {
                this.this$0 = applicationGL3;
                super(0);
            }
        });
        if (this.window == 0L) {
            throw (Throwable)new RuntimeException("Failed to create the GLFW window");
        }
        Object requestWidth = MemoryStack.stackPush();
        MemoryStack stack = requestWidth;
        IntBuffer pWidth = stack.mallocInt(1);
        IntBuffer pHeight = stack.mallocInt(1);
        GLFW.glfwGetWindowSize(this.window, pWidth, pHeight);
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        if (this.configuration.getPosition() == null) {
            if (vidmode != null) {
                GLFW.glfwSetWindowPos(this.window, (vidmode.width() - pWidth.get(0)) / 2, (vidmode.height() - pHeight.get(0)) / 2);
            }
        } else {
            IntVector2 intVector2 = this.configuration.getPosition();
            if (intVector2 != null) {
                IntVector2 intVector22;
                IntVector2 it2 = intVector22 = intVector2;
                GLFW.glfwSetWindowPos(this.window, it2.getX(), it2.getY());
            }
        }
        ApplicationGL3Kt.access$getLogger$p().debug(setup.6.INSTANCE);
        GLFW.glfwMakeContextCurrent(this.window);
        GLFW.glfwSwapInterval(1);
        requestWidth = new Ref.IntRef();
        ((Ref.IntRef)requestWidth).element = 0;
        GLFW.glfwSetWindowRefreshCallback(this.window, new GLFWWindowRefreshCallbackI(this, (Ref.IntRef)readyFrames){
            final /* synthetic */ ApplicationGL3 this$0;
            final /* synthetic */ Ref.IntRef $readyFrames;

            public final void invoke(long it2) {
                if (this.$readyFrames.element > 0) {
                    if (ApplicationGL3.access$getSetupCalled$p(this.this$0)) {
                        ApplicationGL3.access$drawFrame(this.this$0);
                    }
                    GLFW.glfwSwapBuffers(ApplicationGL3.access$getWindow$p(this.this$0));
                }
                int n2 = this.$readyFrames.element;
                this.$readyFrames.element = n2 + 1;
            }
            {
                this.this$0 = applicationGL3;
                this.$readyFrames = intRef;
            }
        });
        GLFW.glfwSetFramebufferSizeCallback(this.window, new GLFWFramebufferSizeCallbackI(this, (Ref.IntRef)readyFrames){
            final /* synthetic */ ApplicationGL3 this$0;
            final /* synthetic */ Ref.IntRef $readyFrames;

            public final void invoke(long window, int width, int height) {
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(width, height){
                    final /* synthetic */ int $width;
                    final /* synthetic */ int $height;

                    @NotNull
                    public final String invoke() {
                        return "resizing window to " + this.$width + 'x' + this.$height + ' ';
                    }
                    {
                        this.$width = n2;
                        this.$height = n3;
                        super(0);
                    }
                });
                if (this.$readyFrames.element > 0) {
                    ApplicationGL3.access$setupSizes(this.this$0);
                    ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getSized().trigger(new WindowEvent(WindowEventType.RESIZED, ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getPosition(), ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getSize(), true));
                }
                int n2 = this.$readyFrames.element;
                this.$readyFrames.element = n2 + 1;
                ApplicationGL3Kt.access$getLogger$p().debug(setup.2.INSTANCE);
            }
            {
                this.this$0 = applicationGL3;
                this.$readyFrames = intRef;
            }
        });
        GLFW.glfwSetWindowPosCallback(this.window, new GLFWWindowPosCallbackI(this){
            final /* synthetic */ ApplicationGL3 this$0;

            public final void invoke(long $noName_0, int x, int y) {
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(x, y){
                    final /* synthetic */ int $x;
                    final /* synthetic */ int $y;

                    @NotNull
                    public final String invoke() {
                        return "window has moved to " + this.$x + ' ' + this.$y;
                    }
                    {
                        this.$x = n2;
                        this.$y = n3;
                        super(0);
                    }
                });
                ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getMoved().trigger(new WindowEvent(WindowEventType.MOVED, new Vector2(x, y), new Vector2(0.0, 0.0), true));
            }
            {
                this.this$0 = applicationGL3;
            }
        });
        GLFW.glfwSetWindowFocusCallback(this.window, new GLFWWindowFocusCallbackI(this){
            final /* synthetic */ ApplicationGL3 this$0;

            public final void invoke(long $noName_0, boolean focused) {
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(focused){
                    final /* synthetic */ boolean $focused;

                    @NotNull
                    public final String invoke() {
                        return "window focus has changed; focused=" + this.$focused;
                    }
                    {
                        this.$focused = bl;
                        super(0);
                    }
                });
                ApplicationGL3.access$setWindowFocused$p(this.this$0, focused);
                if (focused) {
                    ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getFocused().trigger(new WindowEvent(WindowEventType.FOCUSED, new Vector2(0.0, 0.0), new Vector2(0.0, 0.0), true));
                } else {
                    ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getUnfocused().trigger(new WindowEvent(WindowEventType.FOCUSED, new Vector2(0.0, 0.0), new Vector2(0.0, 0.0), false));
                }
            }
            {
                this.this$0 = applicationGL3;
            }
        });
        ApplicationGL3Kt.access$getLogger$p().debug(setup.11.INSTANCE);
        ApplicationGL3Kt.access$getLogger$p().debug(setup.12.INSTANCE);
        GLFW.glfwShowWindow(this.window);
    }

    private final void createPrimaryWindow() {
        if (ApplicationGL3Kt.access$getPrimaryWindow$p() == 0L) {
            GLFW.glfwSetErrorCallback(GLFWErrorCallback.create(createPrimaryWindow.1.INSTANCE));
            if (!GLFW.glfwInit()) {
                throw (Throwable)new IllegalStateException("Unable to initialize GLFW");
            }
            GLFW.glfwDefaultWindowHints();
            GLFW.glfwWindowHint(139266, 3);
            GLFW.glfwWindowHint(139267, 3);
            GLFW.glfwWindowHint(139270, 1);
            GLFW.glfwWindowHint(139272, 204801);
            GLFW.glfwWindowHint(135169, 8);
            GLFW.glfwWindowHint(135170, 8);
            GLFW.glfwWindowHint(135171, 8);
            GLFW.glfwWindowHint(135174, 8);
            GLFW.glfwWindowHint(135173, 24);
            GLFW.glfwWindowHint(131076, 0);
            ApplicationGL3Kt.access$setPrimaryWindow$p(GLFW.glfwCreateWindow(640, 480, "OPENRNDR primary window", 0L, 0L));
        }
    }

    public final void cb(int source, int type, int id, int severity, int length, long message, long userParam) {
        String string = "errorrrr: " + source + ' ' + type + ' ' + severity;
        System.out.println((Object)string);
    }

    public final void preloop() {
        GL.createCapabilities();
        GL30.glGenVertexArrays(this.vaos);
        GL30.glBindVertexArray(this.vaos[0]);
        this.driver = new DriverGL3();
        this.driver.setDefaultVAO(this.vaos[0]);
        this.program.setDriver(this.driver);
        this.program.setDrawer(new Drawer(this.driver));
        this.setupSizes();
        this.program.getDrawer().ortho();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loop() {
        void lastDragPosition;
        void down;
        void globalModifiers;
        Ref.ObjectRef objectRef;
        ApplicationGL3Kt.access$getLogger$p().debug(loop.1.INSTANCE);
        this.preloop();
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = Vector2.Companion.getZERO();
        Ref.ObjectRef objectRef3 = objectRef = new Ref.ObjectRef();
        Set set = SetsKt.emptySet();
        objectRef3.element = set;
        GLFW.glfwSetKeyCallback(this.window, new GLFWKeyCallbackI(this, (Ref.ObjectRef)globalModifiers){
            final /* synthetic */ ApplicationGL3 this$0;
            final /* synthetic */ Ref.ObjectRef $globalModifiers;

            public final void invoke(long $noName_0, int key, int scancode, int action, int mods) {
                Set modifiers = ApplicationGL3.access$modifierSet(this.this$0, mods);
                String string = GLFW.glfwGetKeyName(key, scancode);
                if (string == null) {
                    string = "<null>";
                }
                String name = string;
                this.$globalModifiers.element = modifiers;
                switch (action) {
                    case 1: {
                        Event<KeyEvent> event = ApplicationGL3.access$getProgram$p(this.this$0).getKeyboard().getKeyDown();
                        String string2 = name;
                        Intrinsics.checkExpressionValueIsNotNull(string2, "name");
                        event.trigger(new KeyEvent(KeyEventType.KEY_DOWN, key, scancode, string2, modifiers, false, 32, null));
                        break;
                    }
                    case 0: {
                        Event<KeyEvent> event = ApplicationGL3.access$getProgram$p(this.this$0).getKeyboard().getKeyUp();
                        String string3 = name;
                        Intrinsics.checkExpressionValueIsNotNull(string3, "name");
                        event.trigger(new KeyEvent(KeyEventType.KEY_UP, key, scancode, string3, modifiers, false, 32, null));
                        break;
                    }
                    case 2: {
                        Event<KeyEvent> event = ApplicationGL3.access$getProgram$p(this.this$0).getKeyboard().getKeyRepeat();
                        String string4 = name;
                        Intrinsics.checkExpressionValueIsNotNull(string4, "name");
                        event.trigger(new KeyEvent(KeyEventType.KEY_REPEAT, key, scancode, string4, modifiers, false, 32, null));
                    }
                }
            }
            {
                this.this$0 = applicationGL3;
                this.$globalModifiers = objectRef;
            }
        });
        GLFW.glfwSetDropCallback(this.window, new GLFWDropCallbackI(this){
            final /* synthetic */ ApplicationGL3 this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(long $noName_0, int count, long names) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(count){
                    final /* synthetic */ int $count;

                    @NotNull
                    public final String invoke() {
                        return "" + this.$count + " file(s) have been dropped";
                    }
                    {
                        this.$count = n2;
                        super(0);
                    }
                });
                PointerBuffer pointers = PointerBuffer.create(names, count);
                Iterable iterable = $receiver$iv = (Iterable)RangesKt.until(0, count);
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                Iterator<T> iterator2 = $receiver$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    File file = new File(pointers.getStringUTF8(0));
                    collection.add(file);
                }
                List files = (List)destination$iv$iv;
                ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getDrop().trigger(new DropEvent(new Vector2(0.0, 0.0), files));
            }
            {
                this.this$0 = applicationGL3;
            }
        });
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        GLFW.glfwSetScrollCallback(this.window, new GLFWScrollCallbackI(this, (Ref.ObjectRef)globalModifiers){
            final /* synthetic */ ApplicationGL3 this$0;
            final /* synthetic */ Ref.ObjectRef $globalModifiers;

            public final void invoke(long $noName_0, double xoffset, double yoffset) {
                ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getScrolled().trigger(new Program.Mouse.MouseEvent(ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), new Vector2(xoffset, yoffset), Vector2.Companion.getZERO(), MouseEventType.SCROLLED, MouseButton.NONE, (Set)this.$globalModifiers.element, false, 64, null));
            }
            {
                this.this$0 = applicationGL3;
                this.$globalModifiers = objectRef;
            }
        });
        GLFW.glfwSetMouseButtonCallback(this.window, new GLFWMouseButtonCallbackI(this, (Ref.BooleanRef)down, (Ref.ObjectRef)lastDragPosition){
            final /* synthetic */ ApplicationGL3 this$0;
            final /* synthetic */ Ref.BooleanRef $down;
            final /* synthetic */ Ref.ObjectRef $lastDragPosition;

            public final void invoke(long $noName_0, int button, int action, int mods) {
                MouseButton mouseButton;
                switch (button) {
                    case 0: {
                        mouseButton = MouseButton.LEFT;
                        break;
                    }
                    case 1: {
                        mouseButton = MouseButton.RIGHT;
                        break;
                    }
                    case 2: {
                        mouseButton = MouseButton.CENTER;
                        break;
                    }
                    default: {
                        mouseButton = MouseButton.NONE;
                    }
                }
                MouseButton mouseButton2 = mouseButton;
                Set modifiers = new LinkedHashSet<E>();
                BitSet buttonsDown = new BitSet();
                if ((mods & 1) != 0) {
                    modifiers.add(KeyboardModifier.SHIFT);
                }
                if ((mods & 4) != 0) {
                    modifiers.add(KeyboardModifier.ALT);
                }
                if ((mods & 2) != 0) {
                    modifiers.add(KeyboardModifier.CTRL);
                }
                if ((mods & 8) != 0) {
                    modifiers.add(KeyboardModifier.SUPER);
                }
                if (action == 1) {
                    this.$down.element = true;
                    this.$lastDragPosition.element = ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getPosition();
                    ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getButtonDown().trigger(new Program.Mouse.MouseEvent(ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.BUTTON_DOWN, mouseButton2, modifiers, false, 64, null));
                    buttonsDown.set(button, true);
                }
                if (action == 0) {
                    this.$down.element = false;
                    ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getButtonUp().trigger(new Program.Mouse.MouseEvent(ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.BUTTON_UP, mouseButton2, modifiers, false, 64, null));
                    buttonsDown.set(button, false);
                    ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getClicked().trigger(new Program.Mouse.MouseEvent(ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getPosition(), Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.CLICKED, mouseButton2, modifiers, false, 64, null));
                }
            }
            {
                this.this$0 = applicationGL3;
                this.$down = booleanRef;
                this.$lastDragPosition = objectRef;
            }
        });
        GLFW.glfwSetCursorPosCallback(this.window, new GLFWCursorPosCallbackI(this, (Ref.ObjectRef)globalModifiers, (Ref.BooleanRef)down, (Ref.ObjectRef)lastDragPosition){
            final /* synthetic */ ApplicationGL3 this$0;
            final /* synthetic */ Ref.ObjectRef $globalModifiers;
            final /* synthetic */ Ref.BooleanRef $down;
            final /* synthetic */ Ref.ObjectRef $lastDragPosition;

            public final void invoke(long $noName_0, double xpos, double ypos) {
                Vector2 position = ApplicationGL3.access$getFixWindowSize$p(this.this$0) ? new Vector2(xpos, ypos).div(ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getScale()) : new Vector2(xpos, ypos);
                ApplicationGL3Kt.access$getLogger$p().trace((Function0<? extends Object>)new Function0<String>(xpos, ypos, position){
                    final /* synthetic */ double $xpos;
                    final /* synthetic */ double $ypos;
                    final /* synthetic */ Vector2 $position;

                    @NotNull
                    public final String invoke() {
                        return "mouse moved " + this.$xpos + ' ' + this.$ypos + " -- " + this.$position;
                    }
                    {
                        this.$xpos = d;
                        this.$ypos = d2;
                        this.$position = vector2;
                        super(0);
                    }
                });
                ApplicationGL3.access$getProgram$p(this.this$0).getMouse().setPosition(position);
                ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getMoved().trigger(new Program.Mouse.MouseEvent(position, Vector2.Companion.getZERO(), Vector2.Companion.getZERO(), MouseEventType.MOVED, MouseButton.NONE, (Set)this.$globalModifiers.element, false, 64, null));
                if (this.$down.element) {
                    ApplicationGL3.access$getProgram$p(this.this$0).getMouse().getDragged().trigger(new Program.Mouse.MouseEvent(position, Vector2.Companion.getZERO(), position.minus((Vector2)this.$lastDragPosition.element), MouseEventType.DRAGGED, MouseButton.NONE, (Set)this.$globalModifiers.element, false, 64, null));
                    this.$lastDragPosition.element = position;
                }
            }
            {
                this.this$0 = applicationGL3;
                this.$globalModifiers = objectRef;
                this.$down = booleanRef;
                this.$lastDragPosition = objectRef2;
            }
        });
        GLFW.glfwSetCursorEnterCallback(this.window, loop.7.INSTANCE);
        ProgramRenderTargetGL3 defaultRenderTarget = new ProgramRenderTargetGL3(this.program);
        defaultRenderTarget.bind();
        if (this.configuration.getShowBeforeSetup()) {
            ApplicationGL3Kt.access$getLogger$p().debug(loop.8.INSTANCE);
            GL11.glDepthMask(true);
            GL11.glClearColor(0.5f, 0.5f, 0.5f, 0.0f);
            GL11.glClear(17664);
            GLFW.glfwSwapBuffers(this.window);
            GL11.glClearColor(0.5f, 0.5f, 0.5f, 0.0f);
            GL11.glClear(17664);
            GL11.glDepthMask(false);
            GLFW.glfwPollEvents();
        }
        ApplicationGL3Kt.access$getLogger$p().debug(loop.9.INSTANCE);
        ApplicationGL3Kt.access$getLogger$p().debug(loop.10.INSTANCE);
        String string = "opengl vendor: " + GL11.glGetString(7936);
        System.out.println((Object)string);
        string = "opengl version: " + GL11.glGetString(7938);
        System.out.println((Object)string);
        if (this.configuration.getHideCursor()) {
            GLFW.glfwSetInputMode(this.window, 208897, 212994);
        }
        ApplicationGL3Kt.access$getLogger$p().debug(loop.11.INSTANCE);
        this.program.setup();
        this.setupCalled = true;
        this.startTimeMillis = System.currentTimeMillis();
        GLFW.glfwSwapInterval(1);
        Throwable exception = null;
        while (!this.exitRequested && !GLFW.glfwWindowShouldClose(this.window) && (exception = this.drawFrame()) == null) {
            GLFW.glfwSwapBuffers(this.window);
            if (!this.windowFocused && Intrinsics.areEqual((Object)this.configuration.getUnfocusBehaviour(), (Object)UnfocusBehaviour.THROTTLE)) {
                Thread.sleep(100L);
            }
            GLFW.glfwPollEvents();
        }
        ApplicationGL3Kt.access$getLogger$p().info(loop.12.INSTANCE);
        Callbacks.glfwFreeCallbacks(this.window);
        GLFW.glfwDestroyWindow(this.window);
        ApplicationGL3Kt.access$getLogger$p().info(loop.13.INSTANCE);
        Throwable throwable = exception;
        if (throwable != null) {
            Throwable throwable2;
            Throwable it2 = throwable2 = throwable;
            throw it2;
        }
    }

    private final Throwable drawFrame() {
        this.setupSizes();
        GL30.glBindVertexArray(this.vaos[0]);
        this.program.getDrawer().reset();
        this.program.getDrawer().ortho();
        this.program.getWindow().getDrop().deliver();
        this.program.getWindow().getSized().deliver();
        this.program.getKeyboard().getKeyDown().deliver();
        this.program.getKeyboard().getKeyUp().deliver();
        this.program.getKeyboard().getKeyRepeat().deliver();
        this.program.getMouse().getMoved().deliver();
        this.program.getMouse().getScrolled().deliver();
        this.program.getMouse().getClicked().deliver();
        this.program.getMouse().getButtonDown().deliver();
        this.program.getMouse().getButtonUp().deliver();
        this.program.getMouse().getDragged().deliver();
        try {
            ApplicationGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(this){
                final /* synthetic */ ApplicationGL3 this$0;

                @NotNull
                public final String invoke() {
                    return "window: " + (int)ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getSize().getX() + 'x' + (int)ApplicationGL3.access$getProgram$p(this.this$0).getWindow().getSize().getY() + " program: " + ApplicationGL3.access$getProgram$p(this.this$0).getWidth() + 'x' + ApplicationGL3.access$getProgram$p(this.this$0).getHeight();
                }
                {
                    this.this$0 = applicationGL3;
                    super(0);
                }
            });
            this.program.drawImpl();
        }
        catch (Throwable e) {
            ApplicationGL3Kt.access$getLogger$p().error(drawFrame.2.INSTANCE);
            e.printStackTrace();
            return e;
        }
        return null;
    }

    private final void setupSizes() {
        float[] wcsx = new float[1];
        float[] wcsy = new float[1];
        GLFW.glfwGetWindowContentScale(this.window, wcsx, wcsy);
        this.program.getWindow().setScale(new Vector2(wcsx[0], wcsy[0]));
        int[] fbw = new int[1];
        int[] fbh = new int[1];
        GLFW.glfwGetFramebufferSize(this.window, fbw, fbh);
        GL11.glViewport(0, 0, fbw[0], fbh[0]);
        this.program.setWidth((int)((double)fbw[0] / this.program.getWindow().getScale().getX()));
        this.program.setHeight((int)((double)fbh[0] / this.program.getWindow().getScale().getY()));
        this.program.getWindow().setSize(new Vector2(this.program.getWidth(), this.program.getHeight()));
        this.program.getDrawer().setWidth(this.program.getWidth());
        this.program.getDrawer().setHeight(this.program.getHeight());
    }

    private final Set<KeyboardModifier> modifierSet(int mods) {
        Set modifiers = new LinkedHashSet();
        if ((mods & 1) != 0) {
            modifiers.add(KeyboardModifier.SHIFT);
        }
        if ((mods & 4) != 0) {
            modifiers.add(KeyboardModifier.ALT);
        }
        if ((mods & 2) != 0) {
            modifiers.add(KeyboardModifier.CTRL);
        }
        if ((mods & 8) != 0) {
            modifiers.add(KeyboardModifier.SUPER);
        }
        return modifiers;
    }

    @Override
    public void exit() {
        this.exitRequested = true;
    }

    public ApplicationGL3(@NotNull Program program, @NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull(program, "program");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        this.program = program;
        this.configuration = configuration;
        this.windowFocused = true;
        this.realWindowTitle = this.configuration.getTitle();
        String string = System.getProperty("os.name");
        Intrinsics.checkExpressionValueIsNotNull(string, "System.getProperty(\"os.name\")");
        this.fixWindowSize = StringsKt.contains((CharSequence)string, "windows", true);
        this.startTimeMillis = System.currentTimeMillis();
        ApplicationGL3Kt.access$getLogger$p().debug(1.INSTANCE);
        ApplicationGL3Kt.access$getLogger$p().trace(2.INSTANCE);
        this.driver = new DriverGL3();
        Driver.Companion.setDriver(this.driver);
        this.program.setApplication(this);
        this.createPrimaryWindow();
        this.vaos = new int[1];
    }

    public static final /* synthetic */ long access$getWindow$p(ApplicationGL3 $this) {
        return $this.window;
    }

    public static final /* synthetic */ void access$setWindow$p(ApplicationGL3 $this, long l) {
        $this.window = l;
    }

    public static final /* synthetic */ boolean access$getSetupCalled$p(ApplicationGL3 $this) {
        return $this.setupCalled;
    }

    public static final /* synthetic */ void access$setSetupCalled$p(ApplicationGL3 $this, boolean bl) {
        $this.setupCalled = bl;
    }

    @Nullable
    public static final /* synthetic */ Throwable access$drawFrame(ApplicationGL3 $this) {
        return $this.drawFrame();
    }

    public static final /* synthetic */ void access$setupSizes(ApplicationGL3 $this) {
        $this.setupSizes();
    }

    @NotNull
    public static final /* synthetic */ Program access$getProgram$p(ApplicationGL3 $this) {
        return $this.program;
    }

    public static final /* synthetic */ boolean access$getWindowFocused$p(ApplicationGL3 $this) {
        return $this.windowFocused;
    }

    public static final /* synthetic */ void access$setWindowFocused$p(ApplicationGL3 $this, boolean bl) {
        $this.windowFocused = bl;
    }

    @NotNull
    public static final /* synthetic */ Set access$modifierSet(ApplicationGL3 $this, int mods) {
        return $this.modifierSet(mods);
    }

    public static final /* synthetic */ boolean access$getFixWindowSize$p(ApplicationGL3 $this) {
        return $this.fixWindowSize;
    }
}

