/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.Shader;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.transforms.TransformsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/openrndr/draw/DrawContext;", "", "model", "Lorg/openrndr/math/Matrix44;", "view", "projection", "width", "", "height", "(Lorg/openrndr/math/Matrix44;Lorg/openrndr/math/Matrix44;Lorg/openrndr/math/Matrix44;II)V", "getHeight", "()I", "getModel", "()Lorg/openrndr/math/Matrix44;", "getProjection", "getView", "getWidth", "applyToShader", "", "shader", "Lorg/openrndr/draw/Shader;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "openrndr-core"})
public final class DrawContext {
    @NotNull
    private final Matrix44 model;
    @NotNull
    private final Matrix44 view;
    @NotNull
    private final Matrix44 projection;
    private final int width;
    private final int height;

    public final void applyToShader(@NotNull Shader shader2) {
        Matrix44 normalMatrix;
        Intrinsics.checkParameterIsNotNull(shader2, "shader");
        if (shader2.hasUniform("u_viewMatrix")) {
            shader2.uniform("u_viewMatrix", this.view);
        }
        if (shader2.hasUniform("u_modelMatrix")) {
            shader2.uniform("u_modelMatrix", this.model);
        }
        if (shader2.hasUniform("u_projectionMatrix")) {
            shader2.uniform("u_projectionMatrix", this.projection);
        }
        if (shader2.hasUniform("u_viewProjectionMatrix")) {
            shader2.uniform("u_viewProjectionMatrix", this.projection.times(this.view));
        }
        if (shader2.hasUniform("u_viewDimensions")) {
            shader2.uniform("u_viewDimensions", new Vector2(this.width, this.height));
        }
        if (shader2.hasUniform("u_modelNormalMatrix")) {
            Matrix44 matrix44;
            if (this.model == DrawerKt.access$getLastModel$p()) {
                matrix44 = DrawerKt.access$getLastModelNormal$p();
            } else {
                DrawerKt.access$setLastModelNormal$p(this.model != Matrix44.Companion.getIDENTITY() ? TransformsKt.normalMatrix(this.model) : Matrix44.Companion.getIDENTITY());
                DrawerKt.access$setLastModel$p(this.model);
                matrix44 = DrawerKt.access$getLastModelNormal$p();
            }
            normalMatrix = matrix44;
            shader2.uniform("u_modelNormalMatrix", normalMatrix);
        }
        if (shader2.hasUniform("u_viewNormalMatrix")) {
            Matrix44 matrix44;
            if (this.view == DrawerKt.access$getLastView$p()) {
                matrix44 = DrawerKt.access$getLastViewNormal$p();
            } else {
                DrawerKt.access$setLastViewNormal$p(this.view != Matrix44.Companion.getIDENTITY() ? TransformsKt.normalMatrix(this.view) : Matrix44.Companion.getIDENTITY());
                DrawerKt.access$setLastView$p(this.view);
                matrix44 = DrawerKt.access$getLastViewNormal$p();
            }
            normalMatrix = matrix44;
            shader2.uniform("u_viewNormalMatrix", normalMatrix);
        }
    }

    @NotNull
    public final Matrix44 getModel() {
        return this.model;
    }

    @NotNull
    public final Matrix44 getView() {
        return this.view;
    }

    @NotNull
    public final Matrix44 getProjection() {
        return this.projection;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public DrawContext(@NotNull Matrix44 model, @NotNull Matrix44 view, @NotNull Matrix44 projection, int width, int height) {
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(view, "view");
        Intrinsics.checkParameterIsNotNull(projection, "projection");
        this.model = model;
        this.view = view;
        this.projection = projection;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public final Matrix44 component1() {
        return this.model;
    }

    @NotNull
    public final Matrix44 component2() {
        return this.view;
    }

    @NotNull
    public final Matrix44 component3() {
        return this.projection;
    }

    public final int component4() {
        return this.width;
    }

    public final int component5() {
        return this.height;
    }

    @NotNull
    public final DrawContext copy(@NotNull Matrix44 model, @NotNull Matrix44 view, @NotNull Matrix44 projection, int width, int height) {
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(view, "view");
        Intrinsics.checkParameterIsNotNull(projection, "projection");
        return new DrawContext(model, view, projection, width, height);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ DrawContext copy$default(DrawContext drawContext, Matrix44 matrix44, Matrix44 matrix442, Matrix44 matrix443, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            matrix44 = drawContext.model;
        }
        if ((n4 & 2) != 0) {
            matrix442 = drawContext.view;
        }
        if ((n4 & 4) != 0) {
            matrix443 = drawContext.projection;
        }
        if ((n4 & 8) != 0) {
            n2 = drawContext.width;
        }
        if ((n4 & 0x10) != 0) {
            n3 = drawContext.height;
        }
        return drawContext.copy(matrix44, matrix442, matrix443, n2, n3);
    }

    public String toString() {
        return "DrawContext(model=" + this.model + ", view=" + this.view + ", projection=" + this.projection + ", width=" + this.width + ", height=" + this.height + ")";
    }

    public int hashCode() {
        Matrix44 matrix44 = this.model;
        Matrix44 matrix442 = this.view;
        Matrix44 matrix443 = this.projection;
        return ((((matrix44 != null ? ((Object)matrix44).hashCode() : 0) * 31 + (matrix442 != null ? ((Object)matrix442).hashCode() : 0)) * 31 + (matrix443 != null ? ((Object)matrix443).hashCode() : 0)) * 31 + Integer.hashCode(this.width)) * 31 + Integer.hashCode(this.height);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DrawContext)) break block3;
                DrawContext drawContext = (DrawContext)object;
                if (!Intrinsics.areEqual(this.model, drawContext.model) || !Intrinsics.areEqual(this.view, drawContext.view) || !Intrinsics.areEqual(this.projection, drawContext.projection) || !(this.width == drawContext.width) || !(this.height == drawContext.height)) break block3;
            }
            return true;
        }
        return false;
    }
}

